/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.crw;

import it.tidalwave.imageio.crw.CIFFTag;
import it.tidalwave.imageio.crw.CanonCRWMakerNote;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Date;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CRWMetadata
extends TIFFMetadataSupport {
    private static final String CLASS = CRWMetadata.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private CanonCRWMakerNote canonMakerNote;
    private static final int[] WHITE_BALANCE_MAP = new int[]{1, 2, 3, 4, 5, 1};
    private static final int[] WHITE_BALANCE_MAP_10D = new int[]{0, 1, 3, 4, 5, 6, 0, 0, 2, 8};
    private static final int[] WHITE_BALANCE_MAP_S70 = new int[]{0, 1, 2, 9, 4, 3, 6, 7, 8, 9, 10, 0, 0, 0, 7, 0, 0, 8};
    private static final int[] RB_OBFUSCATOR = new int[]{1040, 17907};
    private static final int[] NO_OBFUSCATOR = new int[]{0, 0};
    private static final String[] WHITE_BALANCE_NAMES = new String[]{"auto", "daylight", "cloudy", "tungsten", "fluorescent", "flash", "custom", "b&w", "shade"};

    public CRWMetadata(@Nonnull CanonCRWMakerNote canonMakerNote, @Nonnull Directory imageIFD, @Nonnull RAWImageInputStream iis, @Nonnull HeaderProcessor headerProcessor) {
        super((Directory)((IFD)imageIFD), iis, headerProcessor);
        this.canonMakerNote = canonMakerNote;
    }

    public CanonCRWMakerNote getCanonMakerNote() {
        return this.canonMakerNote;
    }

    @Nonnegative
    public int getFileNumber() {
        return this.findTag(CanonCRWMakerNote.FILE_NUMBER).getIntValues()[0];
    }

    @Nonnegative
    public int getImageWidth() {
        return this.findTag(CanonCRWMakerNote.IMAGE_INFO).getIntValues()[0];
    }

    @Nonnegative
    public int getImageHeight() {
        return this.findTag(CanonCRWMakerNote.IMAGE_INFO).getIntValues()[1];
    }

    @Nonnegative
    public int getThumbnailWidth() {
        return this.findTag(CanonCRWMakerNote.THUMBNAIL_INFO).getIntValues()[3];
    }

    @Nonnegative
    public int getThumbnailHeight() {
        return this.findTag(CanonCRWMakerNote.THUMBNAIL_INFO).getIntValues()[4];
    }

    @Nonnegative
    public float getPixelAspectRatio() {
        return this.findTag(CanonCRWMakerNote.IMAGE_INFO).getFloatValues()[2];
    }

    public int getRotation() {
        return this.findTag(CanonCRWMakerNote.IMAGE_INFO).getIntValues()[3];
    }

    @Nonnegative
    public int getComponentBitDepth() {
        return this.findTag(CanonCRWMakerNote.IMAGE_INFO).getIntValues()[4];
    }

    @Nonnegative
    public int getColorBitDepth() {
        return this.findTag(CanonCRWMakerNote.IMAGE_INFO).getIntValues()[5];
    }

    public int getColorBW() {
        return this.findTag(CanonCRWMakerNote.IMAGE_INFO).getIntValues()[6];
    }

    @Nonnull
    public Date getTimeStampAsDate() {
        return new Date((long)this.findTag(CanonCRWMakerNote.TIME_STAMP).getIntValues()[0] * 1000L);
    }

    @Nonnegative
    public int getBaseISO() {
        return this.findTag(CanonCRWMakerNote.BASE_ISO).getIntValues()[0];
    }

    @Nonnull
    public String getFirmwareVersion() {
        return this.findTag(CanonCRWMakerNote.CANON_FIRMWARE_VERSION).getASCIIValue();
    }

    @Nonnull
    public String getModel() {
        String s = this.findTag(CanonCRWMakerNote.CANON_RAW_MAKE_MODEL).getASCIIValue();
        int i = s.indexOf(0);
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        return s;
    }

    @Nonnegative
    public int getSensorWidth() {
        return this.findTag(CanonCRWMakerNote.SENSOR_INFO).getIntValues()[1];
    }

    @Nonnegative
    public int getSensorHeight() {
        return this.findTag(CanonCRWMakerNote.SENSOR_INFO).getIntValues()[2];
    }

    @Nonnegative
    public int getSensorLeftBorder() {
        return this.findTag(CanonCRWMakerNote.SENSOR_INFO).getIntValues()[5];
    }

    @Nonnegative
    public int getSensorTopBorder() {
        return this.findTag(CanonCRWMakerNote.SENSOR_INFO).getIntValues()[6];
    }

    @Nonnegative
    public int getSensorRightBorder() {
        return this.findTag(CanonCRWMakerNote.SENSOR_INFO).getIntValues()[7];
    }

    @Nonnegative
    public int getSensorBottomBorder() {
        return this.findTag(CanonCRWMakerNote.SENSOR_INFO).getIntValues()[8];
    }

    @Nonnegative
    public float getFocalLength() {
        return this.findTag(CanonCRWMakerNote.FOCAL_LENGTH).getIntValues()[1];
    }

    public int getSerialNumber() {
        return this.findTag(CanonCRWMakerNote.SERIAL_NUMBER).getIntValues()[0];
    }

    @Nonnull
    public int[] getDecoderTable() {
        return this.findTag(CanonCRWMakerNote.DECODER_TABLE).getIntValues();
    }

    @Nonnull
    public CanonCRWMakerNote findCameraSettings() {
        return this.findDirectory(CanonCRWMakerNote.CANON_CAMERA_SETTINGS);
    }

    public int getWhiteBalance() {
        int wb = this.findTag(CanonCRWMakerNote.CANON_SHOT_INFO).getIntValues()[14];
        String model = this.getModel();
        if (wb == 6 && ("Canon EOS DIGITAL REBEL".equals(model) || "Canon EOS 300D DIGITAL".equals(model))) {
            ++wb;
        }
        if ("Canon EOS 10D".equals(model)) {
            wb = WHITE_BALANCE_MAP_10D[wb];
        }
        return wb;
    }

    @Nonnull
    public String getWhiteBalanceAsString() {
        int whiteBalance = this.getWhiteBalance();
        return whiteBalance < WHITE_BALANCE_NAMES.length ? WHITE_BALANCE_NAMES[whiteBalance] : "" + whiteBalance;
    }

    @Nonnull
    public double[] getRBCoefficients() {
        int[] xx;
        double[] rbCoefficients = new double[]{1.0, 1.0};
        int wb = this.getWhiteBalance();
        CIFFTag d60tag = this.findTag(CanonCRWMakerNote.D60_RED_BLUE_COEFFICIENTS);
        CIFFTag d30tag = this.findTag(CanonCRWMakerNote.D30_WHITE_BALANCE);
        CIFFTag g2tag = this.findTag(CanonCRWMakerNote.G2_WHITE_BALANCE);
        String model = this.getModel();
        if (d30tag != null) {
            ShortBuffer sb = ByteBuffer.wrap(d30tag.getByteValues()).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
            short[] xx2 = new short[sb.capacity()];
            sb.get(xx2);
            int scan = 36;
            logger.fine("GETTING RB COEFF FROM D30 TAG AT %d", scan);
            int[] obfuscator = NO_OBFUSCATOR;
            if ("Canon PowerShot G6".equals(model) || "Canon PowerShot S60".equals(model) || "Canon PowerShot S70".equals(model) || "Canon PowerShot Pro1".equals(model)) {
                obfuscator = RB_OBFUSCATOR;
            }
            rbCoefficients[0] = (double)(xx2[scan + 1] & 0xFFFF ^ obfuscator[1]) / (double)(xx2[scan + 0] & 0xFFFF ^ obfuscator[0]);
            rbCoefficients[1] = (double)(xx2[scan + 2] & 0xFFFF ^ obfuscator[0]) / (double)(xx2[scan + 3] & 0xFFFF ^ obfuscator[1]);
        } else if (g2tag != null) {
            xx = g2tag.getIntValues();
            int scan = 50;
            logger.fine("GETTING RB COEFF FROM G2 TAG AT %d", 50);
            rbCoefficients[0] = (double)(xx[51] ^ RB_OBFUSCATOR[1]) / (double)(xx[50] ^ RB_OBFUSCATOR[0]);
            rbCoefficients[1] = (double)(xx[52] ^ RB_OBFUSCATOR[0]) / (double)(xx[53] ^ RB_OBFUSCATOR[1]);
        }
        if (d60tag != null) {
            xx = d60tag.getIntValues();
            int scan = 1 + wb * 4;
            logger.fine("GETTING RB COEFF FROM D60 TAG AT %d", scan);
            rbCoefficients[0] = (double)xx[scan + 0] / (double)xx[scan + 1];
            rbCoefficients[1] = (double)xx[scan + 3] / (double)xx[scan + 2];
        } else {
            logger.warning("WARNING getRBCoefficients() NO COEFF", new Object[0]);
        }
        return rbCoefficients;
    }

    public boolean isColorTemperatureAvailable() {
        return this.findTag(CanonCRWMakerNote.COLOR_TEMPERATURE) != null;
    }

    @Nonnegative
    public int getColorTemperature() {
        return this.findTag(CanonCRWMakerNote.COLOR_TEMPERATURE).getIntValues()[0];
    }

    @Nonnull
    public String toString() {
        double[] rbCoefficients;
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append("\n>>>>FileNumber: " + this.getFileNumber());
        buffer.append("\n>>>>FocalLengh: " + this.getFocalLength());
        buffer.append("\n>>>>ImageWidth: " + this.getImageWidth());
        buffer.append("\n>>>>ImageHeight: " + this.getImageHeight());
        buffer.append("\n>>>>PixelAspectRatio: " + this.getPixelAspectRatio());
        buffer.append("\n>>>>Rotation: " + this.getRotation());
        buffer.append("\n>>>>ComponentBitDepth: " + this.getComponentBitDepth());
        buffer.append("\n>>>>ColorBitDepth: " + this.getColorBitDepth());
        buffer.append("\n>>>>ColorBW: " + this.getColorBW());
        buffer.append("\n>>>>TimeStampAsDate: " + this.getTimeStampAsDate());
        buffer.append("\n>>>>BaseISO: " + this.getBaseISO());
        buffer.append("\n>>>>FirmwareVersion: " + this.getFirmwareVersion());
        buffer.append("\n>>>>Model: " + this.getModel());
        buffer.append("\n>>>>SensorWidth: " + this.getSensorWidth());
        buffer.append("\n>>>>SensorHeight: " + this.getSensorHeight());
        buffer.append("\n>>>>SensorLeftBorder: " + this.getSensorLeftBorder());
        buffer.append("\n>>>>SensorTopBorder: " + this.getSensorTopBorder());
        buffer.append("\n>>>>SensorRightBorder: " + this.getSensorRightBorder());
        buffer.append("\n>>>>SensorBottomBorder: " + this.getSensorBottomBorder());
        buffer.append("\n>>>>WhiteBalance: " + this.getWhiteBalance() + " - " + this.getWhiteBalanceAsString());
        if (this.isColorTemperatureAvailable()) {
            buffer.append("\n>>>>ColorTemperature: " + this.getColorTemperature());
        }
        if ((rbCoefficients = this.getRBCoefficients()) != null) {
            buffer.append("\n>>>>Red-Blue Coefficients: " + rbCoefficients[0] + ", " + rbCoefficients[1]);
        }
        return buffer.toString();
    }

    @Nonnull
    protected Dimension getImageSize() {
        return new Dimension(this.getSensorWidth(), this.getSensorHeight());
    }

    @Nonnull
    private CIFFTag findTag(@Nonnull CanonCRWMakerNote dir, @Nonnull Object code) {
        CIFFTag tag;
        block1: {
            CanonCRWMakerNote subDir;
            tag = (CIFFTag)dir.getTag(code);
            if (tag != null) break block1;
            Iterator<Directory> i = dir.getSubDirectories().iterator();
            while (i.hasNext() && (tag = this.findTag(subDir = (CanonCRWMakerNote)i.next(), code)) == null) {
            }
        }
        return tag;
    }

    @Nonnull
    private CIFFTag findTag(@Nonnull Object code) {
        return this.findTag(this.canonMakerNote, code);
    }

    @Nonnull
    private CanonCRWMakerNote findDirectory(@Nonnull CanonCRWMakerNote dir, @Nonnull Object code) {
        if (dir.containsTag(code)) {
            return dir;
        }
        for (CanonCRWMakerNote canonCRWMakerNote : dir.getSubDirectories()) {
            CanonCRWMakerNote d2 = this.findDirectory(canonCRWMakerNote, code);
            if (d2 == null) continue;
            return d2;
        }
        return null;
    }

    @Nonnull
    private CanonCRWMakerNote findDirectory(@Nonnull Object code) {
        return this.findDirectory(this.canonMakerNote, code);
    }
}

