/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.io;

import it.tidalwave.imageio.io.BitReader;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

class TwelveBitsReader
extends BitReader {
    private int[] buffer;
    private int bufferPointer;

    public TwelveBitsReader(ImageInputStream iis, int bufferSize) {
        this.iis = iis;
        this.buffer = new int[2];
        this.byteBuffer = new byte[bufferSize];
        this.bufferPointer = this.buffer.length;
        this.bytePointer = this.byteBuffer.length;
    }

    public void resync() {
        this.bufferPointer = this.buffer.length;
        this.bytePointer = this.buffer.length;
    }

    public int readBits(int bitsToGet) throws IOException {
        if (bitsToGet != 12) {
            throw new IllegalArgumentException("TwelveBitReader only reads 12 bits");
        }
        if (this.bufferPointer >= this.buffer.length) {
            this.bufferPointer = 0;
            if (this.bytePointer >= this.byteBuffer.length) {
                this.bytePointer = 0;
                this.iis.readFully(this.byteBuffer);
            }
            int b0 = this.byteBuffer[this.bytePointer++] & 0xFF;
            int b1 = this.byteBuffer[this.bytePointer++] & 0xFF;
            int b2 = this.byteBuffer[this.bytePointer++] & 0xFF;
            this.buffer[0] = b0 << 4 | b1 >>> 4;
            this.buffer[1] = (b1 & 0xF) << 8 | b2;
        }
        this.bitPosition = this.bufferPointer == 0 ? 4 : 0;
        return this.buffer[this.bufferPointer++];
    }

    public void skipBits(int bitsToSkip) {
        if (bitsToSkip % 8 != 0) {
            throw new IllegalArgumentException("TwelveBitReader.skipBits(): only multiple of 8");
        }
        int bytes = bitsToSkip / 8;
        this.bytePointer += bytes;
    }

    public void setBitOffset(int bitPosition) {
        if (bitPosition != 0 && bitPosition != 4) {
            throw new IllegalArgumentException("bitPosition can be only 0 or 4");
        }
        throw new UnsupportedOperationException();
    }

    public long getStreamPosition() throws IOException {
        long p = this.iis.getStreamPosition() - (long)this.bufferSize + (long)this.bytePointer + 1L;
        if (this.bufferPointer == 1) {
            ++p;
        }
        return p;
    }

    public void setSkipZeroAfterFF(boolean skipZeroAfterFF) {
        throw new UnsupportedOperationException();
    }
}

