/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.nef;

import it.tidalwave.imageio.nef.NEFRasterReader;
import javax.annotation.Nonnegative;

public class RasterReader_NIKON_D100
extends NEFRasterReader {
    private static final int D100_PADDED_SIZE = 9844736;
    private static final int D100_INTERLEAVE_COUNT = 10;
    private static final int D100_INTERLEAVE_PAD_BITS = 8;
    private static final int D100_PADDED_ROW_PAD_BITS = 80;
    private boolean padded;

    public boolean isCompressedRaster() {
        this.padded = this.compression == 34713 && this.stripByteCount == 9844736;
        return this.compression == 34713 && this.stripByteCount != 9844736;
    }

    @Nonnegative
    protected int getSkipCountAtColumn(@Nonnegative int x) {
        if (this.padded && (x - 1) % 10 == 9) {
            return 8;
        }
        return 0;
    }

    @Nonnegative
    protected int getSkipCountAtEndOfRow(int par0, int height) {
        return this.padded ? 80 : 0;
    }
}

