/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.orf;

import it.tidalwave.imageio.orf.CSeriesRasterReader;
import it.tidalwave.imageio.orf.E300RasterReader;
import it.tidalwave.imageio.orf.E410RasterReader;
import it.tidalwave.imageio.orf.SPRasterReader;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.util.Logger;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class ORFRasterReader
extends RasterReader {
    private static final String CLASS = ORFRasterReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final CSeriesRasterReader C_SERIES_RASTER_READER = new CSeriesRasterReader();
    private static final E300RasterReader E300_RASTER_READER = new E300RasterReader();
    private static final E410RasterReader E410_RASTER_READER = new E410RasterReader();
    private static final SPRasterReader SP_RASTER_READER = new SPRasterReader();
    private static final Map<String, RasterReader> RASTER_READER_MAP_BY_MODEL = new HashMap<String, RasterReader>();

    @Nonnull
    public static RasterReader getInstance(@Nonnull String model) {
        logger.fine("getInstance(%s)", model);
        model = model.toUpperCase().trim();
        RasterReader rasterReader = RASTER_READER_MAP_BY_MODEL.get(model);
        if (rasterReader != null) {
            return rasterReader;
        }
        if (model.startsWith("C")) {
            return C_SERIES_RASTER_READER;
        }
        return new ORFRasterReader();
    }

    @Nonnull
    public String toString() {
        return String.format("ORFRasterReader@%x", System.identityHashCode(this));
    }

    static {
        RASTER_READER_MAP_BY_MODEL.put("E-300", E300_RASTER_READER);
        RASTER_READER_MAP_BY_MODEL.put("E-330", E300_RASTER_READER);
        RASTER_READER_MAP_BY_MODEL.put("E-410", E410_RASTER_READER);
        RASTER_READER_MAP_BY_MODEL.put("E-420", E410_RASTER_READER);
        RASTER_READER_MAP_BY_MODEL.put("E-500", E300_RASTER_READER);
        RASTER_READER_MAP_BY_MODEL.put("E-510", E410_RASTER_READER);
        RASTER_READER_MAP_BY_MODEL.put("E-620", E410_RASTER_READER);
        RASTER_READER_MAP_BY_MODEL.put("C5050Z", SP_RASTER_READER);
        RASTER_READER_MAP_BY_MODEL.put("SP350", SP_RASTER_READER);
        RASTER_READER_MAP_BY_MODEL.put("SP500UZ", SP_RASTER_READER);
        RASTER_READER_MAP_BY_MODEL.put("E-3", E410_RASTER_READER);
    }
}

