/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raw;

import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.IFDGenerated;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Properties;
import javax.annotation.Nonnull;

public class RotateOperation
extends OperationSupport {
    private static final Logger logger = RotateOperation.getLogger(RotateOperation.class);
    private int rotation;

    public RotateOperation() {
        super(Source.Type.RAW, Source.Type.NORMAL);
    }

    public void init(@Nonnull PipelineArtifact artifact) {
        logger.fine("init(%s)", artifact);
        this.rotation = this.getCameraOrientation(artifact);
        if (this.rotation != 0) {
            artifact.setRotation(this.rotation);
        }
    }

    public void process(@Nonnull PipelineArtifact artifact) {
        logger.fine("process(%s)", artifact);
        if (this.rotation != 0) {
            artifact.setImage(RotateOperation.rotateQuadrant(artifact.getImage(), this.rotation));
        }
    }

    protected int getCameraOrientation(@Nonnull PipelineArtifact artifact) {
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)artifact.getRAWMetadata();
        IFD primaryIFD = metadata.getPrimaryIFD();
        IFD exifIFD = metadata.getExifIFD();
        int orientation = 0;
        IFDGenerated.Orientation tiffOrientation = null;
        if (primaryIFD.isOrientationAvailable()) {
            tiffOrientation = primaryIFD.getOrientation();
        } else if (exifIFD.isOrientationAvailable()) {
            tiffOrientation = exifIFD.getOrientation();
        }
        if (tiffOrientation == IFDGenerated.Orientation.LEFT_BOTTOM) {
            orientation = -90;
        }
        if (tiffOrientation == IFDGenerated.Orientation.RIGHT_TOP) {
            orientation = 90;
        }
        logger.finer(">>>> camera orientation: %s, degrees: %d", tiffOrientation, orientation);
        return orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected static BufferedImage rotateQuadrant(@Nonnull BufferedImage image, int degrees) {
        logger.finer("rotateQuadrant(%d)", degrees);
        RotateOperation.logImage(logger, ">>>> image: ", image);
        SampleModel sampleModel = image.getSampleModel();
        if (degrees < 0) {
            degrees += 360;
        }
        if (degrees == 90 || degrees == 270) {
            sampleModel = sampleModel.createCompatibleSampleModel(image.getHeight(), image.getWidth());
        }
        WritableRaster newRaster = Raster.createWritableRaster(sampleModel, null);
        ColorModel colorModel = image.getColorModel();
        BufferedImage result = new BufferedImage(colorModel, newRaster, false, RotateOperation.getProperties(image));
        Graphics2D g2d = (Graphics2D)result.getGraphics();
        try {
            double radians = Math.toRadians(degrees);
            g2d.transform(AffineTransform.getRotateInstance(radians));
            int x = 0;
            int y = 0;
            switch (degrees) {
                case 90: {
                    y = -image.getHeight();
                    break;
                }
                case 180: {
                    x = -image.getWidth();
                    y = -image.getHeight();
                    break;
                }
                case 270: {
                    x = -image.getWidth();
                }
            }
            g2d.drawImage((Image)image, x, y, null);
        }
        finally {
            g2d.dispose();
        }
        RotateOperation.logImage(logger, ">>>> rotateQuadrant() returning ", result);
        return result;
    }

    @Nonnull
    private static Properties getProperties(@Nonnull BufferedImage image) {
        Properties properties = new Properties();
        String[] propertyNames = image.getPropertyNames();
        if (propertyNames != null) {
            for (int i = 0; i < propertyNames.length; ++i) {
                String propertyName = propertyNames[i];
                Object propertyValue = image.getProperty(propertyName);
                properties.setProperty(propertyName, propertyValue.toString());
            }
        }
        return properties;
    }
}

