/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;
import java.text.DecimalFormat;

public class ExifDescriptor
extends TagDescriptor {
    private boolean UUU__allowDecimalRepresentationOfRationals = true;

    public ExifDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int n) throws MetadataException {
        switch (n) {
            case 274: {
                return this.VUv_getOrientationDescription();
            }
            case 296: {
                return this.uVu_getResolutionDescription();
            }
            case 531: {
                return this.Uuv_getYCbCrPositioningDescription();
            }
            case 33434: {
                return this.Vvu_getExposureTimeDescription();
            }
            case 37377: {
                return this.UUv_getShutterSpeedDescription();
            }
            case 33437: {
                return this.VVu_getFNumberDescription();
            }
            case 282: {
                return this.uuV_getXResolutionDescription();
            }
            case 283: {
                return this.Uvu_getYResolutionDescription();
            }
            case 513: {
                return this.uUV_getThumbnailOffsetDescription();
            }
            case 514: {
                return this.UVu_getThumbnailLengthDescription();
            }
            case 37122: {
                return this.VuV_getCompressionLevelDescription();
            }
            case 37382: {
                return this.uvU_getSubjectDistanceDescription();
            }
            case 37383: {
                return this.VUV_getMeteringModeDescription();
            }
            case 37384: {
                return this.uVU_getWhiteBalanceDescription();
            }
            case 37385: {
                return this.UuV_getFlashDescription();
            }
            case 37386: {
                return this.VvU_getFocalLengthDescription();
            }
            case 40961: {
                return this.UUV_getColorSpaceDescription();
            }
            case 40962: {
                return this.VVU_getExifImageWidthDescription();
            }
            case 40963: {
                return this.uVv_getExifImageHeightDescription();
            }
            case 41488: {
                return this.UvU_getFocalPlaneResolutionUnitDescription();
            }
            case 41486: {
                return this.Vvv_getFocalPlaneXResolutionDescription();
            }
            case 41487: {
                return this.UVU_getFocalPlaneYResolutionDescription();
            }
            case 256: {
                return this.VVv_getThumbnailImageWidthDescription();
            }
            case 257: {
                return this.uuu_getThumbnailImageHeightDescription();
            }
            case 258: {
                return this.Uvv_getBitsPerSampleDescription();
            }
            case 259: {
                return this.uUu_getCompressionDescription();
            }
            case 262: {
                return this.UVv_getPhotometricInterpretationDescription();
            }
            case 278: {
                return this.Vuu_getRowsPerStripDescription();
            }
            case 279: {
                return this.uvV_getStripByteCountsDescription();
            }
            case 277: {
                return this.VUu_getSamplesPerPixelDescription();
            }
            case 284: {
                return this.uVV_getPlanarConfigurationDescription();
            }
            case 530: {
                return this.Uuu_getYCbCrSubsamplingDescription();
            }
            case 34850: {
                return this.VvV_getExposureProgramDescription();
            }
            case 37378: {
                return this.UUu_getApertureValueDescription();
            }
            case 37381: {
                return this.VVV_getMaxApertureValueDescription();
            }
            case 41495: {
                return this.uuU_getSensingMethodDescription();
            }
            case 37380: {
                return this.UvV_getExposureBiasDescription();
            }
            case 41728: {
                return this.uUU_getFileSourceDescription();
            }
            case 41729: {
                return this.UVV_getSceneTypeDescription();
            }
            case 37121: {
                return this.VuU_getComponentConfigurationDescription();
            }
            case 36864: {
                return this.uuv_getExifVersionDescription();
            }
            case 40960: {
                return this.VUU_getFlashPixVersionDescription();
            }
            case 532: {
                return this.uUv_getReferenceBlackWhiteDescription();
            }
            case 34855: {
                return this.UuU_getIsoEquivalentDescription();
            }
            case 61441: {
                return this.Vuv_getThumbnailDescription();
            }
        }
        return this._directory.getString(n);
    }

    private String Vuv_getThumbnailDescription() throws MetadataException {
        if (!this._directory.containsTag(61441)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(61441);
        return "[" + nArray.length + " bytes of thumbnail data]";
    }

    private String UuU_getIsoEquivalentDescription() throws MetadataException {
        if (!this._directory.containsTag(34855)) {
            return null;
        }
        int n = this._directory.getInt(34855);
        if (n < 50) {
            n *= 200;
        }
        return Integer.toString(n);
    }

    private String uUv_getReferenceBlackWhiteDescription() throws MetadataException {
        if (!this._directory.containsTag(532)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(532);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4];
        int n6 = nArray[5];
        String string = "[" + n + "," + n3 + "," + n5 + "] " + "[" + n2 + "," + n4 + "," + n6 + "]";
        return string;
    }

    private String uuv_getExifVersionDescription() throws MetadataException {
        if (!this._directory.containsTag(36864)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(36864);
        return ExifDescriptor.convertBytesToVersionString(nArray);
    }

    private String VUU_getFlashPixVersionDescription() throws MetadataException {
        if (!this._directory.containsTag(40960)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(40960);
        return ExifDescriptor.convertBytesToVersionString(nArray);
    }

    private String UVV_getSceneTypeDescription() throws MetadataException {
        if (!this._directory.containsTag(41729)) {
            return null;
        }
        int n = this._directory.getInt(41729);
        if (n == 1) {
            return "Directly photographed image";
        }
        return "Unknown (" + n + ")";
    }

    private String uUU_getFileSourceDescription() throws MetadataException {
        if (!this._directory.containsTag(41728)) {
            return null;
        }
        int n = this._directory.getInt(41728);
        if (n == 3) {
            return "Digital Still Camera (DSC)";
        }
        return "Unknown (" + n + ")";
    }

    private String UvV_getExposureBiasDescription() throws MetadataException {
        if (!this._directory.containsTag(37380)) {
            return null;
        }
        Rational rational = this._directory.getRational(37380);
        return rational.toSimpleString(true);
    }

    private String VVV_getMaxApertureValueDescription() throws MetadataException {
        if (!this._directory.containsTag(37381)) {
            return null;
        }
        double d = this._directory.getDouble(37381);
        double d2 = Math.sqrt(2.0);
        double d3 = Math.pow(d2, d);
        DecimalFormat decimalFormat = new DecimalFormat("0.#");
        return "F" + decimalFormat.format(d3);
    }

    private String UUu_getApertureValueDescription() throws MetadataException {
        if (!this._directory.containsTag(37378)) {
            return null;
        }
        double d = this._directory.getDouble(37378);
        double d2 = Math.sqrt(2.0);
        double d3 = Math.pow(d2, d);
        DecimalFormat decimalFormat = new DecimalFormat("0.#");
        return "F" + decimalFormat.format(d3);
    }

    private String VvV_getExposureProgramDescription() throws MetadataException {
        if (!this._directory.containsTag(34850)) {
            return null;
        }
        switch (this._directory.getInt(34850)) {
            case 1: {
                return "Manual control";
            }
            case 2: {
                return "Program normal";
            }
            case 3: {
                return "Aperture priority";
            }
            case 4: {
                return "Shutter priority";
            }
            case 5: {
                return "Program creative (slow program)";
            }
            case 6: {
                return "Program action (high-speed program)";
            }
            case 7: {
                return "Portrait mode";
            }
            case 8: {
                return "Landscape mode";
            }
        }
        return "Unknown program (" + this._directory.getInt(34850) + ")";
    }

    private String Uuu_getYCbCrSubsamplingDescription() throws MetadataException {
        if (!this._directory.containsTag(530)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(530);
        if (nArray[0] == 2 && nArray[1] == 1) {
            return "YCbCr4:2:2";
        }
        if (nArray[0] == 2 && nArray[1] == 2) {
            return "YCbCr4:2:0";
        }
        return "(Unknown)";
    }

    private String uVV_getPlanarConfigurationDescription() throws MetadataException {
        if (!this._directory.containsTag(284)) {
            return null;
        }
        switch (this._directory.getInt(284)) {
            case 1: {
                return "Chunky (contiguous for each subsampling pixel)";
            }
            case 2: {
                return "Separate (Y-plane/Cb-plane/Cr-plane format)";
            }
        }
        return "Unknown configuration";
    }

    private String VUu_getSamplesPerPixelDescription() {
        if (!this._directory.containsTag(277)) {
            return null;
        }
        return String.valueOf(this._directory.getString(277)) + " samples/pixel";
    }

    private String Vuu_getRowsPerStripDescription() {
        if (!this._directory.containsTag(278)) {
            return null;
        }
        return String.valueOf(this._directory.getString(278)) + " rows/strip";
    }

    private String uvV_getStripByteCountsDescription() {
        if (!this._directory.containsTag(279)) {
            return null;
        }
        return String.valueOf(this._directory.getString(279)) + " bytes";
    }

    private String UVv_getPhotometricInterpretationDescription() throws MetadataException {
        if (!this._directory.containsTag(262)) {
            return null;
        }
        switch (this._directory.getInt(262)) {
            case 1: {
                return "Monochrome";
            }
            case 2: {
                return "RGB";
            }
            case 6: {
                return "YCbCr";
            }
        }
        return "Unknown colour space";
    }

    private String uUu_getCompressionDescription() throws MetadataException {
        if (!this._directory.containsTag(259)) {
            return null;
        }
        switch (this._directory.getInt(259)) {
            case 1: {
                return "No compression";
            }
            case 6: {
                return "JPEG compression";
            }
        }
        return "Unknown compression";
    }

    private String Uvv_getBitsPerSampleDescription() {
        if (!this._directory.containsTag(258)) {
            return null;
        }
        return String.valueOf(this._directory.getString(258)) + " bits/component/pixel";
    }

    private String VVv_getThumbnailImageWidthDescription() {
        if (!this._directory.containsTag(256)) {
            return null;
        }
        return String.valueOf(this._directory.getString(256)) + " pixels";
    }

    private String uuu_getThumbnailImageHeightDescription() {
        if (!this._directory.containsTag(257)) {
            return null;
        }
        return String.valueOf(this._directory.getString(257)) + " pixels";
    }

    private String Vvv_getFocalPlaneXResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(41486)) {
            return null;
        }
        Rational rational = this._directory.getRational(41486);
        return String.valueOf(rational.getReciprocal().toSimpleString(this.UUU__allowDecimalRepresentationOfRationals)) + " " + this.UvU_getFocalPlaneResolutionUnitDescription().toLowerCase();
    }

    private String UVU_getFocalPlaneYResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(259)) {
            return null;
        }
        Rational rational = this._directory.getRational(41487);
        return String.valueOf(rational.getReciprocal().toSimpleString(this.UUU__allowDecimalRepresentationOfRationals)) + " " + this.UvU_getFocalPlaneResolutionUnitDescription().toLowerCase();
    }

    private String UvU_getFocalPlaneResolutionUnitDescription() throws MetadataException {
        if (!this._directory.containsTag(41488)) {
            return null;
        }
        switch (this._directory.getInt(41488)) {
            case 1: {
                return "(No unit)";
            }
            case 2: {
                return "Inches";
            }
            case 3: {
                return "cm";
            }
        }
        return "";
    }

    private String VVU_getExifImageWidthDescription() throws MetadataException {
        if (!this._directory.containsTag(40962)) {
            return null;
        }
        return String.valueOf(this._directory.getInt(40962)) + " pixels";
    }

    private String uVv_getExifImageHeightDescription() throws MetadataException {
        if (!this._directory.containsTag(40963)) {
            return null;
        }
        return String.valueOf(this._directory.getInt(40963)) + " pixels";
    }

    private String UUV_getColorSpaceDescription() throws MetadataException {
        if (!this._directory.containsTag(40961)) {
            return null;
        }
        int n = this._directory.getInt(40961);
        if (n == 1) {
            return "sRGB";
        }
        if (n == 65535) {
            return "Undefined";
        }
        return "Unknown";
    }

    private String VvU_getFocalLengthDescription() throws MetadataException {
        if (!this._directory.containsTag(37386)) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0##");
        Rational rational = this._directory.getRational(37386);
        return String.valueOf(decimalFormat.format(rational.doubleValue())) + " mm";
    }

    private String UuV_getFlashDescription() throws MetadataException {
        if (!this._directory.containsTag(37385)) {
            return null;
        }
        switch (this._directory.getInt(37385)) {
            case 0: {
                return "No flash fired";
            }
            case 1: {
                return "Flash fired";
            }
            case 5: {
                return "Flash fired but strobe return light not detected";
            }
            case 7: {
                return "flash fired and strobe return light detected";
            }
        }
        return "Unknown (" + this._directory.getInt(37385) + ")";
    }

    private String uVU_getWhiteBalanceDescription() throws MetadataException {
        if (!this._directory.containsTag(37384)) {
            return null;
        }
        switch (this._directory.getInt(37384)) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Flourescent";
            }
            case 3: {
                return "Tungsten";
            }
            case 10: {
                return "Flash";
            }
            case 17: {
                return "Standard light";
            }
            case 18: {
                return "Standard light (B)";
            }
            case 19: {
                return "Standard light (C)";
            }
            case 20: {
                return "D55";
            }
            case 21: {
                return "D65";
            }
            case 22: {
                return "D75";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "Unknown (" + this._directory.getInt(37384) + ")";
    }

    private String VUV_getMeteringModeDescription() throws MetadataException {
        if (!this._directory.containsTag(37383)) {
            return null;
        }
        int n = this._directory.getInt(37383);
        switch (n) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Average";
            }
            case 2: {
                return "Center weighted average";
            }
            case 3: {
                return "Spot";
            }
            case 4: {
                return "Multi-spot";
            }
            case 5: {
                return "Multi-segment";
            }
            case 6: {
                return "Partial";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "";
    }

    private String uvU_getSubjectDistanceDescription() throws MetadataException {
        if (!this._directory.containsTag(37382)) {
            return null;
        }
        Rational rational = this._directory.getRational(37382);
        DecimalFormat decimalFormat = new DecimalFormat("0.0##");
        return String.valueOf(decimalFormat.format(rational.doubleValue())) + " metres";
    }

    private String VuV_getCompressionLevelDescription() throws MetadataException {
        if (!this._directory.containsTag(37122)) {
            return null;
        }
        Rational rational = this._directory.getRational(37122);
        String string = rational.toSimpleString(this.UUU__allowDecimalRepresentationOfRationals);
        if (rational.isInteger() && rational.intValue() == 1) {
            return String.valueOf(string) + " bit/pixel";
        }
        return String.valueOf(string) + " bits/pixel";
    }

    private String UVu_getThumbnailLengthDescription() {
        if (!this._directory.containsTag(514)) {
            return null;
        }
        return String.valueOf(this._directory.getString(514)) + " bytes";
    }

    private String uUV_getThumbnailOffsetDescription() {
        if (!this._directory.containsTag(513)) {
            return null;
        }
        return String.valueOf(this._directory.getString(513)) + " bytes";
    }

    private String Uvu_getYResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(283)) {
            return null;
        }
        Rational rational = this._directory.getRational(283);
        return String.valueOf(rational.toSimpleString(this.UUU__allowDecimalRepresentationOfRationals)) + " dots per " + this.uVu_getResolutionDescription().toLowerCase();
    }

    private String uuV_getXResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(282)) {
            return null;
        }
        Rational rational = this._directory.getRational(282);
        return String.valueOf(rational.toSimpleString(this.UUU__allowDecimalRepresentationOfRationals)) + " dots per " + this.uVu_getResolutionDescription().toLowerCase();
    }

    private String Vvu_getExposureTimeDescription() {
        if (!this._directory.containsTag(33434)) {
            return null;
        }
        return String.valueOf(this._directory.getString(33434)) + " sec";
    }

    private String UUv_getShutterSpeedDescription() throws MetadataException {
        if (!this._directory.containsTag(37377)) {
            return null;
        }
        int n = this._directory.getInt(37377);
        int n2 = (int)Math.pow(2.0, n);
        return "1/" + n2 + " sec";
    }

    private String VVu_getFNumberDescription() throws MetadataException {
        if (!this._directory.containsTag(33437)) {
            return null;
        }
        Rational rational = this._directory.getRational(33437);
        DecimalFormat decimalFormat = new DecimalFormat("0.#");
        return "F" + decimalFormat.format(rational.doubleValue());
    }

    private String Uuv_getYCbCrPositioningDescription() throws MetadataException {
        if (!this._directory.containsTag(531)) {
            return null;
        }
        int n = this._directory.getInt(531);
        switch (n) {
            case 1: {
                return "Center of pixel array";
            }
            case 2: {
                return "Datum point";
            }
        }
        return String.valueOf(n);
    }

    private String VUv_getOrientationDescription() throws MetadataException {
        if (!this._directory.containsTag(274)) {
            return null;
        }
        int n = this._directory.getInt(274);
        switch (n) {
            case 1: {
                return "top, left side";
            }
            case 2: {
                return "top, right side";
            }
            case 3: {
                return "bottom, right side";
            }
            case 4: {
                return "bottom, left side";
            }
            case 5: {
                return "left side, top";
            }
            case 6: {
                return "right side, top";
            }
            case 7: {
                return "right side, bottom";
            }
            case 8: {
                return "left side, bottom";
            }
        }
        return String.valueOf(n);
    }

    private String uVu_getResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(296)) {
            return "";
        }
        int n = this._directory.getInt(296);
        switch (n) {
            case 1: {
                return "(No unit)";
            }
            case 2: {
                return "Inch";
            }
            case 3: {
                return "cm";
            }
        }
        return "";
    }

    private String uuU_getSensingMethodDescription() throws MetadataException {
        if (!this._directory.containsTag(41495)) {
            return null;
        }
        int n = this._directory.getInt(41495);
        switch (n) {
            case 1: {
                return "(Not defined)";
            }
            case 2: {
                return "One-chip color area sensor";
            }
            case 3: {
                return "Two-chip color area sensor";
            }
            case 4: {
                return "Three-chip color area sensor";
            }
            case 5: {
                return "Color sequential area sensor";
            }
            case 7: {
                return "Trilinear sensor";
            }
            case 8: {
                return "Color sequential linear sensor";
            }
        }
        return "";
    }

    private String VuU_getComponentConfigurationDescription() throws MetadataException {
        int[] nArray = this._directory.getIntArray(37121);
        String[] stringArray = new String[]{"", "Y", "Cb", "Cr", "R", "G", "B"};
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < Math.min(4, nArray.length)) {
            int n2 = nArray[n];
            if (n2 > 0 && n2 < stringArray.length) {
                stringBuffer.append(stringArray[n2]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String convertBytesToVersionString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 4) {
            if (n == 2) {
                stringBuffer.append('.');
            }
            String string = String.valueOf((char)nArray[n]);
            if (n != 0 || !"0".equals(string)) {
                stringBuffer.append(string);
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

