/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;

public class NikonType3MakernoteDescriptor
extends TagDescriptor {
    public NikonType3MakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int n) throws MetadataException {
        switch (n) {
            case 132: {
                return this.getLensDescription();
            }
            case 146: {
                return this.getHueAdjustmentDescription();
            }
            case 141: {
                return this.getColorModeDescription();
            }
        }
        return this._directory.getString(n);
    }

    public String getLensDescription() throws MetadataException {
        if (!this._directory.containsTag(132)) {
            return null;
        }
        Rational[] rationalArray = this._directory.getRationalArray(132);
        if (rationalArray.length != 4) {
            return this._directory.getString(132);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(rationalArray[0].intValue());
        stringBuffer.append('-');
        stringBuffer.append(rationalArray[1].intValue());
        stringBuffer.append("mm f/");
        stringBuffer.append(rationalArray[2].floatValue());
        stringBuffer.append('-');
        stringBuffer.append(rationalArray[3].floatValue());
        return stringBuffer.toString();
    }

    public String getHueAdjustmentDescription() {
        if (!this._directory.containsTag(146)) {
            return null;
        }
        return String.valueOf(this._directory.getString(146)) + " degrees";
    }

    public String getColorModeDescription() {
        if (!this._directory.containsTag(141)) {
            return null;
        }
        String string = this._directory.getString(141);
        if (string.startsWith("MODE1")) {
            return "Mode I (sRGB)";
        }
        return string;
    }
}

