/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.MetadataReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.GregorianCalendar;

public class IptcReader
implements MetadataReader {
    private final byte[] U__data;
    static /* synthetic */ Class class$0;

    public IptcReader(File file) throws JpegProcessingException, FileNotFoundException {
        this(new JpegSegmentReader(file).readSegment((byte)-19));
    }

    public IptcReader(byte[] byArray) {
        this.U__data = byArray;
    }

    public Metadata extract() {
        return this.extract(new Metadata());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Metadata extract(Metadata metadata) {
        if (this.U__data == null) {
            return metadata;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("com.drew.metadata.iptc.IptcDirectory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        Directory directory = metadata.getDirectory(clazz);
        int n = 0;
        try {
            while (n < this.U__data.length - 1 && this.u_get32Bits(n) != 7170) {
                ++n;
            }
        }
        catch (MetadataException metadataException) {
            directory.addError("Couldn't find start of Iptc data (invalid segment)");
            return metadata;
        }
        while (n < this.U__data.length) {
            int n2;
            byte by;
            byte by2;
            if (this.U__data[n] != 28) {
                return metadata;
            }
            if (n + 5 >= this.U__data.length) {
                return metadata;
            }
            ++n;
            try {
                by2 = this.U__data[n++];
                by = this.U__data[n++];
                n2 = this.u_get32Bits(n);
            }
            catch (MetadataException metadataException) {
                directory.addError("Iptc data segment ended mid-way through tag descriptor");
                return metadata;
            }
            if ((n += 2) + n2 > this.U__data.length) {
                directory.addError("data for tag extends beyond end of iptc segment");
                return metadata;
            }
            this.V_processTag(directory, by2, by, n, n2);
            n += n2;
        }
        return metadata;
    }

    private int u_get32Bits(int n) throws MetadataException {
        if (n >= this.U__data.length) {
            throw new MetadataException("Attempt to read bytes from outside Iptc data buffer");
        }
        return (this.U__data[n] & 0xFF) << 8 | this.U__data[n + 1] & 0xFF;
    }

    private void V_processTag(Directory directory, int n, int n2, int n3, int n4) {
        String[] stringArray;
        int n5 = n2 | n << 8;
        switch (n5) {
            case 512: {
                short s = (short)(this.U__data[n3] << 8 | this.U__data[n3 + 1]);
                directory.setInt(n5, s);
                return;
            }
            case 522: {
                directory.setInt(n5, this.U__data[n3]);
                return;
            }
            case 542: 
            case 567: {
                if (n4 < 8) break;
                stringArray = new String(this.U__data, n3, n4);
                try {
                    int n6 = Integer.parseInt(stringArray.substring(0, 4));
                    int n7 = Integer.parseInt(stringArray.substring(4, 6)) - 1;
                    int n8 = Integer.parseInt(stringArray.substring(6, 8));
                    Date date = new GregorianCalendar(n6, n7, n8).getTime();
                    directory.setDate(n5, date);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String string = n4 < 1 ? "" : new String(this.U__data, n3, n4);
        if (directory.containsTag(n5)) {
            String[] stringArray2;
            try {
                stringArray = directory.getStringArray(n5);
            }
            catch (MetadataException metadataException) {
                stringArray = null;
            }
            if (stringArray == null) {
                stringArray2 = new String[1];
            } else {
                stringArray2 = new String[stringArray.length + 1];
                int n9 = 0;
                while (n9 < stringArray.length) {
                    stringArray2[n9] = stringArray[n9];
                    ++n9;
                }
            }
            stringArray2[stringArray2.length - 1] = string;
            directory.setStringArray(n5, stringArray2);
        } else {
            directory.setString(n5, string);
        }
    }
}

