/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;

public class JpegDescriptor
extends TagDescriptor {
    public JpegDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int n) throws MetadataException {
        switch (n) {
            case 6: {
                return this.getComponentDataDescription(0);
            }
            case 7: {
                return this.getComponentDataDescription(1);
            }
            case 8: {
                return this.getComponentDataDescription(2);
            }
            case 9: {
                return this.getComponentDataDescription(3);
            }
            case 0: {
                return this.getDataPrecisionDescription();
            }
            case 1: {
                return this.getImageHeightDescription();
            }
            case 3: {
                return this.getImageWidthDescription();
            }
        }
        return this._directory.getString(n);
    }

    public String getImageWidthDescription() {
        return String.valueOf(this._directory.getString(3)) + " pixels";
    }

    public String getImageHeightDescription() {
        return String.valueOf(this._directory.getString(1)) + " pixels";
    }

    public String getDataPrecisionDescription() {
        return String.valueOf(this._directory.getString(0)) + " bits";
    }

    public String getComponentDataDescription(int n) throws MetadataException {
        JpegComponent jpegComponent = ((JpegDirectory)this._directory).getComponent(n);
        if (jpegComponent == null) {
            throw new MetadataException("No Jpeg component exists with number " + n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(jpegComponent.getComponentName());
        stringBuffer.append(" component: Quantization table ");
        stringBuffer.append(jpegComponent.getQuantizationTableNumber());
        stringBuffer.append(", Sampling factors ");
        stringBuffer.append(jpegComponent.getHorizontalSamplingFactor());
        stringBuffer.append(" horiz/");
        stringBuffer.append(jpegComponent.getVerticalSamplingFactor());
        stringBuffer.append(" vert");
        return stringBuffer.toString();
    }
}

