/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.Drawable;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.JComponent;

public abstract class AbstractText
implements Drawable,
Serializable,
PropertyChangeListener {
    public static String TEXT_PROPERTIES_CHANGED = "Text Properties Changed";
    public String m_Text;
    int m_X;
    int m_Y;
    Font m_Font;
    FontMetrics m_Fm;
    Color m_Color;
    TexturePaint m_Tp;
    boolean isTextured;
    private transient JComponent U_uiPanel;
    private transient PropertyChangeSupport V_propertyChangeSupport = new PropertyChangeSupport(this);

    public AbstractText() {
        this.m_Text = "JPhotoBrush";
        this.m_Color = Color.black;
    }

    public AbstractText(String string, int n, int n2, Font font, Color color) {
        this.m_Text = string;
        this.m_X = n;
        this.m_Y = n2;
        this.m_Font = font;
        this.m_Color = color;
    }

    public AbstractText(String string, int n, int n2, Font font, Color color, TexturePaint texturePaint) {
        this.m_Text = string;
        this.m_X = n;
        this.m_Y = n2;
        this.m_Font = font;
        this.m_Color = color;
        if (color == null && texturePaint != null) {
            this.isTextured = true;
        }
        this.m_Tp = texturePaint;
    }

    public abstract String getName();

    public abstract Rectangle getBounds(Graphics var1);

    public Font getFont() {
        return this.m_Font;
    }

    public String getText() {
        return this.m_Text;
    }

    public TexturePaint getTexture() {
        return this.m_Tp;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.m_Font = font;
        }
    }

    public void setText(String string) {
        this.m_Text = string;
    }

    public void setTexture(TexturePaint texturePaint) {
        this.m_Tp = texturePaint;
    }

    public Color getColor() {
        return this.m_Color;
    }

    public void setColor(Color color) {
        this.m_Color = color;
    }

    public JComponent getUIPanel() {
        return this.U_uiPanel;
    }

    public void setUIPanel(JComponent jComponent) {
        this.U_uiPanel = jComponent;
        this.U_uiPanel.addPropertyChangeListener(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.V_propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.U_uiPanel) {
            this.V_propertyChangeSupport.firePropertyChange(TEXT_PROPERTIES_CHANGED, null, this);
        }
    }
}

