/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageFileChooser
extends JFileChooser
implements PropertyChangeListener {
    JPanel jPanel1 = new JPanel();
    ImageProducer input;
    ImageConsumer consumer;
    JLabel m_PreviewLabel = new JLabel("", 0);
    int previewWidth = 100;
    int previewHeight = 100;
    JCheckBox checkbox = new JCheckBox("Preview", true);
    File currentFile = null;
    JPanel panel = new JPanel();
    static boolean wait = false;

    public ImageFileChooser() {
        try {
            this.U_jbInit();
            this.addPropertyChangeListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void U_jbInit() throws Exception {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.3")) {
            this.setPreferredSize(new Dimension(450, 400));
        }
        this.jPanel1.setLayout(new FlowLayout(2));
        this.m_PreviewLabel.setAlignmentY(0.0f);
        this.m_PreviewLabel.setBorder(BorderFactory.createEtchedBorder());
        this.checkbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ImageFileChooser.this.checkbox_itemStateChanged(itemEvent);
            }
        });
        this.panel.setLayout(new GridLayout(2, 1));
        this.checkbox.setOpaque(false);
        this.panel.setOpaque(false);
        this.panel.add(this.checkbox);
        this.m_PreviewLabel.setPreferredSize(new Dimension(this.previewWidth, this.previewHeight));
        this.jPanel1.add(this.m_PreviewLabel);
        this.jPanel1.add(this.panel);
        this.jPanel1.setOpaque(false);
        this.setAccessory(this.jPanel1);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.isVisible()) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        try {
            if (string.equals("SelectedFileChangedProperty")) {
                this.currentFile = (File)propertyChangeEvent.getNewValue();
                if (!this.currentFile.isDirectory() && this.checkbox.isSelected() && this.isVisible()) {
                    this.loadImage(this.currentFile);
                    this.repaint();
                } else {
                    this.m_PreviewLabel.setIcon(null);
                }
                propertyChangeEvent.setPropagationId(null);
            } else if (string.equals("DialogTitleChangedProperty")) {
                boolean bl = true;
                if (this.getDialogTitle().startsWith("Browse")) {
                    bl = false;
                }
                this.checkbox.setVisible(bl);
                this.m_PreviewLabel.setVisible(bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadImage(File file) {
        new PreviewLoader(file, this).start();
    }

    void checkbox_itemStateChanged(ItemEvent itemEvent) {
        if (this.checkbox.isSelected()) {
            this.loadImage(this.currentFile);
        } else {
            this.m_PreviewLabel.setIcon(null);
        }
    }

    class PreviewLoader
    extends Thread {
        File file;
        Component com;

        PreviewLoader(File file, Component component) {
            this.file = file;
            this.com = component;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    if (this.file == null) {
                        Object var2_1 = null;
                        wait = false;
                        return;
                    }
                    ImageIcon imageIcon = IconLoader.loadIcon(this.file.getAbsolutePath(), ImageFileChooser.this.previewWidth, ImageFileChooser.this.previewHeight, this.com);
                    if (imageIcon == null || imageIcon.getIconWidth() < 0) {
                        ImageFileChooser.this.m_PreviewLabel.setText("Invalid Image");
                    } else {
                        ImageFileChooser.this.m_PreviewLabel.setText(null);
                    }
                    ImageFileChooser.this.m_PreviewLabel.setIcon(imageIcon);
                }
                catch (Exception exception) {
                    ImageFileChooser.this.m_PreviewLabel.setText("Invalid Image");
                }
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                wait = false;
                throw throwable;
            }
            {
                Object var2_3 = null;
                wait = false;
                return;
            }
        }
    }
}

