/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.DefaultImageFilter;
import imager.ImageFilterProcessor;
import imager.ImagerGlobal;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import javax.swing.JOptionPane;

public class ImageHandler {
    ImageFilter m_ImageProcessor;
    Image m_Image;
    int m_Width;
    int m_Height;
    int[] m_Pixels;
    Component m_Owner;

    public ImageHandler(Component component) {
        this.m_Owner = component;
    }

    public ImageHandler(Component component, Image image) {
        this(component);
        this.setImage(image);
    }

    public synchronized void setImage(Image image) {
        this.m_Image = image;
        if (image == null) {
            return;
        }
        this.m_Pixels = null;
        System.gc();
        this.m_Pixels = this.imageToIntArray(this.m_Image);
    }

    public void setImages(Image[] imageArray) {
        int[][] nArray = new int[imageArray.length][];
        int n = 0;
        int n2 = 0;
        while (n2 < imageArray.length) {
            nArray[n2] = this.imageToIntArray(imageArray[n2]);
            n += nArray[n2].length;
            ++n2;
        }
        this.m_Pixels = new int[n];
        n = 0;
        n2 = 0;
        while (n2 < imageArray.length) {
            System.arraycopy(nArray[n2], 0, this.m_Pixels, n, nArray[n2].length);
            n += nArray[n2].length;
            ++n2;
        }
    }

    public int getPixel(int n, int n2) {
        if (n + n2 * this.m_Width < this.m_Pixels.length) {
            return this.m_Pixels[n + n2 * this.m_Width];
        }
        return 0;
    }

    public int[] getPixels() {
        return this.m_Pixels;
    }

    public int[] getPixels(Image image) {
        return this.imageToIntArray(image);
    }

    public synchronized Image processImage(ImageFilter imageFilter) {
        try {
            System.gc();
            this.m_ImageProcessor = imageFilter;
            if (imageFilter instanceof ImageFilterProcessor) {
                return ImagerGlobal.createImage(((ImageFilterProcessor)imageFilter).processPixels(this.m_Pixels, this.m_Width, this.m_Height), this.m_Width, this.m_Height);
            }
            return this.m_Owner.createImage(new FilteredImageSource(this.m_Image.getSource(), imageFilter));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        catch (Error error) {
            System.out.println("out of memory error in processImage");
            JOptionPane.showMessageDialog(this.m_Owner, "The program is out of memory.\nPlease close any large images, histogram window or the image browser if you are not using them.\nThe program will attempt to reclaim memory. However it may not succeed.In that case please restart the program", "Memory Error!!!", 64);
            System.gc();
            return null;
        }
    }

    public int[] imageToIntArray(Image image) {
        try {
            this.m_Width = image.getWidth(null);
            this.m_Height = image.getHeight(null);
            this.m_Pixels = new int[this.m_Width * this.m_Height];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.m_Width, this.m_Height, this.m_Pixels, 0, this.m_Width);
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Error error) {
            System.out.println("out of memory error in imageToIntArray");
            JOptionPane.showMessageDialog(this.m_Owner, "The program is out of memory.\nPlease close any large image, histogram window or the image browser if you are not using them.\nThe program will attempt to reclaim memory. However it may not succeed.In that case please restart the program", "Memory Error!!!", 64);
            System.gc();
        }
        return this.m_Pixels;
    }

    public int getProgressStatus() {
        return this.m_ImageProcessor instanceof DefaultImageFilter ? ((DefaultImageFilter)this.m_ImageProcessor).getPercentProgress() : 0;
    }

    public Image processSerially(ImageFilter[] imageFilterArray) {
        int[] nArray = this.m_Pixels;
        ImageProducer imageProducer = this.m_Image.getSource();
        int n = 0;
        while (n < imageFilterArray.length) {
            if (nArray == null) break;
            this.m_ImageProcessor = imageFilterArray[n];
            System.gc();
            if (imageFilterArray[n] instanceof ImageFilterProcessor) {
                nArray = ((ImageFilterProcessor)imageFilterArray[n]).processPixels(nArray, this.m_Width, this.m_Height);
            } else {
                imageProducer = new FilteredImageSource(imageProducer, imageFilterArray[n]);
            }
            ++n;
        }
        System.gc();
        if (imageFilterArray[0] instanceof ImageFilterProcessor && nArray != null) {
            return ImagerGlobal.createImage(nArray, this.m_Width, this.m_Height);
        }
        if (!(imageFilterArray[0] instanceof ImageFilterProcessor)) {
            return this.m_Owner.createImage(imageProducer);
        }
        return null;
    }
}

