/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.AbstractText;
import imager.DemoStamper;
import imager.ImagePrintable;
import imager.Imager;
import imager.ImagerGlobal;
import imager.PrintImage;
import imager.RectangularDraggable;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel
implements ImagePrintable {
    protected Image m_Image;
    public int m_ImageX;
    public int m_ImageY;
    public int m_Width;
    public int m_Height;
    Dimension dimension;
    double m_DisplayWidthRatio = 1.0;
    double m_DisplayHeightRatio = 1.0;
    JComponent m_Owner;
    RectangularDraggable m_Draggable;
    Image m_DraggableImage;
    boolean centerImage = true;
    boolean m_bDrag = false;

    public ImagePanel() {
        this.setupDraggable();
    }

    public ImagePanel(Image image) {
        this();
        this.setImage(image);
    }

    public ImagePanel(Image image, int n, int n2) {
        this();
        this.setImage(image);
        this.setDimensionMaintainRatio(n, n2);
    }

    public void setImage(Image image) {
        if (image != null && this.m_Image == null) {
            this.m_Width = image.getWidth(null);
            this.m_Height = image.getHeight(null);
        }
        this.m_Image = image;
        if (image != null) {
            this.U_updateRatios();
        }
        System.gc();
    }

    public void setImageMaintainOrginalRatio(Image image) {
        if (image != null) {
            this.m_Image = image;
            this.m_Height = (int)((double)this.m_Image.getHeight(null) * this.m_DisplayHeightRatio);
            this.m_Width = (int)((double)this.m_Image.getWidth(null) * this.m_DisplayWidthRatio);
            try {
                this.repaint(0, 0, this.m_Image.getWidth(null), this.m_Image.getHeight(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.gc();
        }
    }

    public Image getImage() {
        return this.m_Image;
    }

    public void setDimensionBy(double d, double d2) {
        this.m_Width = (int)((double)this.m_Image.getWidth(null) * d);
        this.m_Height = (int)((double)this.m_Image.getHeight(null) * d2);
        this.U_updateRatios();
    }

    public void setDimension(int n, int n2) {
        if (this.m_Image != null && n <= this.m_Image.getWidth(null)) {
            this.m_Width = n;
        }
        if (this.m_Image != null && n2 <= this.m_Image.getHeight(null)) {
            this.m_Height = n2;
        }
    }

    public void setDimensionMaintainRatio(int n, int n2) {
        float f = (float)this.m_Image.getHeight(null) / (float)this.m_Image.getWidth(null);
        float f2 = this.m_Image.getHeight(null) / n2;
        float f3 = this.m_Image.getWidth(null) / n;
        if (this.m_Image == null) {
            return;
        }
        if (f2 < f3) {
            this.m_Width = n;
            this.m_Height = (int)(f * (float)this.m_Width);
        } else {
            this.m_Height = n2;
            this.m_Width = (int)((float)this.m_Height / f);
        }
        this.U_updateRatios();
    }

    private void U_updateRatios() {
        if (this.dimension == null) {
            this.dimension = new Dimension(this.m_Width, this.m_Height);
        } else {
            this.dimension.width = this.m_Width;
            this.dimension.height = this.m_Height;
        }
        this.setPreferredSize(this.dimension);
        if (!this.centerImage) {
            super.setSize(this.dimension);
        }
        this.m_DisplayHeightRatio = (double)this.m_Height / (double)this.m_Image.getHeight(null);
        this.m_DisplayWidthRatio = (double)this.m_Width / (double)this.m_Image.getWidth(null);
        this.repaint();
    }

    public Dimension getDimension() {
        return new Dimension(this.m_Width, this.m_Height);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.m_Image != null) {
            this.revalidate();
            if (this.centerImage) {
                this.m_ImageX = (this.getWidth() - this.m_Width) / 2;
                this.m_ImageY = (this.getHeight() - this.m_Height) / 2;
            }
            graphics.drawImage(this.m_Image, this.m_ImageX, this.m_ImageY, this.m_Width, this.m_Height, this);
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        double d = pageFormat.getImageableHeight() * (double)n;
        Image image = this.m_Draggable.isMoveable() ? this.m_Draggable.getImage() : this.m_Image;
        if (image == null) {
            return 1;
        }
        if (Imager.getAppType() == 0) {
            DemoStamper.stamp(image, "Printed in Demo Version of JPhotoBrush Pro");
        }
        if ((double)image.getHeight(null) < d) {
            return 1;
        }
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics.translate(0, -((int)pageFormat.getImageableHeight()) * n);
        graphics.clipRect(0, (int)pageFormat.getImageableHeight() * n, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        if (PrintImage.getPrintOption() != null) {
            if (PrintImage.getPrintOption().getisFitToPageCheckBox().isSelected()) {
                if (n > 0) {
                    return 1;
                }
                int n2 = image.getWidth(null) > image.getHeight(null) ? (int)pageFormat.getImageableWidth() : -1;
                int n3 = image.getHeight(null) > image.getWidth(null) ? (int)pageFormat.getImageableHeight() : -1;
                image = image.getScaledInstance(n2, n3, 1);
                if (PrintImage.getPrintOption().getHorizCenterRadioButton().isSelected()) {
                    graphics.translate((int)(pageFormat.getImageableWidth() - (double)image.getWidth(null)) / 2, 0);
                }
                if (PrintImage.getPrintOption().getVertCenterRadioButton().isSelected()) {
                    graphics.translate(0, (int)(pageFormat.getImageableHeight() - (double)image.getHeight(null)) / 2);
                }
                graphics.drawImage(image, 0, 0, null);
                if (PrintImage.getPrintOption().getHorizCenterRadioButton().isSelected()) {
                    graphics.translate(-((int)(pageFormat.getImageableWidth() - (double)image.getWidth(null))) / 2, 0);
                }
                if (PrintImage.getPrintOption().getVertCenterRadioButton().isSelected()) {
                    graphics.translate(0, -((int)(pageFormat.getImageableHeight() - (double)image.getHeight(null))) / 2);
                }
            } else {
                if (PrintImage.getPrintOption().getHorizCenterRadioButton().isSelected()) {
                    graphics.translate((double)image.getWidth(null) < pageFormat.getImageableWidth() ? (int)(pageFormat.getImageableWidth() - (double)image.getWidth(null)) / 2 : 0, 0);
                }
                if (PrintImage.getPrintOption().getVertCenterRadioButton().isSelected()) {
                    graphics.translate(0, (double)image.getHeight(null) < pageFormat.getImageableHeight() ? (int)(pageFormat.getImageableHeight() - (double)image.getHeight(null)) / 2 : 0);
                }
                graphics.drawImage(image, 0, 0, this);
                if (PrintImage.getPrintOption().getHorizCenterRadioButton().isSelected()) {
                    graphics.translate((double)image.getWidth(null) < pageFormat.getImageableWidth() ? -((int)(pageFormat.getImageableWidth() - (double)image.getWidth(null))) / 2 : 0, 0);
                }
                if (PrintImage.getPrintOption().getVertCenterRadioButton().isSelected()) {
                    graphics.translate(0, (double)image.getHeight(null) < pageFormat.getImageableHeight() ? -((int)(pageFormat.getImageableHeight() - (double)image.getHeight(null))) / 2 : 0);
                }
            }
        } else {
            graphics.drawImage(image, 0, 0, this);
        }
        graphics.translate(0, (int)pageFormat.getImageableHeight() * n);
        return 0;
    }

    public void zoomIn() {
        if (this.m_Width < this.m_Image.getWidth(null) * 10 || this.m_Height < this.m_Image.getHeight(null) * 10) {
            this.m_Width = (int)((float)this.m_Width + 0.2f * (float)this.m_Width);
            this.m_Height = (int)((float)this.m_Height + 0.2f * (float)this.m_Height);
            this.U_updateRatios();
        }
    }

    public void zoomOut() {
        if (this.m_Width > this.m_Image.getWidth(null) / 10 || this.m_Height > this.m_Image.getHeight(null) / 10) {
            this.m_Width = (int)((float)this.m_Width - 0.2f * (float)this.m_Width);
            this.m_Height = (int)((float)this.m_Height - 0.2f * (float)this.m_Height);
            this.U_updateRatios();
        }
    }

    public void resetImageSize() {
        this.m_Width = this.m_Image.getWidth(null);
        this.m_Height = this.m_Image.getHeight(null);
        this.U_updateRatios();
    }

    public int getNumPages(PageFormat pageFormat) {
        Image image = this.m_Draggable.isMoveable() ? this.m_Draggable.getImage() : this.m_Image;
        if (PrintImage.getPrintOption() != null && PrintImage.getPrintOption().getisFitToPageCheckBox().isSelected()) {
            return 1;
        }
        int n = (int)((double)image.getHeight(null) / pageFormat.getImageableHeight());
        if ((double)image.getHeight(null) % pageFormat.getImageableHeight() != 0.0) {
            ++n;
        }
        return n;
    }

    public double getDisplayWidthRatio() {
        return this.m_DisplayWidthRatio;
    }

    public double getDisplayHeightRatio() {
        return this.m_DisplayHeightRatio;
    }

    public boolean isImageNormalViewed() {
        return this.m_DisplayHeightRatio == 1.0 && this.m_DisplayWidthRatio == 1.0;
    }

    public JComponent getOwner() {
        return this.m_Owner;
    }

    public void setOwner(JComponent jComponent) {
        this.m_Owner = jComponent;
    }

    public boolean insideDraggable(int n, int n2) {
        return this.m_Draggable != null && this.m_Draggable.isMoveable() && this.m_Draggable.getOrigBounds().contains(n, n2);
    }

    public Cursor getDraggableCursor() {
        return this.m_Draggable.getCursor();
    }

    public void setupDraggable() {
        this.m_Draggable = new RectangularDraggable(this);
        this.m_Draggable.setMoveable(false);
        this.m_Draggable.setOrigBounds(new Rectangle(50, 50, 100, 100));
    }

    public RectangularDraggable getDraggable() {
        return this.m_Draggable;
    }

    public void mousePressed(int n, int n2) {
        if (!this.m_bDrag) {
            this.m_Draggable.setOuterBounds(0, 0, this.m_Image.getWidth(null), this.m_Image.getHeight(null));
            this.m_Draggable.mousePressed(n, n2);
            this.m_bDrag = true;
        }
    }

    public void mouseDragged(int n, int n2, Graphics graphics) {
        if (!this.m_bDrag) {
            return;
        }
        this.m_Draggable.mouseDragged(n, n2, graphics, graphics);
        this.repaint();
    }

    public void mouseReleased(int n, int n2, Graphics graphics) {
        if (this.m_bDrag) {
            this.m_Draggable.mouseReleased(n, n2);
            this.repaint();
        }
        this.m_bDrag = false;
    }

    public boolean isSelectionDragged() {
        return this.m_bDrag;
    }

    public void setFloatingText(AbstractText abstractText) {
        this.m_Draggable.setText(abstractText);
        this.m_Draggable.setMoveable(true);
    }

    public void setFloatingImage(Image image) {
        this.m_Draggable.setImage(image);
        this.m_Draggable.setMoveable(true);
    }

    public void embeddDraggable() {
        try {
            this.setImage(ImagerGlobal.getBufferedImage(this.m_Image, this));
            Graphics graphics = this.m_Image.getGraphics();
            if (!this.m_Draggable.isMoveable()) {
                return;
            }
            this.m_Draggable.drawDraggedRegion((Graphics2D)graphics, (Graphics2D)graphics);
            this.m_Draggable.draw(graphics);
            this.nullifyDraggable();
            graphics.dispose();
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void nullifyDraggable() {
        this.m_Draggable.setMoveable(false);
        this.m_Draggable.setText(null);
        this.m_Draggable.setImage(null);
    }

    public boolean isCenterImage() {
        return this.centerImage;
    }

    public void setCenterImage(boolean bl) {
        this.centerImage = bl;
    }
}

