/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.ImageFileChooser;
import imager.ImageFileFilter;
import imager.ImageIOUtils;
import imager.SaveImageFileChooserClass;
import imager.SerializableBufferedImage;
import imager.Shear;
import imager.imagefileio.ICO.ICOImageReaderSpi;
import imager.resources.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public final class ImagerGlobal {
    public static final String affiliate = "";
    public static final String BUY_URL = "http://www.jphotobrushpro.com";
    public static final String IMAGERNAME = "JPhotoBrush Pro";
    static final double INCH_TO_CMS = 2.54;
    public static final String IMAGERDIALOGMSG = "JPhotoBrush Pro Dialog";
    public static final String IMAGEPRINTMSG = "Printed in JPhotoBrush Pro";
    public static final String VERSION = "1.3";
    public static final String BUILD = "4";
    public static final String WEBSITE = "http://www.jphotobrushpro.com";
    public static final String AUTHORWEBSITE = "http://www.tanveer.freeservers.com";
    public static final String LOGOFILENAME = "jplogo.gif";
    public static final String SYSTEMLOOKANDFEEL = UIManager.getSystemLookAndFeelClassName();
    public static final String METALLOOKANDFEEL = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String MOTIFLOOKANDFEEL = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static MetalTheme METAL_THEME;
    public static final int METALLFSHIFTX = 6;
    public static final int METALLFSHIFTY = 32;
    public static final int WINDOWSLFSHIFTX = 5;
    public static final int WINDOWSLFSHIFTY = 25;
    public static final int MOTIFLFSHIFTX = 6;
    public static final int MOTIFLFSHIFTY = 25;
    public static final float ZOOM_FACTOR = 0.2f;
    public static final int BUFFERED_IMAGE_TYPE = 3;
    public static String ProjectUserHomePath;
    public static String TEMPFILEPATH;
    public static String TexturePath;
    public static String EffectPluginPath;
    public static String TextPluginPath;
    public static String StampPluginPath;
    public static String LookAndFeelPath;
    public static String ImageIOPath;
    public static String DatafilePath;
    public static JFileChooser OpenImageFileChooser;
    public static SaveImageFileChooserClass SaveImageFileChooser;
    public static Image ZOOM_CURSORIMAGE;
    public static Image DROPPER_CURSOR;
    public static Cursor CROSSHAIR_CURSOR;
    public static Cursor TEXT_CURSOR;
    public static Cursor HAND_CURSOR;
    public static Cursor ZOOM_CURSOR;
    public static Cursor SPRAY_CURSOR;
    public static Cursor BRUSH_CURSOR;
    public static String JavaVersion;
    public static String[] FILE_EXTS;
    public static final ImageFileFilter BMP_FILTER;
    public static final ImageFileFilter GIF_FILTER;
    public static final ImageFileFilter PNG_FILTER;
    public static final ImageFileFilter JPG_FILTER;
    public static final ImageFileFilter TIF_FILTER;
    public static final ImageFileFilter TGA_FILTER;
    public static final ImageFileFilter PICT_FILTER;
    public static ImageFileFilter SUPPORTED_IMAGE_READ_FILE_FILTER;
    public static final FileFilter htmlFileFilter;
    public static final FileFilter textFileFilter;
    public static final FileFilter xmlFileFilter;
    public static String OS;

    static {
        ProjectUserHomePath = String.valueOf(System.getProperty("user.home")) + File.separator + "jphotobrush";
        TEMPFILEPATH = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "jphotobrush";
        TexturePath = "textures";
        EffectPluginPath = String.valueOf(ProjectUserHomePath) + File.separator + "plugins" + File.separator + "effects";
        TextPluginPath = String.valueOf(ProjectUserHomePath) + File.separator + "plugins" + File.separator + "texts";
        StampPluginPath = String.valueOf(ProjectUserHomePath) + File.separator + "plugins" + File.separator + "stamps";
        LookAndFeelPath = String.valueOf(ProjectUserHomePath) + File.separator + "lookandfeel";
        ImageIOPath = String.valueOf(ProjectUserHomePath) + File.separator + "plugins" + File.separator + "imageio";
        DatafilePath = String.valueOf(ProjectUserHomePath) + File.separator + "data" + File.separator + "data";
        OpenImageFileChooser = new ImageFileChooser();
        SaveImageFileChooser = new SaveImageFileChooserClass();
        JavaVersion = System.getProperty("java.version");
        FILE_EXTS = new String[]{"BMP", "GIF", "JPEG", "JPG", "JFIF", "JIF", "JPE", "PNG", "TGA", "TIF", "PSD", "XPM", "PCT", "PICT"};
        BMP_FILTER = new ImageFileFilter("bmp", "BMP Images");
        GIF_FILTER = new ImageFileFilter("gif", "GIF Images");
        PNG_FILTER = new ImageFileFilter("png", "PNG Images");
        JPG_FILTER = new ImageFileFilter(new String[]{"jpg", "jpeg", "jfif", "jif", "jpe"}, "JPG Images");
        TIF_FILTER = new ImageFileFilter("tif", "TIFF Images");
        TGA_FILTER = new ImageFileFilter("tga", "TGA Images");
        PICT_FILTER = new ImageFileFilter(new String[]{"pct", "pict"}, "PICT Macintosh Images");
        SUPPORTED_IMAGE_READ_FILE_FILTER = new ImageFileFilter();
        htmlFileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".htm") || file.getName().endsWith(".html");
            }

            public String getDescription() {
                return "HTML files";
            }
        };
        textFileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".txt");
            }

            public String getDescription() {
                return "Text files";
            }
        };
        xmlFileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "XML files";
            }
        };
        OS = System.getProperty("os.name");
    }

    public static void initializeImageIO() {
        try {
            if (!JavaVersion.startsWith(VERSION)) {
                IIORegistry.getDefaultInstance().registerServiceProvider(new ICOImageReaderSpi());
                FILE_EXTS = ImageIOUtils.updateSupportedReadFormatArray(FILE_EXTS);
            }
            HashSet<String> hashSet = new HashSet<String>(10);
            int n = 0;
            while (n < FILE_EXTS.length) {
                hashSet.add(FILE_EXTS[n].toLowerCase());
                ++n;
            }
            Object[] objectArray = hashSet.toArray();
            int n2 = 0;
            while (n2 < objectArray.length) {
                OpenImageFileChooser.addChoosableFileFilter(new ImageFileFilter(objectArray[n2].toString(), String.valueOf(objectArray[n2].toString().toUpperCase()) + " images"));
                ++n2;
            }
            SUPPORTED_IMAGE_READ_FILE_FILTER.setExts(FILE_EXTS);
            SUPPORTED_IMAGE_READ_FILE_FILTER.setDesc("All Supported Image Types");
            OpenImageFileChooser.addChoosableFileFilter(SUPPORTED_IMAGE_READ_FILE_FILTER);
            SaveImageFileChooser.setAcceptAllFileFilterUsed(false);
            SaveImageFileChooser.addChoosableFileFilter(PNG_FILTER);
            SaveImageFileChooser.addChoosableFileFilter(TIF_FILTER);
            SaveImageFileChooser.addChoosableFileFilter(TGA_FILTER);
            SaveImageFileChooser.addChoosableFileFilter(BMP_FILTER);
            SaveImageFileChooser.addChoosableFileFilter(GIF_FILTER);
            SaveImageFileChooser.addChoosableFileFilter(PICT_FILTER);
            SaveImageFileChooser.addChoosableFileFilter(JPG_FILTER);
            if (!JavaVersion.startsWith(VERSION)) {
                ImageIOUtils.updateSupportedWriteFormatFilter(SaveImageFileChooser);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void initializeCursors(Component component) {
        try {
            ZOOM_CURSORIMAGE = ImagerGlobal.loadImage("resources/zoom.gif", component);
            DROPPER_CURSOR = ImagerGlobal.loadImage("resources/dropper.gif", component);
            TEXT_CURSOR = CROSSHAIR_CURSOR = Cursor.getPredefinedCursor(1);
            HAND_CURSOR = new Cursor(12);
            ZOOM_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(ZOOM_CURSORIMAGE, new Point(12, 12), "zoom");
            SPRAY_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(ImagerGlobal.loadImage("resources/spray.gif", component), new Point(8, 3), "zoom");
            BRUSH_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(ImagerGlobal.loadImage("resources/brush.gif", component), new Point(8, 27), "brush");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isWindows() {
        return OS.startsWith("Win");
    }

    public static boolean isWindowsXP() {
        return OS.startsWith("Win") && OS.endsWith("XP");
    }

    public static boolean isMac() {
        return OS.startsWith("Mac");
    }

    public static void initialize() {
        OS = System.getProperty("os.name");
        if (JavaVersion.startsWith("1.5")) {
            try {
                Class<?> clazz = Class.forName("javax.swing.plaf.metal.OceanTheme");
                METAL_THEME = (MetalTheme)clazz.newInstance();
                MetalLookAndFeel.setCurrentTheme(METAL_THEME);
            }
            catch (Exception exception) {
                METAL_THEME = new DefaultMetalTheme();
                MetalLookAndFeel.setCurrentTheme(METAL_THEME);
            }
            catch (Error error) {
                METAL_THEME = new DefaultMetalTheme();
                MetalLookAndFeel.setCurrentTheme(METAL_THEME);
            }
        } else {
            METAL_THEME = new DefaultMetalTheme();
        }
    }

    public static Image getImage(Image image, Component component) {
        try {
            MediaTracker mediaTracker = new MediaTracker(component);
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
            if ((mediaTracker.statusAll(false) & 4) != 0) {
                System.out.println("Error in image loading");
                image = null;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (Error error) {
            JOptionPane.showMessageDialog(component, "The program is out of memory.\nPlease close any large images, histogram window or any the image browser if you are not using them.\nThe program will attempt to  reclaim memory.", "Memory Error!!!", 64);
            System.gc();
        }
        return image;
    }

    public static void setLookAndFeel(Component component, LookAndFeel lookAndFeel) {
        try {
            UIManager.setLookAndFeel(lookAndFeel);
            SwingUtilities.updateComponentTreeUI(component);
        }
        catch (Exception exception) {
            try {
                UIManager.setLookAndFeel(SYSTEMLOOKANDFEEL);
                SwingUtilities.updateComponentTreeUI(component);
            }
            catch (Exception exception2) {
                System.out.println("Error setting System Look and Feel");
            }
            catch (Error error) {
                System.out.println("Error setting System Look and Feel");
            }
        }
    }

    public static void setLookAndFeel(Component component, String string) {
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(component);
        }
        catch (Exception exception) {
            try {
                UIManager.setLookAndFeel(SYSTEMLOOKANDFEEL);
                SwingUtilities.updateComponentTreeUI(component);
            }
            catch (Exception exception2) {
                System.out.println("Error setting System Look and Feel");
            }
            catch (Error error) {
                System.out.println("Error setting System Look and Feel");
            }
        }
        catch (Error error) {
            try {
                UIManager.setLookAndFeel(SYSTEMLOOKANDFEEL);
                SwingUtilities.updateComponentTreeUI(component);
            }
            catch (Exception exception) {
                System.out.println("Error setting System Look and Feel");
            }
            catch (Error error2) {
                System.out.println("Error setting System Look and Feel");
            }
        }
    }

    public static int max(int[] nArray) {
        Arrays.sort(nArray);
        return nArray[nArray.length - 1];
    }

    public static Image getScaledImage(Image image, int n, int n2, Component component) {
        float f = 1.0f;
        if (image.getWidth(null) > n) {
            float f2 = (float)n / (float)image.getWidth(null);
            float f3 = 0.0f;
            f = image.getHeight(null) > n2 ? (f2 < (f3 = (float)n2 / (float)image.getHeight(null)) ? f2 : f3) : f2;
        } else {
            f = image.getHeight(null) > n2 ? (float)n2 / (float)image.getHeight(null) : 1.0f;
        }
        Image image2 = ImagerGlobal.getImage(component.createImage(new FilteredImageSource(image.getSource(), new AreaAveragingScaleFilter((int)((float)image.getWidth(null) * f) - 5, (int)((float)image.getHeight(null) * f) - 5))), component);
        return image2;
    }

    public static BufferedImage getBufferedImage(int n, int n2) {
        return new SerializableBufferedImage(n, n2, 3);
    }

    public static BufferedImage getBufferedImage(Image image, Component component) {
        if (image == null) {
            return null;
        }
        SerializableBufferedImage serializableBufferedImage = null;
        try {
            if (component != null) {
                image = ImagerGlobal.getImage(image, component);
            }
            serializableBufferedImage = new SerializableBufferedImage(image.getWidth(null), image.getHeight(null), 3);
            Graphics2D graphics2D = (Graphics2D)serializableBufferedImage.getGraphics();
            graphics2D.drawImage(image, 0, 0, component);
        }
        catch (Error error) {
            if (component != null) {
                JOptionPane.showMessageDialog(component, "The program is out of memory.\nPlease close any large images, histogram window or any the image browser if you are not using them.\nThe program will attempt to  reclaim memory.", "Memory Error!!!", 0);
            }
            System.gc();
        }
        return serializableBufferedImage;
    }

    public static ImageIcon loadIcon(String string, Component component) {
        return new ImageIcon(ImagerGlobal.loadImage(string, component));
    }

    public static Image loadImage(String string, Component component) {
        URL uRL = component.getClass().getResource(string);
        Image image = null;
        if (uRL != null && uRL.getProtocol() != null && uRL.getProtocol().equals("jar")) {
            image = ImagerGlobal.getImage(Toolkit.getDefaultToolkit().getImage(uRL), component);
        } else {
            int n = string.indexOf("resources/");
            if (n != -1) {
                string = string.substring(10);
            }
            image = ImagerGlobal.getImage(Resource.getImage(string), component);
        }
        return image;
    }

    protected static Image generateCursor(Image image) {
        try {
            int[] nArray = new int[image.getWidth(null) * image.getWidth(null)];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, image.getWidth(null), image.getWidth(null), nArray, 0, image.getWidth(null));
            pixelGrabber.grabPixels();
            int n = 0;
            while (n < nArray.length) {
                Color color = new Color(nArray[n]);
                if (color.getRed() > 10 && color.getRed() < 250 && color.getRed() == color.getGreen() && color.getRed() == color.getBlue()) {
                    nArray[n] = nArray[n] & 0xFFFFFF;
                }
                ++n;
            }
            MemoryImageSource memoryImageSource = new MemoryImageSource(image.getWidth(null), image.getHeight(null), nArray, 0, image.getWidth(null));
            image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
            return image;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return image;
        }
    }

    public static Image createImage(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return null;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray, 0, n);
        return ImagerGlobal.getBufferedImage(Toolkit.getDefaultToolkit().createImage(memoryImageSource), null);
    }

    public static Hashtable readImagesFromJarIntoHashtable(String string, int n, int n2) {
        Hashtable<String, ImageIcon> hashtable = new Hashtable<String, ImageIcon>();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            Vector vector = new Vector();
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                if (!ImagerGlobal.supportsFileExtension(ImagerGlobal.JPG_FILTER.exts, string2, true) && !ImagerGlobal.supportsFileExtension(ImagerGlobal.PNG_FILTER.exts, string2, true) && !ImagerGlobal.supportsFileExtension(ImagerGlobal.GIF_FILTER.exts, string2, true)) continue;
                try {
                    int n3;
                    byte[] byArray = new byte[1024];
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while ((n3 = zipInputStream.read(byArray)) >= 0) {
                        byteArrayOutputStream.write(byArray, 0, n3);
                    }
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    ImageIcon imageIcon = new ImageIcon(byArray2);
                    if (imageIcon.getIconHeight() > n2 || imageIcon.getIconWidth() > n) {
                        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(imageIcon.getIconWidth() >= imageIcon.getIconHeight() ? n : -1, imageIcon.getIconWidth() < imageIcon.getIconHeight() ? n2 : -1, 2));
                    }
                    hashtable.put(string2, imageIcon);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            zipInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return hashtable;
    }

    public static Image readImageFromJar(String string, String string2) {
        Image image = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            Vector vector = new Vector();
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                String string3 = zipEntry.getName();
                if (!string2.equals(string3)) continue;
                byte[] byArray = new byte[1024];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = zipInputStream.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                image = ImagerGlobal.getImage(Toolkit.getDefaultToolkit().createImage(byArray2), new Frame());
                break;
            }
            zipInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static boolean supportsFileExtension(String[] stringArray, String string, boolean bl) {
        int n = 0;
        while (n < stringArray.length) {
            if (bl) {
                if (stringArray[n].equalsIgnoreCase(string)) {
                    return true;
                }
                if (string.toLowerCase().endsWith(stringArray[n].toLowerCase())) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public static Object getClone(Serializable serializable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(dataOutputStream);
            objectOutputStream.writeObject(serializable);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(dataInputStream);
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static int getAppType() {
        return Shear.getVersion();
    }

    public static void listImageIOServiceProviders() {
        System.out.println("Registered image formats and their providers");
        String[] stringArray = ImageIO.getReaderFormatNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            Iterator<ImageReader> iterator2 = ImageIO.getImageReadersBySuffix(string);
            while (iterator2.hasNext()) {
                ImageReader imageReader = iterator2.next();
                ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
                System.out.println(" o " + string + " (" + imageReaderSpi.getDescription(Locale.getDefault()) + ") by " + imageReaderSpi.getVendorName());
            }
            ++n;
        }
    }
}

