/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.ImagePrintable;
import imager.PrintOptionDialog;
import imager.PrintPreviewFrame;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JFrame;

public final class PrintImage
implements Runnable {
    Thread m_PrintThread;
    Printable m_ImagePanel;
    PageFormat pageFormat;
    JFrame m_Frame;
    PrintPreviewFrame m_PrintPreviewFrame;
    public static PrintOptionDialog PrintOption;

    public PrintImage(JFrame jFrame) {
        this.m_Frame = jFrame;
        PrintOption = new PrintOptionDialog(this.m_Frame, this);
    }

    public PrintImage(JFrame jFrame, Object object) {
        this.m_Frame = jFrame;
        if (PrintOption == null) {
            PrintOption = new PrintOptionDialog(this.m_Frame, this);
        }
        this.setPrintable(object);
    }

    public static PrintOptionDialog getPrintOption() {
        return PrintOption;
    }

    public void setPrintable(Object object) {
        this.m_ImagePanel = (Printable)object;
    }

    public void startPrinting(Object object) {
        this.setPrintable(object);
        this.showPrintOption(this.m_Frame);
    }

    public void showPrintOption(JFrame jFrame) {
        if (this.m_ImagePanel == null) {
            PrintOption.setVisible(false);
            return;
        }
        PrintOption.setFrame(jFrame);
        PrintOption.show();
    }

    public void startPrinting() {
        if (this.m_ImagePanel != null) {
            this.m_PrintThread = new Thread(this);
            this.m_PrintThread.start();
        }
    }

    public void run() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.pageFormat == null) {
            this.pageFormat = printerJob.defaultPage();
        }
        Book book = new Book();
        int n = 1;
        if (this.m_ImagePanel instanceof ImagePrintable) {
            n = ((ImagePrintable)this.m_ImagePanel).getNumPages(this.pageFormat);
        }
        book.append(this.m_ImagePanel, this.pageFormat, n);
        printerJob.setPageable(book);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
    }

    public void pageSetup(Object object) {
        this.setPrintable(object);
        this.pageSetup();
    }

    public void pageSetup() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.pageFormat == null) {
            this.pageFormat = printerJob.defaultPage();
        }
        this.pageFormat = printerJob.pageDialog(this.pageFormat);
    }

    public void printPreview(Object object) {
        this.setPrintable(object);
        if (this.m_PrintPreviewFrame == null) {
            this.m_PrintPreviewFrame = new PrintPreviewFrame(this);
        }
        this.m_PrintPreviewFrame.setVisible(true);
    }

    public int showPrintPreview(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.pageFormat == null) {
            this.pageFormat = printerJob.defaultPage();
        }
        Book book = new Book();
        int n2 = 1;
        if (this.m_ImagePanel instanceof ImagePrintable) {
            n2 = ((ImagePrintable)this.m_ImagePanel).getNumPages(this.pageFormat);
        }
        book.append(this.m_ImagePanel, this.pageFormat, n2);
        Printable printable = book.getPrintable(n);
        double d = 0.3;
        String string = "Page " + (n + 1) + " of " + book.getNumberOfPages();
        graphics2D.drawString(string, this.m_PrintPreviewFrame.getWidth() / 2 - graphics2D.getFontMetrics().stringWidth(string) / 2, 30);
        graphics2D.translate((double)(this.m_PrintPreviewFrame.getWidth() / 2) - this.pageFormat.getWidth() / 2.0 * d, 50.0);
        graphics2D.scale(d, d);
        try {
            graphics2D.setColor(Color.darkGray);
            graphics2D.fillRect(15, 15, (int)this.pageFormat.getWidth() + 15, (int)this.pageFormat.getHeight() + 15);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, (int)this.pageFormat.getWidth(), (int)this.pageFormat.getHeight());
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(0, 0, (int)this.pageFormat.getWidth(), (int)this.pageFormat.getHeight());
            printable.print(graphics2D, this.pageFormat, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return book.getNumberOfPages();
    }

    public PrintPreviewFrame getPrintPreviewFrame() {
        return this.m_PrintPreviewFrame;
    }
}

