/*
 * Decompiled with CFR 0.152.
 */
package imager;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;

public abstract class RubberBand {
    private Graphics UU_graphics;
    private Point VV_startPoint;
    private Point VU_endPoint;
    private Color Uv_xorColor = Color.black;
    Image m_Image;
    private boolean Uu_eraseSomething = false;
    protected boolean finalDraw = false;
    private boolean UV_m_bAllowAntiAliasing;

    public RubberBand(boolean bl) {
        this.UV_m_bAllowAntiAliasing = bl;
    }

    public void mousePressed(int n, int n2) {
        this.start(new Point(n, n2));
    }

    public void mouseReleased(int n, int n2) {
        this.erase();
    }

    public void mouseDragged(Graphics graphics, int n, int n2) {
        this.erase();
        this.stop(new Point(n, n2));
        this.draw();
    }

    public void drawFinally(int n, int n2) {
        this.drawFinally(this.getGraphics(), n, n2);
    }

    public void drawFinally(Graphics graphics, int n, int n2) {
        this.finalDraw = true;
        this.stop(new Point(n, n2));
        this.draw(graphics, false);
        this.finalDraw = false;
    }

    protected void draw() {
        this.draw(this.getGraphics());
    }

    protected void draw(boolean bl) {
        this.draw(this.getGraphics(), bl);
    }

    protected void draw(Graphics graphics) {
        this.draw(graphics, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void draw(Graphics graphics, boolean bl) {
        if (graphics == null) return;
        Graphics2D graphics2D = (Graphics2D)graphics;
        try {
            if (bl) {
                graphics2D.setXORMode(this.Uv_xorColor);
            } else {
                if (this.UV_m_bAllowAntiAliasing) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                graphics2D.setPaintMode();
            }
            this.drawRubberBand(graphics2D);
            if (bl) {
                this.setEraseSomething(true);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            graphics.dispose();
            throw throwable;
        }
        {
            Object var4_6 = null;
            graphics.dispose();
            return;
        }
    }

    protected void erase() {
        if (this.getEraseSomething()) {
            this.draw();
            this.setEraseSomething(false);
        }
    }

    protected abstract void drawRubberBand(Graphics var1);

    protected final Graphics getGraphics() {
        return this.m_Image.getGraphics();
    }

    protected final Point getEndPoint() {
        if (this.VU_endPoint == null) {
            this.setEndPoint(new Point(0, 0));
        }
        return this.VU_endPoint;
    }

    protected final boolean getEraseSomething() {
        return this.Uu_eraseSomething;
    }

    protected final Point getStartPoint() {
        if (this.VV_startPoint == null) {
            this.setStartPoint(new Point(0, 0));
        }
        return this.VV_startPoint;
    }

    protected final void setGraphics(Graphics graphics) {
        this.UU_graphics = graphics;
    }

    protected final void setEndPoint(Point point) {
        this.VU_endPoint = point;
    }

    protected final void setEraseSomething(boolean bl) {
        this.Uu_eraseSomething = bl;
    }

    protected final void setStartPoint(Point point) {
        this.VV_startPoint = point;
    }

    protected void start(Point point) {
        this.setEndPoint(point);
        this.setStartPoint(point);
    }

    protected void stop(Point point) {
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        this.setEndPoint(point);
    }
}

