/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.Drawable;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.net.URL;

public class StampSet
implements Drawable {
    Image[] images;
    Rectangle r;
    float displayRatio = 1.0f;
    public static int MOUSEPRESS = 0;
    public static int MOUSERELEASE = 1;
    public static int MOUSECLICK = 2;
    public static int MOUSEDRAG = 3;

    public StampSet() {
    }

    public StampSet(Image[] imageArray) {
        this.images = imageArray;
    }

    public void setImages(Image[] imageArray) {
        this.images = imageArray;
    }

    public void setDisplayRatio(float f) {
        this.displayRatio = f;
    }

    public float getDisplayRatio() {
        return this.displayRatio;
    }

    public void setImages(String string, String[] stringArray) throws Exception {
        if (string.equalsIgnoreCase("jar")) {
            URL uRL = null;
            this.images = new Image[stringArray.length];
            MediaTracker mediaTracker = new MediaTracker(new Frame());
            int n = 0;
            while (n < stringArray.length) {
                uRL = this.getClass().getResource(stringArray[n]);
                if (uRL.getProtocol().equals("jar")) {
                    this.images[n] = Toolkit.getDefaultToolkit().getImage(uRL);
                }
                mediaTracker.addImage(this.images[n], n);
                mediaTracker.waitForID(n);
                ++n;
            }
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        if (this.images == null) {
            return;
        }
        int n = (int)(this.displayRatio * (float)this.images[0].getWidth(null));
        int n2 = (int)(this.displayRatio * (float)this.images[0].getHeight(null));
        graphics2D.drawImage(this.images[0], rectangle.x + rectangle.width / 2 - n / 2, rectangle.y + rectangle.height / 2 - n2 / 2, n, n2, null);
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.images == null) {
            return;
        }
        Image image = this.images[(int)(Math.random() * (double)this.images.length)];
        int n3 = (int)(this.displayRatio * (float)image.getWidth(null));
        int n4 = (int)(this.displayRatio * (float)image.getHeight(null));
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(image, n - n3 / 2, n2 - n4 / 2, n3, n4, null);
    }

    public Image getDefaultImage() {
        if (this.images != null) {
            return this.images[0];
        }
        return null;
    }

    public Rectangle getBounds(Graphics graphics) {
        if (this.r == null && this.images != null && this.images[0] != null) {
            this.r = new Rectangle(this.images[0].getWidth(null), this.images[0].getHeight(null));
        }
        return this.r;
    }

    public void mouseReleased(Graphics graphics, int n, int n2) {
        this.draw(graphics, n, n2);
    }

    public void mousePressed(Graphics graphics, int n, int n2) {
    }

    public void mouseDragged(Graphics graphics, int n, int n2) {
    }

    public void mouseClicked(Graphics graphics, int n, int n2) {
    }

    public String getName() {
        return "Stamp";
    }

    public boolean isMouseEventSupported(int n) {
        return n == MOUSERELEASE;
    }
}

