/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.ImageLoadingButton;
import imager.ImageWrapper;
import imager.ImagerGlobal;
import imager.TexturePanel;
import imager.components.dialogs.JPhotoDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class TextureListPanel
extends JPhotoDialog
implements ImageWrapper,
PropertyChangeListener {
    public static final String TEXTURE_CHANGED = "texture changed";
    private JScrollPane U_jScrollPane1 = new JScrollPane();
    private JButton v_jButton1 = new ImageLoadingButton(this);
    private TexturePanel u_m_TexturePanel = new TexturePanel();
    private JButton V_jButton2 = new JButton();
    int textureCount = 20;
    int w = 80;
    int h = 80;
    TextureThumbnail tmb;
    TexturePanel texturePanelToBeSet;
    Border border1 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.red, new Color(178, 0, 0)), BorderFactory.createEmptyBorder(5, 5, 5, 5));

    public TextureListPanel(Component component, TexturePanel texturePanel) {
        super(JOptionPane.getFrameForComponent(component), "Texture chooser", true);
        try {
            this.jbInit();
            this.texturePanelToBeSet = texturePanel;
            Image image = null;
            URL uRL = null;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, this.textureCount));
            TextureThumbnail textureThumbnail = null;
            int n = 0;
            while (n < this.textureCount) {
                try {
                    uRL = this.getClass().getResource("resources/textures/texture" + n + ".jpg");
                    image = uRL.getProtocol().equals("jar") ? ImagerGlobal.getBufferedImage(Toolkit.getDefaultToolkit().getImage(uRL), this) : ImagerGlobal.loadImage("resources/textures/texture" + n + ".jpg", this);
                    this.tmb = new TextureThumbnail(image);
                    if (n == 0) {
                        textureThumbnail = this.tmb;
                    }
                    this.tmb.setOpaque(true);
                    this.tmb.addPropertyChangeListener(TEXTURE_CHANGED, this);
                    jPanel.add(this.tmb);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            if (textureThumbnail != null) {
                this.tmb = textureThumbnail;
            }
            jPanel.setPreferredSize(new Dimension(this.w * this.textureCount, this.h));
            this.U_jScrollPane1.getViewport().add(jPanel);
            this.tmb.setBackground(Color.red);
            this.u_m_TexturePanel.setTexture(this.tmb.buffImage);
            this.tmb.setBorder(this.border1);
            this.setSize(400, 200);
            this.setLocationRelativeTo(component);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        this.U_jScrollPane1.setBounds(new Rectangle(5, 6, 385, 106));
        this.v_jButton1.setBounds(new Rectangle(8, 114, 32, 32));
        this.u_m_TexturePanel.setBounds(new Rectangle(49, 117, 88, 28));
        this.V_jButton2.setBounds(new Rectangle(146, 114, 82, 29));
        this.V_jButton2.setText("Select");
        this.V_jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextureListPanel.this.jButton2_actionPerformed(actionEvent);
            }
        });
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().add((Component)this.U_jScrollPane1, null);
        this.getContentPane().add((Component)this.V_jButton2, null);
        this.getContentPane().add((Component)this.v_jButton1, null);
        this.getContentPane().add((Component)this.u_m_TexturePanel, null);
    }

    public void imageLoaded(File file, Image image) {
        if (this.tmb != null) {
            this.tmb.setBackground(Color.gray);
        }
        this.u_m_TexturePanel.setTexture(image);
        if (this.tmb != null) {
            this.tmb.setBackground(Color.gray);
            this.tmb.setBorder(null);
            this.tmb = null;
        }
    }

    public void imageSaved(File file) {
    }

    public void imageNotSaved(Exception exception, File file) {
    }

    public void imageNotLoaded(Exception exception) {
    }

    public void setImageLoadingStatus(float f) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(TEXTURE_CHANGED)) {
            if (this.tmb != null) {
                this.tmb.setBackground(Color.gray);
                this.tmb.setBorder(null);
            }
            this.tmb = (TextureThumbnail)propertyChangeEvent.getSource();
            this.tmb.setBackground(Color.red);
            this.u_m_TexturePanel.setTexture((Image)propertyChangeEvent.getNewValue());
            this.tmb.setBorder(this.border1);
        }
    }

    void jButton2_actionPerformed(ActionEvent actionEvent) {
        this.firePropertyChange(TEXTURE_CHANGED, this.texturePanelToBeSet.getTexture(), this.u_m_TexturePanel.getTexture());
        this.texturePanelToBeSet.setTexture(this.u_m_TexturePanel.getTexture());
        this.dispose();
    }

    public Image getTexture() {
        return this.tmb.buffImage;
    }

    public void setTexturePanel(TexturePanel texturePanel) {
        this.texturePanelToBeSet = texturePanel;
    }

    class TextureThumbnail
    extends JLabel {
        BufferedImage buffImage;

        TextureThumbnail(Image image) {
            super(new ImageIcon(image));
            this.buffImage = ImagerGlobal.getBufferedImage(image, this);
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ TextureThumbnail this$1;
                {
                    this.this$1 = textureThumbnail;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    TextureThumbnail.access$0(this.this$1, "texture changed", null, this.this$1.buffImage);
                }
            });
        }

        static /* synthetic */ void access$0(TextureThumbnail textureThumbnail, String string, Object object, Object object2) {
            textureThumbnail.firePropertyChange(string, object, object2);
        }
    }
}

