/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.BMP;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;

public class PCBinaryOutputStream {
    DataOutputStream file;

    public PCBinaryOutputStream(File file) throws IOException {
        this.file = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public PCBinaryOutputStream(URL uRL) throws IOException {
        this.file = new DataOutputStream(new BufferedOutputStream(uRL.openConnection().getOutputStream()));
    }

    public void writeInt(int n) throws IOException {
        int n2 = n << 24 | (n & 0xFF00) << 8 | (n & 0xFF0000) >>> 8 | n >>> 24;
        this.file.writeInt(n2);
    }

    public void writeShort(short s) throws IOException {
        int n = s << 8 | s >>> 8;
        this.file.writeShort((short)n);
    }

    public void writeByte(byte by) throws IOException {
        this.file.writeByte(by);
    }

    public void writeByteArray(byte[] byArray) throws IOException {
        this.file.write(byArray);
    }

    public long getFilePointer() throws IOException {
        return this.file.size();
    }

    public long size() throws IOException {
        return this.file.size();
    }

    public void close() throws IOException {
        this.file.flush();
        this.file.close();
        this.file = null;
    }

    public void finalize() {
        if (this.file != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

