/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.PICT;

import imager.imagefileio.PICT.DataCompression;
import imager.imagefileio.PICT.ImageSaverInterface;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;

public class PICTImageSaver
extends ImageSaverInterface
implements Serializable,
ImageConsumer {
    public static final String FORMAT_CODE = "PICT";
    public static final String FORMAT_COMPLETE_NAME = "Macintosh PICT";
    public static final String FORMAT_EXTENSION = "pct";
    private final int UUU_SRC_COPY = 0;
    private final int VUv_PICT_NULL_HEADER_SIZE = 512;
    private final int Uvv_IMAGE_RESOLUTION = 72;
    private final int Uuv_NBR_BYTES_IN_WORD = 2;
    private final int UVv_NBR_BYTES_IN_LONG = 4;
    private final int UUv_OP_CLIP_RGN = 1;
    private final int VVu_OP_VERSION = 17;
    private final int VUu_OP_DEF_HILITE = 30;
    private final int Uvu_OP_V2_HEADER_OP = 3072;
    private final int Uuu_OP_DIRECT_BITS_RECT = 154;
    private final int UVu_OP_END_OF_PICTURE = 255;
    private final int UUu_OP_VERSION_2 = 767;
    private final int VVV_EXT_VERSION_2_CODE = 65534;
    private FileOutputStream VUV_writeFileHandle;
    private int UvV_width;
    private int UuV_height;
    private int UVV_rowBytes;
    private int UUV_saveStatus;
    private int VVU_byteCount;
    private byte[] VUU_scanlineBytes;
    private byte[] UvU_packedScanlineBytes;
    private int UuU_scanWidthLeft;

    public String getFormatCode() {
        return FORMAT_CODE;
    }

    public String getFormatString() {
        return FORMAT_COMPLETE_NAME;
    }

    public String getFormatExtension() {
        return FORMAT_EXTENSION;
    }

    public boolean saveIt() {
        if (this.saveImage == null) {
            return false;
        }
        this.UUV_saveStatus = 0;
        try {
            this.VUV_writeFileHandle = new FileOutputStream(this.savePath);
        }
        catch (IOException iOException) {
            System.out.println("IOException occurred opening FileOutputStream : " + iOException);
        }
        if (this.VUV_writeFileHandle == null) {
            return false;
        }
        ImageProducer imageProducer = this.saveImage.getSource();
        if (imageProducer == null) {
            return false;
        }
        imageProducer.startProduction(this);
        return true;
    }

    public int checkSave() {
        return this.UUV_saveStatus;
    }

    public void setProperties(Hashtable hashtable) {
        this.UUV_saveStatus |= 4;
    }

    public void setHints(int n) {
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setDimensions(int n, int n2) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[4];
        this.UvV_width = n;
        this.UuV_height = n2;
        this.VVU_byteCount = 0;
        byte[] byArray5 = new byte[512];
        byArray5[0] = 80;
        byArray5[1] = 73;
        byArray5[2] = 67;
        byArray5[3] = 84;
        try {
            this.VUV_writeFileHandle.write(byArray5);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray5.length;
        int n3 = 0;
        while (n3 < byArray2.length) {
            byArray2[n3] = 0;
            ++n3;
        }
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(0, byArray3, 2, 4);
        this.UVU_setIntAsBytes(0, byArray3, 0, 2);
        this.UVU_setIntAsBytes(n, byArray3, 6, 8);
        this.UVU_setIntAsBytes(n2, byArray3, 4, 6);
        try {
            this.VUV_writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray3.length;
        this.UVU_setIntAsBytes(17, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(767, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(3072, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(65534, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(0, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(72, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.UVU_setIntAsBytes(0, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.UVU_setIntAsBytes(72, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.UVU_setIntAsBytes(0, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += 4 * byArray2.length;
        try {
            this.VUV_writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray3.length;
        this.UVU_setIntAsBytes(0, byArray4, 0, byArray4.length);
        try {
            this.VUV_writeFileHandle.write(byArray4);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray4.length;
        this.UVU_setIntAsBytes(30, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(1, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.UVU_setIntAsBytes(10, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += 2 * byArray2.length;
        try {
            this.VUV_writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray3.length;
        this.UVU_setIntAsBytes(154, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(255, byArray4, 0, byArray4.length);
        try {
            this.VUV_writeFileHandle.write(byArray4);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray4.length;
        this.UVV_rowBytes = 4 * n;
        this.UVU_setIntAsBytes(this.UVV_rowBytes, byArray2, 0, byArray2.length);
        byArray2[0] = (byte)(byArray2[0] | 0x80);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        try {
            this.VUV_writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray3.length;
        this.UVU_setIntAsBytes(0, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(4, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(0, byArray4, 0, byArray4.length);
        try {
            this.VUV_writeFileHandle.write(byArray4);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray4.length;
        this.UVU_setIntAsBytes(72, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.UVU_setIntAsBytes(0, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.UVU_setIntAsBytes(72, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.UVU_setIntAsBytes(0, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += 4 * byArray2.length;
        this.UVU_setIntAsBytes(16, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(32, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(3, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(8, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.UVU_setIntAsBytes(0, byArray4, 0, byArray4.length);
        try {
            this.VUV_writeFileHandle.write(byArray4);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray4.length;
        this.UVU_setIntAsBytes(0, byArray4, 0, byArray4.length);
        try {
            this.VUV_writeFileHandle.write(byArray4);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray4.length;
        this.UVU_setIntAsBytes(0, byArray4, 0, byArray4.length);
        try {
            this.VUV_writeFileHandle.write(byArray4);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray4.length;
        try {
            this.VUV_writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        try {
            this.VUV_writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += 2 * byArray3.length;
        this.UVU_setIntAsBytes(0, byArray2, 0, byArray2.length);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        this.VVU_byteCount += byArray2.length;
        this.VUU_scanlineBytes = new byte[3 * this.UvV_width];
        this.UvU_packedScanlineBytes = new byte[DataCompression.getPackBitsMaxDestBytes(this.VUU_scanlineBytes.length)];
        this.UuU_scanWidthLeft = this.UvV_width;
        this.UUV_saveStatus |= 3;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = new byte[2];
        int n7 = 0;
        while (n7 < n4) {
            this.UuU_scanWidthLeft -= n3;
            int n8 = 0;
            while (n8 < n3) {
                int n9 = colorModel.getRGB(byArray[n5 + n7 * n6 + n8] & 0xFF);
                this.VUU_scanlineBytes[n + n8] = (byte)(n9 >> 16 & 0xFF);
                this.VUU_scanlineBytes[n + this.UvV_width + n8] = (byte)(n9 >> 8 & 0xFF);
                this.VUU_scanlineBytes[n + 2 * this.UvV_width + n8] = (byte)(n9 & 0xFF);
                ++n8;
            }
            if (this.UuU_scanWidthLeft == 0) {
                int n10 = DataCompression.packBits(this.VUU_scanlineBytes, this.UvU_packedScanlineBytes, this.VUU_scanlineBytes.length);
                if (this.UVV_rowBytes > 250) {
                    this.UVU_setIntAsBytes(n10, byArray3, 0, byArray3.length);
                    try {
                        this.VUV_writeFileHandle.write(byArray3);
                    }
                    catch (IOException iOException) {
                        this.UUV_saveStatus = 64;
                    }
                    this.VVU_byteCount += byArray3.length;
                } else {
                    this.UVU_setIntAsBytes(n10, byArray2, 0, byArray2.length);
                    try {
                        this.VUV_writeFileHandle.write(byArray2);
                    }
                    catch (IOException iOException) {
                        this.UUV_saveStatus = 64;
                    }
                    this.VVU_byteCount += byArray2.length;
                }
                try {
                    this.VUV_writeFileHandle.write(this.UvU_packedScanlineBytes, 0, n10);
                }
                catch (IOException iOException) {
                    this.UUV_saveStatus = 64;
                }
                this.VVU_byteCount += n10;
                this.UuU_scanWidthLeft = this.UvV_width;
            }
            ++n7;
        }
        this.UUV_saveStatus |= 8;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2];
        int n7 = 0;
        while (n7 < n4) {
            this.UuU_scanWidthLeft -= n3;
            int n8 = 0;
            while (n8 < n3) {
                int n9 = colorModel.getRGB(nArray[n5 + n7 * n6 + n8]);
                this.VUU_scanlineBytes[n + n8] = (byte)(n9 >> 16 & 0xFF);
                this.VUU_scanlineBytes[n + this.UvV_width + n8] = (byte)(n9 >> 8 & 0xFF);
                this.VUU_scanlineBytes[n + 2 * this.UvV_width + n8] = (byte)(n9 & 0xFF);
                ++n8;
            }
            if (this.UuU_scanWidthLeft == 0) {
                int n10 = DataCompression.packBits(this.VUU_scanlineBytes, this.UvU_packedScanlineBytes, this.VUU_scanlineBytes.length);
                if (this.UVV_rowBytes > 250) {
                    this.UVU_setIntAsBytes(n10, byArray2, 0, byArray2.length);
                    try {
                        this.VUV_writeFileHandle.write(byArray2);
                    }
                    catch (IOException iOException) {
                        this.UUV_saveStatus = 64;
                    }
                    this.VVU_byteCount += byArray2.length;
                } else {
                    this.UVU_setIntAsBytes(n10, byArray, 0, byArray.length);
                    try {
                        this.VUV_writeFileHandle.write(byArray);
                    }
                    catch (IOException iOException) {
                        this.UUV_saveStatus = 64;
                    }
                    this.VVU_byteCount += byArray.length;
                }
                try {
                    this.VUV_writeFileHandle.write(this.UvU_packedScanlineBytes, 0, n10);
                }
                catch (IOException iOException) {
                    this.UUV_saveStatus = 64;
                }
                this.VVU_byteCount += n10;
                this.UuU_scanWidthLeft = this.UvV_width;
            }
            ++n7;
        }
        this.UUV_saveStatus |= 8;
    }

    public void imageComplete(int n) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2];
        if ((this.VVU_byteCount & 1) > 0) {
            byArray[0] = 0;
            try {
                this.VUV_writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.UUV_saveStatus = 64;
            }
        }
        this.UVU_setIntAsBytes(255, byArray2, 0, 2);
        try {
            this.VUV_writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.UUV_saveStatus = 64;
        }
        if (this.VUV_writeFileHandle != null) {
            try {
                this.VUV_writeFileHandle.close();
            }
            catch (IOException iOException) {
                this.UUV_saveStatus = 64;
            }
        }
        this.UUV_saveStatus |= 0x20;
    }

    private void UVU_setIntAsBytes(int n, byte[] byArray, int n2, int n3) {
        int n4 = n3 - 1;
        int n5 = 0;
        while (n4 >= n2) {
            byArray[n4] = (byte)(n >> n5 & 0xFF);
            --n4;
            n5 += 8;
        }
    }
}

