/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced.tiff;

import imager.imagefileio.TIFF.enhanced.tiff.IFD;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

class CodedImage {
    public byte[] imageBytes;
    public byte[][] imageStrips;
    public long compType;
    public int bitsPerSample;
    public int samplesPerPixel;
    public int extraSamples;
    public int photometric;
    public int imageWidth;
    public int imageHeight;
    IFD ifd;

    public CodedImage(IFD iFD) {
        this.ifd = iFD;
        this.imageBytes = null;
        this.imageStrips = null;
        this.compType = 1L;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.bitsPerSample = 0;
        this.samplesPerPixel = 1;
        this.extraSamples = -1;
        this.photometric = 0;
        int n = 0;
        while (n < iFD.count) {
            if (iFD.entries[n].tag.equals(256)) {
                this.imageWidth = (int)iFD.entries[n].value;
            } else if (iFD.entries[n].tag.equals(257)) {
                this.imageHeight = (int)iFD.entries[n].value;
            } else if (iFD.entries[n].tag.equals(259)) {
                this.compType = iFD.entries[n].value;
            } else if (iFD.entries[n].tag.equals(258)) {
                this.bitsPerSample = iFD.entries[n].isOffset() ? (iFD.entries[n].type.isShort() ? ((iFD.entries[n].dataArray[0] & 0xFF) << 8) + (iFD.entries[n].dataArray[1] & 0xFF) : ((iFD.entries[n].dataArray[0] & 0xFF) << 24) + ((iFD.entries[n].dataArray[1] & 0xFF) << 16) + ((iFD.entries[n].dataArray[2] & 0xFF) << 8) + (iFD.entries[n].dataArray[3] & 0xFF)) : (int)iFD.entries[n].value;
            } else if (iFD.entries[n].tag.equals(277)) {
                this.samplesPerPixel = (int)iFD.entries[n].value;
            } else if (iFD.entries[n].tag.equals(338)) {
                this.extraSamples = (int)iFD.entries[n].value;
            } else if (iFD.entries[n].tag.equals(262)) {
                this.photometric = (int)iFD.entries[n].value;
            }
            ++n;
        }
    }

    boolean isRaw() {
        return this.compType == 1L;
    }

    boolean isJPEG() {
        return this.compType == 7L || this.compType == 6L;
    }

    boolean isCCITT() {
        return this.compType == 3L || this.compType == 4L || this.compType == 2L || this.compType == 32771L;
    }

    ColorModel makeColorModel() {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        int n = 0;
        while (n < 256) {
            byArray[n] = (byte)(n & 0xFF);
            byArray2[n] = (byte)(n & 0xFF);
            byArray3[n] = (byte)(n & 0xFF);
            ++n;
        }
        return new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }

    ColorModel makeRGBColorModel() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        byte[] byArray = this.ifd.GetEntry((int)320).dataArray;
        int n6 = byArray.length / 6;
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        byte[] byArray4 = new byte[256];
        if (this.ifd.GetEntry((int)262).value == 3L) {
            n5 = 0;
            n4 = n6 * 2;
            n3 = n6 * 4;
            System.out.println("----------------- PALETTE ------------------");
            n2 = 0;
            n = 0;
            while (n2 < n6) {
                byArray2[n2] = (byte)(byArray[n + n5] & 0xFF);
                byArray3[n2] = (byte)(byArray[n + n4] & 0xFF);
                byArray4[n2] = (byte)(byArray[n + n3] & 0xFF);
                System.out.println("#" + n2 + " = (" + (byArray2[n2] & 0xFF) + "," + (byArray3[n2] & 0xFF) + "," + (byArray4[n2] & 0xFF) + "), ");
                ++n2;
                n += 2;
            }
        } else {
            n5 = 0;
            n4 = 2;
            n3 = 4;
            System.out.println("----------------- PALETTE ------------------");
            n2 = 0;
            n = 0;
            while (n2 < n6) {
                byArray2[n2] = (byte)(byArray[n + n5] & 0xFF);
                byArray3[n2] = (byte)(byArray[n + n4] & 0xFF);
                byArray4[n2] = (byte)(byArray[n + n3] & 0xFF);
                System.out.println("#" + n2 + " = (" + (byArray2[n2] & 0xFF) + "," + (byArray3[n2] & 0xFF) + "," + (byArray4[n2] & 0xFF) + "), ");
                ++n2;
                n += 6;
            }
        }
        n2 = n6;
        while (n2 < 256) {
            byArray2[n2] = 0;
            byArray3[n2] = 0;
            byArray4[n2] = 0;
            ++n2;
        }
        return new IndexColorModel(this.bitsPerSample, n6, byArray2, byArray3, byArray4);
    }

    int GetR(int n) {
        return n & 0xFF;
    }

    int GetG(int n) {
        return n >> 8 & 0xFF;
    }

    int GetB(int n) {
        return n >> 16 & 0xFF;
    }

    int GetA(int n) {
        return n >> 24 & 0xFF;
    }

    public Image getImage() {
        Image image = null;
        ImageProducer imageProducer = (ImageProducer)this.getImageProducer();
        if (imageProducer != null) {
            image = Toolkit.getDefaultToolkit().createImage(imageProducer);
        }
        return image;
    }

    public Object getImageProducer() {
        ColorModel colorModel = this.makeColorModel();
        this.imageWidth = 256;
        this.imageHeight = 256;
        int[] nArray = new int[this.imageWidth * this.imageHeight];
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < this.imageWidth) {
                nArray[n2 + n] = n2 & 0xFF;
                ++n2;
            }
            n += this.imageWidth;
        }
        return new MemoryImageSource(this.imageWidth, this.imageHeight, nArray, 0, this.imageWidth);
    }

    boolean CanDecodeImage() {
        switch (this.bitsPerSample) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                break;
            }
            default: {
                String string = "Sorry, can not handle images with " + this.bitsPerSample + "-bit samples";
                System.out.println(string);
                return false;
            }
        }
        int n = this.extraSamples == -1 ? this.samplesPerPixel : this.samplesPerPixel - this.extraSamples;
        System.out.println("samplesPerPixel:" + this.samplesPerPixel + ", extraSamples:" + this.extraSamples + ", colorChannels:" + n + ", photometric:" + this.photometric);
        if (this.photometric == 0 && this.extraSamples != -1) {
            switch (n) {
                case 1: {
                    this.photometric = 1;
                    break;
                }
                case 3: {
                    this.photometric = 2;
                    break;
                }
                default: {
                    String string = "Missing needed PHOTOMETRIC tag";
                    System.out.println(string);
                    return false;
                }
            }
        }
        switch (this.photometric) {
            case 0: 
            case 1: 
            case 3: {
                int n2 = this.ifd.GetFieldValue(284);
                if (n2 != 1 || this.samplesPerPixel == 1) break;
                String string = "Sorry, can not handle contiguous data with PHOTOMETRIC=" + this.photometric + ", and Samples per Pixel=" + this.samplesPerPixel;
                System.out.println(string);
                return false;
            }
            case 6: {
                int n3 = this.ifd.GetFieldValue(284);
                if (n3 == 1) break;
                String string = "Sorry, can not handle YCbCr images with Planarconfiguration=" + n3;
                System.out.println(string);
                return false;
            }
            case 2: {
                if (n >= 3) break;
                String string = "Sorry, can not handle RGB image with Color channels=" + n;
                System.out.println(string);
                return false;
            }
            default: {
                String string = "Sorry, can not handle image with Photometric=" + this.photometric;
                System.out.println(string);
                return false;
            }
        }
        return true;
    }
}

