/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.ConvolveFilter;
import imager.plugins.Kernel;

public class GaussianFilter
extends ConvolveFilter {
    static final long serialVersionUID = 5377089073023183684L;
    protected int radius;

    public GaussianFilter() {
        this(2);
    }

    public GaussianFilter(int n) {
        this.setRadius(n);
    }

    public void setRadius(int n) {
        this.radius = n;
        this.setKernel(GaussianFilter.makeKernel(n));
    }

    public int getRadius() {
        return this.radius;
    }

    public static Kernel makeKernel(int n) {
        int n2;
        int n3 = n2 = n * 2 + 1;
        float[] fArray = new float[n2 * n3];
        float f = (float)n / 3.0f;
        float f2 = n * n;
        int n4 = 0;
        int n5 = -n;
        while (n5 <= n) {
            int n6 = -n;
            while (n6 <= n) {
                float f3 = n5 * n5 + n6 * n6;
                fArray[n4] = f3 > f2 ? 0.0f : (float)Math.exp(-f3 / (2.0f * f * f)) / ((float)Math.PI * 2 * f);
                ++n4;
                ++n6;
            }
            ++n5;
        }
        Kernel kernel = new Kernel(n2, n3, fArray);
        kernel.normalize();
        return kernel;
    }

    public String toString() {
        return "Blur/Gaussian Blur...";
    }
}

