/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.MotionBlurFilter;
import imager.plugins.PreviewFilterCustomizer;
import imager.plugins.SuperGridLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MotionBlurFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener {
    private JSlider UU_angle;
    private JSlider Vv_distance;
    private JSlider Vu_repetitions;
    private JSlider VV_falloff;
    private JRadioButton VU_linearRB;
    private JRadioButton Uv_radialRB;
    private JRadioButton Uu_zoomRB;
    private MotionBlurFilter UV_filter;

    public MotionBlurFilterCustomizer() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        SuperGridLayout superGridLayout = new SuperGridLayout(2, 2);
        jPanel.setLayout(superGridLayout);
        superGridLayout.setColWeight(1, 1);
        JPanel jPanel2 = new JPanel();
        superGridLayout = new SuperGridLayout(2, 1);
        jPanel2.setLayout(superGridLayout);
        superGridLayout.setAlignment(7);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Type"));
        this.VU_linearRB = new JRadioButton("Linear");
        jPanel2.add(this.VU_linearRB);
        this.Uv_radialRB = new JRadioButton("Radial");
        jPanel2.add(this.Uv_radialRB);
        this.Uu_zoomRB = new JRadioButton("Zoom");
        jPanel2.add(this.Uu_zoomRB);
        this.VU_linearRB.setSelected(true);
        this.VU_linearRB.addChangeListener(this);
        this.Uv_radialRB.addChangeListener(this);
        this.Uu_zoomRB.addChangeListener(this);
        jPanel.add(jPanel2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.VU_linearRB);
        buttonGroup.add(this.Uv_radialRB);
        buttonGroup.add(this.Uu_zoomRB);
        jPanel.add(new JPanel());
        jPanel.add(new JLabel("Angle:", 4));
        this.UU_angle = new JSlider(0, 0, 360, 0);
        jPanel.add(this.UU_angle);
        this.UU_angle.setPaintTicks(true);
        this.UU_angle.setMajorTickSpacing(360);
        this.UU_angle.setMinorTickSpacing(30);
        this.UU_angle.setPaintLabels(true);
        this.UU_angle.addChangeListener(this);
        jPanel.add(new JLabel("Amount:", 4));
        this.Vu_repetitions = new JSlider(0, 0, 30, 0);
        jPanel.add(this.Vu_repetitions);
        this.Vu_repetitions.setPaintTicks(true);
        this.Vu_repetitions.setMajorTickSpacing(5);
        this.Vu_repetitions.setMinorTickSpacing(1);
        this.Vu_repetitions.setPaintLabels(true);
        this.Vu_repetitions.addChangeListener(this);
    }

    public void setObject(Object object) {
        super.setObject(object);
        MotionBlurFilter motionBlurFilter = (MotionBlurFilter)object;
        this.UV_filter = null;
        this.UU_angle.setValue((int)((double)(motionBlurFilter.getAngle() * 180.0f) / Math.PI));
        this.Vu_repetitions.setValue(motionBlurFilter.getRepetitions());
        switch (motionBlurFilter.getType()) {
            case 0: {
                this.VU_linearRB.setSelected(true);
                break;
            }
            case 1: {
                this.Uv_radialRB.setSelected(true);
                break;
            }
            case 2: {
                this.Uu_zoomRB.setSelected(true);
            }
        }
        this.UV_filter = motionBlurFilter;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.UV_filter != null) {
            Object object = changeEvent.getSource();
            if (object instanceof JSlider && ((JSlider)object).getValueIsAdjusting()) {
                return;
            }
            if (object == this.UU_angle) {
                this.UV_filter.setAngle((float)this.UU_angle.getValue() * 3.141593f / 180.0f);
            } else if (object == this.Vu_repetitions) {
                this.UV_filter.setRepetitions(this.Vu_repetitions.getValue());
            } else if (object == this.VU_linearRB) {
                this.UV_filter.setType(0);
            } else if (object == this.Uv_radialRB) {
                this.UV_filter.setType(1);
            } else if (object == this.Uu_zoomRB) {
                this.UV_filter.setType(2);
            }
            this.preview();
        }
    }
}

