/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.TransformFilter;

public class TwirlFilter
extends TransformFilter {
    static final long serialVersionUID = 1550445062822803342L;
    private float UU_angle = 0.0f;
    private float UV_centreX = 0.0f;
    private float Uu_centreY = 0.0f;
    private float Uv_radius = 0.0f;
    private float VU_radius2 = 0.0f;

    public void setAngle(float f) {
        this.UU_angle = f;
    }

    public float getAngle() {
        return this.UU_angle;
    }

    public void setDimensions(int n, int n2) {
        super.setDimensions(n, n2);
        this.UV_centreX = n / 2;
        this.Uu_centreY = n2 / 2;
        this.Uv_radius = Math.min(this.UV_centreX, this.Uu_centreY);
        this.VU_radius2 = this.Uv_radius * this.Uv_radius;
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        float f = (float)n - this.UV_centreX;
        float f2 = (float)n2 - this.Uu_centreY;
        float f3 = f * f + f2 * f2;
        if (f3 > this.VU_radius2) {
            fArray[0] = n;
            fArray[1] = n2;
        } else {
            f3 = (float)Math.sqrt(f3);
            float f4 = (float)Math.atan2(f2, f) + this.UU_angle * (this.Uv_radius - f3) / this.Uv_radius;
            fArray[0] = this.UV_centreX + f3 * (float)Math.cos(f4);
            fArray[1] = this.Uu_centreY + f3 * (float)Math.sin(f4);
        }
    }

    public String toString() {
        return "Distort/Twirl...";
    }
}

