/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.PreviewFilterCustomizer;
import imager.plugins.SuperGridLayout;
import imager.plugins.TwirlFilter;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TwirlFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener {
    private JSlider U_angle;
    private TwirlFilter V_filter;

    public TwirlFilterCustomizer() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        SuperGridLayout superGridLayout = new SuperGridLayout(0, 2);
        jPanel.setLayout(superGridLayout);
        superGridLayout.setColWeight(1, 1);
        jPanel.add(new JLabel("Angle:", 4));
        this.U_angle = new JSlider(0, -720, 720, 0);
        jPanel.add(this.U_angle);
        this.U_angle.setPaintTicks(true);
        this.U_angle.setMajorTickSpacing(360);
        this.U_angle.setMinorTickSpacing(30);
        this.U_angle.setPaintLabels(true);
        this.U_angle.addChangeListener(this);
    }

    public void setObject(Object object) {
        super.setObject(object);
        this.V_filter = (TwirlFilter)object;
        this.U_angle.setValue((int)((double)(this.V_filter.getAngle() * 180.0f) / Math.PI));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.V_filter != null) {
            Object object = changeEvent.getSource();
            if (object instanceof JSlider && ((JSlider)object).getValueIsAdjusting()) {
                return;
            }
            if (object == this.U_angle) {
                this.V_filter.setAngle((float)this.U_angle.getValue() * 3.141593f / 180.0f);
            }
            this.preview();
        }
    }
}

