/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class BetterFocusManager
extends DefaultKeyboardFocusManager
implements Runnable {
    private JTextComponent textComponent;
    private boolean traversed;
    private boolean acceleratorFix;

    public BetterFocusManager(boolean acceleratorFix) {
        this.acceleratorFix = acceleratorFix;
        this.addPropertyChangeListener("focusOwner", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (BetterFocusManager.this.traversed && evt.getNewValue() != null) {
                    BetterFocusManager.this.selectText(evt.getNewValue());
                    BetterFocusManager.this.traversed = false;
                }
            }
        });
    }

    private void selectText(Object component) {
        JSpinner spinner;
        if (component instanceof JTextField) {
            this.textComponent = (JTextComponent)component;
            SwingUtilities.invokeLater(this);
        } else if (component instanceof JSpinner && (spinner = (JSpinner)component).getEditor() instanceof JSpinner.DefaultEditor) {
            this.textComponent = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        if (this.textComponent.getDocument() != null) {
            Caret c = this.textComponent.getCaret();
            c.setDot(this.textComponent.getDocument().getLength());
            c.moveDot(0);
        }
    }

    public void focusPreviousComponent(Component component) {
        this.traversed = true;
        super.focusPreviousComponent(component);
    }

    public void focusNextComponent(Component component) {
        this.traversed = true;
        super.focusNextComponent(component);
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        Window w;
        if (this.acceleratorFix && e.isMetaDown() && e.getID() == 401 && (w = this.getFocusedWindow()) instanceof JDialog) {
            JFrame f;
            JMenuBar menuBar;
            while ((w = w.getOwner()) instanceof JDialog) {
            }
            if (w instanceof JFrame && (menuBar = (f = (JFrame)w).getJMenuBar()) != null) {
                e.setSource(menuBar);
                this.setGlobalFocusOwner(menuBar);
            }
        }
        return super.dispatchKeyEvent(e);
    }
}

