/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import com.jhlabs.app.NumericDocument;
import javax.swing.JTextField;

public class NumericTextField
extends JTextField {
    private double minValue = Double.MIN_VALUE;
    private double maxValue = Double.MAX_VALUE;

    public NumericTextField(int width) {
        this(width, 0, true, false, false);
    }

    public NumericTextField(int width, int defaultValue) {
        this(width, defaultValue, true, false, false);
    }

    public NumericTextField(int width, int defaultValue, boolean allowSign, boolean allowDecimalPoint, boolean allowExponent) {
        super(width);
        this.setDocument(new NumericDocument(allowDecimalPoint ? 25 : width, allowSign, allowDecimalPoint, allowExponent));
        this.setValue(defaultValue);
    }

    public void setValue(int value) {
        this.setText(Integer.toString(value));
    }

    public void setValue(double value) {
        this.setText(Double.toString(value));
    }

    public int getIntValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getHexIntValue() {
        try {
            return Integer.parseInt(this.getText(), 16);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public double getDoubleValue() {
        try {
            return Double.parseDouble(this.getText());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }
}

