/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.beans.BeanUtils;
import com.jhlabs.ie.Brush;
import com.jhlabs.image.BoxBlurFilter;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.xml.XMLParser;
import com.jhlabs.xml.XMLUtils;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class BrushReader
implements DocumentHandler {
    private Vector brushes = new Vector();
    private Brush brush;
    private File baseDir;

    public BrushReader(File baseDir) {
        this.baseDir = baseDir;
    }

    public static Vector readBrushes(File baseDir, InputStream is) throws SAXException, IOException {
        BrushReader xr = new BrushReader(baseDir);
        XMLParser xp = new XMLParser();
        xp.setDocumentHandler(xr);
        xp.parse(new InputSource(is));
        return xr.getBrushes();
    }

    public Vector getBrushes() {
        return this.brushes;
    }

    public void setDocumentLocator(Locator l) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String tag, AttributeList attrs) throws SAXException {
        if (!tag.equals("brushes")) {
            if (tag.equals("brush")) {
                this.brush = new Brush();
                this.brushes.addElement(this.brush);
                int count = attrs.getLength();
                for (int i = 0; i < count; ++i) {
                    String key = attrs.getName(i);
                    String value = attrs.getValue(i);
                    try {
                        BeanUtils.setProperty(this.brush, key, value);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Can't set property: " + key + " " + value);
                        e.printStackTrace();
                    }
                }
            } else if (tag.equals("image")) {
                String name = attrs.getValue("src");
                try {
                    BufferedImage image = ImageUtils.createImage(Toolkit.getDefaultToolkit().getImage(new File(this.baseDir, name).getPath()).getSource());
                    int frames = this.getIntValue(attrs, "frames", 1);
                    this.brush.setFrames(frames);
                    this.brush.setImage(image);
                    if (this.brush.getRadius() == 0.0f) {
                        this.brush.setRadius((float)image.getWidth() / 2.0f);
                    }
                }
                catch (Exception e) {
                    System.out.println("Can't get image: " + name);
                    e.printStackTrace();
                }
            } else if (tag.equals("filter")) {
                this.brush.setFilters(new BufferedImageOp[]{new BoxBlurFilter(3.0f, 3.0f, 1)});
            } else if (tag.equals("opacity")) {
                float base = XMLUtils.getFloatValue(attrs, "base", 0.0f);
                float pressure = XMLUtils.getFloatValue(attrs, "pressure", 0.0f);
                this.brush.setPressureSensitivity(pressure);
            }
        }
    }

    public void endElement(String tag) throws SAXException {
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
    }

    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    private int getIntValue(AttributeList attrs, String name, int defaultValue) {
        if (attrs != null && (name = attrs.getValue(name)) != null) {
            try {
                return BrushReader.parseInt(name, defaultValue);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int parseInt(String s, int defaultValue) throws NumberFormatException {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (s.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (s.startsWith("0x", index) || s.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (s.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (s.startsWith("0", index) && s.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        try {
            int result = BrushReader.parseInt2(s.substring(index), radix);
            return negative ? -result : result;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static int parseInt2(String s, int radix) throws NumberFormatException {
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max > 0) {
            int digit;
            int limit;
            if (s.charAt(0) == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException(s);
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException(s);
                }
                result *= radix;
                result -= digit;
            }
        } else {
            throw new NumberFormatException(s);
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(s);
        }
        return -result;
    }
}

