/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.app.Application;
import com.jhlabs.app.ApplicationAction;
import com.jhlabs.app.Checkable;
import com.jhlabs.app.Document;
import com.jhlabs.app.DocumentWindow;
import com.jhlabs.app.Plugin;
import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.ie.Brush;
import com.jhlabs.ie.BrushReader;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionController;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.CompositionView;
import com.jhlabs.ie.CompositionWindow;
import com.jhlabs.ie.FileFormat;
import com.jhlabs.ie.Palette;
import com.jhlabs.ie.SimpleBrush;
import com.jhlabs.ie.StartThread;
import com.jhlabs.ie.Tool;
import com.jhlabs.ie.Toolbox;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.ie.ui.LayerPanel;
import com.jhlabs.ie.ui.NewImageDialog;
import com.jhlabs.ie.ui.PreferencesDialog;
import com.jhlabs.image.Colormap;
import com.jhlabs.image.FilterContext;
import com.jhlabs.image.FilterCustomizer;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.LinearColormap;
import com.jhlabs.image.PaintingContext;
import com.jhlabs.image.SpectrumColormap;
import com.jhlabs.math.Function2D;
import com.jhlabs.math.ImageFunction2D;
import com.jhlabs.util.NameValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.awt.image.RasterOp;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CompositionApplication
extends Application
implements FilterContext,
PropertyChangeListener {
    public static Toolbox toolbox;
    private JPanel toolProperties;
    private LayerPanel layerPanel;
    public static Clipboard clipboard;
    private JPanel palettesPanel;
    private JPanel toolPropertiesPanel;
    public Vector fileFormats;
    private Vector filters;
    private Vector pluginTools;
    private Vector pluginPalettes;
    private PreferencesDialog preferencesDialog;
    private CompositionController imageController;
    private Tool tool;
    private DefaultListModel colormaps;
    private Brush brush;
    private Vector brushes;
    private Object lastFilter = null;
    private PaintingContext paintingContext;
    private MarchingAntsThread marchingAntsThread;
    private Vector palettes = new Vector();
    private ResourceBundle imageResources;
    private NewFromClipboardAction newFromClipboardAction;
    public static final String CURRENT_BRUSH_PROPERTY = "brush";
    public static final String CURRENT_TOOL_PROPERTY = "tool";
    private Hashtable toolDialogs = new Hashtable();
    private Component currentToolCustomizer;

    public CompositionApplication() {
        this(null);
    }

    public CompositionApplication(Container container) {
        this(container, "Config.xml");
    }

    public CompositionApplication(Container container, String configFile) {
        super(container);
        this.newFromClipboardAction = new NewFromClipboardAction();
        this.registerAction(this.newFromClipboardAction);
        this.registerAction(new OpenURLAction());
        this.registerAction(new TidyWindowsAction());
        try {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (SecurityException e) {
            clipboard = new Clipboard("com.jhlabs.ie.clipboard");
        }
        this.imageController = new CompositionController(this);
        this.mainController = this.imageController;
        this.setSplashMessage("Registering plugins");
        try {
            this.loadConfigFile(this.getClass().getResourceAsStream(configFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSplashMessage("Starting up");
        this.paintingContext = PaintingContext.getInstance();
        this.paintingContext.setColormap((Colormap)this.colormaps.firstElement());
        this.palettesPanel = new JPanel();
        this.palettesPanel.setLayout(new SuperGridLayout(0, 1));
        this.getContentPane().add((Component)this.palettesPanel, "East");
        if (this.isMDI) {
            this.toolPropertiesPanel = new JPanel();
            this.toolPropertiesPanel.setPreferredSize(new Dimension(32, 40));
            this.toolPropertiesPanel.setLayout(new FlowLayout(0));
            this.desktopPanel.add((Component)this.toolPropertiesPanel, "North");
        }
        JDesktopPane layeredPane = this.getDesktopPane();
        this.toolProperties = new JPanel();
        this.toolProperties.setAlignmentX(0.0f);
        if (this.isMDI) {
            this.toolPropertiesPanel.add(this.toolProperties);
            this.toolProperties.setName("showToolProperties");
            this.palettes.add(this.toolProperties);
        } else {
            JDialog d = this.addPalette(this.toolProperties, "showToolProperties", "Tool");
            if (d != null) {
                d.setTitle("");
                d.getRootPane().putClientProperty("Quaqua.RootPane.isVertical", Boolean.TRUE);
                d.setVisible(false);
            }
        }
        toolbox = new Toolbox();
        this.addPropertyChangeListener(CompositionApplication.toolbox.colorPatches);
        if (this.isMDI) {
            this.getContentPane().add((Component)toolbox, "West");
        } else {
            this.pluginPalettes.add(toolbox);
        }
        toolbox.setAlignmentX(0.0f);
        this.getFrame().invalidate();
        this.getFrame().validate();
        this.getFrame().addWindowListener(new WindowWatcher());
        Iterator it = this.pluginPalettes.iterator();
        while (it.hasNext()) {
            Palette p = (Palette)it.next();
            p.startup(this);
            this.addPalette((Component)((Object)p), p.getName(), this.localize(p.getName()));
        }
        this.tidyWindows(true);
        it = this.palettes.iterator();
        while (it.hasNext()) {
            Component component = (Component)it.next();
            this.registerAction(new ShowComponentAction(component.getName(), component));
        }
        if (this.isMDI) {
            this.makeMenuBar();
            this.imageController.makeMenuBarAndToolBar();
        }
        if (this.brushes.size() != 0) {
            this.setBrush((Brush)this.brushes.firstElement());
        }
        if (this.isMDI && container == null) {
            this.getFrame().setVisible(true);
        }
        if (!this.isMDI) {
            JFrame f = this.getFrame();
            f.getContentPane().add(new JButton());
            this.currentMenubar = this.imageController.makeMenubar(null);
            f.setJMenuBar(this.currentMenubar);
            f.setVisible(true);
        }
        this.registerFileHandlers();
        this.readRecentFilesFromPreferences();
        this.hideSplashScreen();
    }

    public CompositionController getCompositionController() {
        return this.imageController;
    }

    public JDialog addPalette(Component contents, String name, String title) {
        JDialog d = null;
        if (this.isMDI) {
            this.palettesPanel.add(contents);
        } else {
            d = new JDialog(this.getFrame(), title){

                public boolean getFocusableWindowState() {
                    return true;
                }
            };
            d.setFocusableWindowState(false);
            d.setResizable(false);
            if (UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
                d.setUndecorated(true);
                d.getRootPane().setWindowDecorationStyle(1);
            }
            d.getRootPane().setFont(CompositionApplication.getSmallSystemFont());
            d.getRootPane().putClientProperty("Quaqua.RootPane.isVertical", Boolean.FALSE);
            d.getRootPane().putClientProperty("Quaqua.RootPane.isPalette", Boolean.TRUE);
            d.getContentPane().add(contents);
            d.setDefaultCloseOperation(1);
            d.setVisible(false);
            d.pack();
        }
        contents.setName(name);
        this.palettes.add(contents);
        return d;
    }

    public void setPaletteVisible(Component component, boolean visible) {
        if (!this.isMDI) {
            component = SwingUtilities.getWindowAncestor(component);
        }
        component.setVisible(visible);
    }

    public void tidyWindows(boolean usePrefs) {
        if (!this.isMDI) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration[] gc = gd.getConfigurations();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc[0]);
            int width = Toolkit.getDefaultToolkit().getScreenSize().width;
            int y = insets.top;
            int west_y = insets.top;
            Preferences preferences = null;
            try {
                preferences = Preferences.userNodeForPackage(this.getClass());
            }
            catch (SecurityException e) {
                usePrefs = false;
            }
            Iterator it = this.pluginPalettes.iterator();
            while (it.hasNext()) {
                Component component = (Component)it.next();
                Palette palette = (Palette)((Object)component);
                float alignmentX = component.getAlignmentX();
                component = SwingUtilities.getWindowAncestor(component);
                boolean visible = usePrefs ? preferences.getBoolean(palette.getName(), true) : component.isVisible();
                if (!visible) continue;
                if (alignmentX == 0.0f) {
                    component.setLocation(insets.left, west_y);
                    west_y += component.getHeight();
                    continue;
                }
                component.setLocation(width - insets.right - component.getWidth(), y);
                y += component.getHeight();
            }
            SwingUtilities.getWindowAncestor(this.toolProperties).setLocation(insets.left + SwingUtilities.getWindowAncestor(toolbox).getWidth(), insets.top);
        }
    }

    public String localize(String name) {
        if (this.imageResources == null) {
            this.imageResources = ResourceBundle.getBundle("com.jhlabs.ie.CompositionResourceBundle");
        }
        try {
            return this.imageResources.getString(name);
        }
        catch (MissingResourceException missingResourceException) {
            return super.localize(name);
        }
    }

    public String getVersionString() {
        return "Version 2.1.359";
    }

    protected BufferedImage getSplashImage() {
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("splash.jpg"));
            Graphics2D g = image.createGraphics();
            g.setColor(Color.black);
            g.setFont(new Font("sansserif", 0, 10));
            FontMetrics fm = g.getFontMetrics();
            String s = this.getVersionString();
            g.drawString(s, image.getWidth() - fm.stringWidth(s) - 20, 20);
            g.dispose();
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setPaintingContext(PaintingContext paintingContext) {
        this.paintingContext = paintingContext;
    }

    public PaintingContext getPaintingContext() {
        return this.paintingContext;
    }

    public void setTool(Tool tool) {
        if (this.tool != null) {
            this.tool.setActive(false);
        }
        this.tool = tool;
        if (this.toolProperties != null) {
            this.showToolCustomizer(tool);
        } else {
            this.showMessage(tool.getHelpText());
        }
        this.changeSupport.firePropertyChange(CURRENT_TOOL_PROPERTY, null, tool);
        if (tool != null) {
            tool.setActive(true);
        }
    }

    public Tool getTool() {
        return this.tool;
    }

    public int getPaintColor(MouseEvent e) {
        return e.isControlDown() ? this.getBgColor() : this.getFgColor();
    }

    public void setFgColor(int c) {
        this.paintingContext.setFgColor(c);
    }

    public int getFgColor() {
        return this.paintingContext.getFgColor();
    }

    public void setBgColor(int c) {
        this.paintingContext.setBgColor(c);
    }

    public int getBgColor() {
        return this.paintingContext.getBgColor();
    }

    public void setColormap(Colormap colormap) {
        this.paintingContext.setColormap(colormap);
    }

    public Colormap getColormap() {
        return this.paintingContext.getColormap();
    }

    public Iterator getImages() {
        Vector<NameValue> v = new Vector<NameValue>();
        Enumeration en = this.getDocuments();
        while (en.hasMoreElements()) {
            CompositionDocument document = (CompositionDocument)en.nextElement();
            Composition composition = document.getComposition();
            Iterator it = composition.getLayers().iterator();
            while (it.hasNext()) {
                Layer layer = (Layer)it.next();
                NameValue nv = new NameValue(document.toString() + "/" + layer.getName(), layer);
                v.add(nv);
            }
        }
        return v.iterator();
    }

    public void setColormaps(DefaultListModel colormaps) {
        this.colormaps = colormaps;
    }

    public DefaultListModel getColormaps() {
        return this.colormaps;
    }

    public void setBrush(Brush brush) {
        Brush oldValue = this.brush;
        this.brush = brush;
        this.changeSupport.firePropertyChange(CURRENT_BRUSH_PROPERTY, oldValue, brush);
    }

    public Brush getBrush() {
        return this.brush;
    }

    public void setBrushes(Vector brushes) {
        this.brushes = brushes;
    }

    public Vector getBrushes() {
        return this.brushes;
    }

    public void makeDefaultBrushes() {
        try {
            File brushFolder = new File(this.getProperty("brushesFolder", "brushes"));
            if (!brushFolder.exists()) {
                brushFolder = new File(System.getProperty("user.dir"), "brushes");
            }
            if (brushFolder.exists()) {
                String[] files = brushFolder.list();
                for (int i = 0; i < files.length; ++i) {
                    String baseName;
                    File file;
                    String fileName;
                    int index;
                    if (i == 0) {
                        this.brushes.addElement(new SimpleBrush(5.0f));
                    }
                    String extension = (index = (fileName = (file = new File(brushFolder, files[i])).getPath()).lastIndexOf(46)) < 0 ? "" : fileName.substring(index).toLowerCase();
                    String string = baseName = index < 0 ? "" : fileName.substring(0, index);
                    if (!extension.equals(".xml")) continue;
                    FileInputStream is = new FileInputStream(file);
                    Vector v = BrushReader.readBrushes(brushFolder, is);
                    if (v != null) {
                        Iterator it = v.iterator();
                        while (it.hasNext()) {
                            this.brushes.addElement(it.next());
                        }
                    }
                    is.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Enumeration getDocuments() {
        return this.imageController.getDocuments();
    }

    public CompositionDocument getCompositionDocumentByID(int id) {
        Enumeration en = this.getDocuments();
        while (en.hasMoreElements()) {
            CompositionDocument document = (CompositionDocument)en.nextElement();
            if (document.getDocumentNumber() != id) continue;
            return document;
        }
        return null;
    }

    public Vector getPluginTools() {
        return this.pluginTools;
    }

    public void setLastFilter(Object lastFilter) {
        this.lastFilter = lastFilter;
    }

    public Object getLastFilter() {
        return this.lastFilter;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if ("colormap".equals(name)) {
            this.setColormap((Colormap)event.getNewValue());
        } else if (CURRENT_BRUSH_PROPERTY.equals(name)) {
            this.setBrush((Brush)event.getNewValue());
        } else if ("color".equals(name)) {
            this.setFgColor(((Color)event.getNewValue()).getRGB());
        }
    }

    public void registerPlugin(Object o) {
        if (o instanceof Plugin) {
            this.addPlugin((Plugin)o);
        }
        if (o instanceof ImageFilter) {
            this.filters.addElement(o);
        } else if (o instanceof BufferedImageOp) {
            this.filters.addElement(o);
        } else if (o instanceof RasterOp) {
            this.filters.addElement(o);
        } else if (o instanceof FileFormat) {
            Enumeration e = ((FileFormat)o).getSubFileFormats();
            if (e != null) {
                while (e.hasMoreElements()) {
                    this.fileFormats.addElement(e.nextElement());
                }
            } else {
                this.fileFormats.addElement(o);
            }
        } else if (o instanceof Colormap) {
            this.colormaps.addElement(o);
        } else if (o instanceof Brush) {
            this.brushes.addElement(o);
        } else if (o instanceof Tool) {
            this.pluginTools.addElement(o);
        } else if (o instanceof Palette) {
            this.pluginPalettes.addElement(o);
        } else if (o instanceof Vector) {
            Enumeration e = ((Vector)o).elements();
            while (e.hasMoreElements()) {
                this.registerPlugin(e.nextElement());
            }
        } else if (o instanceof Object[]) {
            Object[] a = (Object[])o;
            for (int i = 0; i < a.length; ++i) {
                this.registerPlugin(a[i]);
            }
        } else {
            super.registerPlugin(o);
        }
    }

    public void registerPlugins() {
        this.filters = new Vector();
        this.fileFormats = new Vector();
        this.pluginTools = new Vector();
        this.pluginPalettes = new Vector();
        this.colormaps = new DefaultListModel();
        this.brushes = new Vector();
        this.makeDefaultBrushes();
        super.registerPlugins();
        if (this.colormaps.size() == 0) {
            this.colormaps.addElement(new LinearColormap());
            this.colormaps.addElement(new LinearColormap(-1, -16777216));
            this.colormaps.addElement(new SpectrumColormap());
        }
    }

    public Vector getFilters() {
        return this.filters;
    }

    public String getApplicationName() {
        return "Image Editor";
    }

    public Document readDocument(File file) throws IOException {
        CompositionDocument document = new CompositionDocument(this);
        try {
            ((Document)document).readFile(file);
        }
        catch (OutOfMemoryError e) {
            CompositionApplication.reportException("An error occurred while trying to read the image: " + file.getName(), "Can't Read Image", e);
            throw e;
        }
        return document;
    }

    public DocumentWindow makeWindow(Document document, Object args, boolean show) {
        document.setController(this.imageController);
        DocumentWindow window = this.imageController.makeDocumentWindow(document);
        if (!this.isMDI) {
            JFrame f = window.getJFrame();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration[] gc = gd.getConfigurations();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc[0]);
            f.setLocation(insets.left + SwingUtilities.getWindowAncestor(toolbox).getWidth() + 4, insets.top + SwingUtilities.getWindowAncestor(this.toolProperties).getHeight() + 8);
            f.addWindowListener(new WindowWatcher());
        }
        this.addWindow(window);
        if (show) {
            window.setVisible(true);
        }
        return window;
    }

    public void doNew() {
        NewImageDialog d = new NewImageDialog((Frame)this.getFrame(), 256, 256);
        Dimension size = d.showDialog();
        if (size != null) {
            int color = -1;
            switch (d.getBackground()) {
                case 0: {
                    color = 0;
                    break;
                }
                case 2: {
                    color = this.getBgColor();
                }
            }
            this.makeWindow(new CompositionDocument(this, size.width, size.height, color), null);
        }
    }

    public void newImageFromTransferable(Transferable transferable) {
        if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                BufferedImage image = ImageUtils.convertImageToARGB((Image)transferable.getTransferData(DataFlavor.imageFlavor));
                this.makeWindow(new CompositionDocument(this, image), null);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void newImageFromURL(URL url) {
        try {
            BufferedImage image = ImageIO.read(url);
            this.makeWindow(new CompositionDocument(this, ImageUtils.convertImageToARGB(image)), null);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getDialogParent(), "The image couldn't be download: " + e.getMessage(), "Can't open URL", -1);
        }
    }

    public void newImageFromBufferedImage(BufferedImage image) {
        this.makeWindow(new CompositionDocument(this, image), null);
    }

    public void doPreferences() {
        if (this.preferencesDialog == null) {
            this.preferencesDialog = new PreferencesDialog(this);
        }
        this.preferencesDialog.setVisible(true);
    }

    public void showToolCustomizer(Tool tool) {
        if (this.isMDI) {
            if (tool.hasCustomizer()) {
                Component customizer = (Component)this.toolDialogs.get(tool);
                if (customizer == null) {
                    try {
                        this.busyCursor(true);
                        customizer = tool.getCustomizer();
                        if (customizer instanceof FilterCustomizer) {
                            ((FilterCustomizer)customizer).useSmallFont();
                        }
                        if (customizer != null) {
                            ((Customizer)((Object)customizer)).setObject(tool);
                            this.toolDialogs.put(tool, customizer);
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.busyCursor(false);
                }
                if (this.currentToolCustomizer != customizer) {
                    if (this.currentToolCustomizer != null) {
                        this.toolPropertiesPanel.remove(this.currentToolCustomizer);
                    }
                    this.currentToolCustomizer = customizer;
                    this.toolPropertiesPanel.add(customizer);
                    this.toolPropertiesPanel.revalidate();
                    this.toolPropertiesPanel.repaint();
                }
            } else if (this.currentToolCustomizer != null) {
                this.toolPropertiesPanel.remove(this.currentToolCustomizer);
                this.currentToolCustomizer = null;
                this.toolPropertiesPanel.revalidate();
                this.toolPropertiesPanel.repaint();
            }
        } else {
            if (this.toolProperties != null) {
                Window w = SwingUtilities.getWindowAncestor(this.toolProperties);
                if (tool.hasCustomizer()) {
                    Component customizer = (Component)this.toolDialogs.get(tool);
                    if (customizer == null) {
                        try {
                            this.busyCursor(true);
                            customizer = tool.getCustomizer();
                            if (customizer instanceof FilterCustomizer) {
                                ((FilterCustomizer)customizer).useSmallFont();
                            }
                            if (customizer != null) {
                                ((Customizer)((Object)customizer)).setObject(tool);
                                this.toolDialogs.put(tool, customizer);
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        this.busyCursor(false);
                    }
                    if (this.currentToolCustomizer != customizer) {
                        if (this.currentToolCustomizer != null) {
                            this.toolProperties.remove(this.currentToolCustomizer);
                        }
                        this.currentToolCustomizer = customizer;
                        this.toolProperties.add(customizer);
                    }
                    w.pack();
                    w.setVisible(true);
                } else {
                    w.setVisible(false);
                }
                return;
            }
            JDialog d = (JDialog)this.toolDialogs.get(tool);
            if (d == null) {
                try {
                    this.busyCursor(true);
                    Component customizer = tool.getCustomizer();
                    if (customizer != null) {
                        ((Customizer)((Object)customizer)).setObject(tool);
                        d = this.addPalette(customizer, "showToolProperties", tool.getToolTipText());
                        this.toolDialogs.put(tool, d);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (d != null) {
                d.setVisible(true);
            }
        }
        this.busyCursor(false);
    }

    public Function2D chooseFunction2D() {
        Vector<String> v = new Vector<String>();
        Enumeration en = this.getDocuments();
        while (en.hasMoreElements()) {
            CompositionDocument document = (CompositionDocument)en.nextElement();
            Composition composition = document.getComposition();
            Iterator it = composition.getLayers().iterator();
            while (it.hasNext()) {
                Layer layer = (Layer)it.next();
                v.addElement(document.toString() + "/" + layer.getName());
            }
        }
        Object[] possibleValues = new Object[v.size()];
        v.copyInto(possibleValues);
        Object selectedValue = JOptionPane.showInputDialog(this.getFrame(), "Choose an image:", "Image", 3, null, possibleValues, possibleValues[0]);
        if (selectedValue != null) {
            BufferedImage texture = ((Layer)selectedValue).getImage();
            return new ImageFunction2D(texture, 2, false);
        }
        return null;
    }

    public Image chooseImage() {
        Vector<String> v = new Vector<String>();
        Enumeration en = this.getDocuments();
        while (en.hasMoreElements()) {
            CompositionDocument document = (CompositionDocument)en.nextElement();
            Composition composition = document.getComposition();
            Iterator it = composition.getLayers().iterator();
            while (it.hasNext()) {
                Layer layer = (Layer)it.next();
                v.addElement(document.toString() + "/" + layer.getName());
            }
        }
        Object[] possibleValues = new Object[v.size()];
        v.copyInto(possibleValues);
        Object selectedValue = JOptionPane.showInputDialog(this.getFrame(), "Choose an image:", "Image", 3, null, possibleValues, possibleValues[0]);
        if (selectedValue != null) {
            BufferedImage texture = ((Layer)selectedValue).getImage();
            return texture;
        }
        return null;
    }

    public void doAbout() {
        Object[] arguments = new Object[]{this.getApplicationName(), this.getApplicationVersion()};
        String title = MessageFormat.format(this.commonResources.getString("aboutTitle"), arguments);
        ImageIcon logo = new ImageIcon(this.getSplashImage());
        JOptionPane.showMessageDialog(this.getDialogParent(), logo, title, -1);
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            e.acceptDrag(1);
        } else {
            super.dragEnter(e);
        }
    }

    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            e.acceptDrag(1);
        } else {
            super.dragOver(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent e) {
        try {
            Transferable transferable = e.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                e.acceptDrop(1);
                this.newImageFromTransferable(transferable);
            } else {
                super.drop(e);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                e.getDropTargetContext().dropComplete(true);
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        new StartThread(args).start();
    }

    class OpenURLAction
    extends ApplicationAction {
        public OpenURLAction() {
            super("openURL");
        }

        public void actionPerformed(ActionEvent event) {
            String s = JOptionPane.showInputDialog("Enter a URL:");
            if (s != null) {
                try {
                    CompositionApplication.this.newImageFromURL(new URL(s));
                }
                catch (MalformedURLException e) {
                    JOptionPane.showMessageDialog(CompositionApplication.this.getDialogParent(), "The URL is not valid", "Can't open URL", -1);
                }
            }
        }
    }

    class NewFromClipboardAction
    extends ApplicationAction {
        public NewFromClipboardAction() {
            super("newFromClipboard");
        }

        public boolean isEnabled() {
            if (clipboard != null) {
                Transferable t = clipboard.getContents(this);
                return t != null && t.isDataFlavorSupported(DataFlavor.imageFlavor);
            }
            return false;
        }

        public void actionPerformed(ActionEvent e) {
            Transferable t = clipboard.getContents(this);
            if (t != null && t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                CompositionApplication.this.newImageFromTransferable(t);
            }
        }
    }

    class ShowComponentAction
    extends ApplicationAction
    implements Checkable {
        private String name;
        private Component component;

        public ShowComponentAction(String name, Component component) {
            super(name);
            if (!CompositionApplication.this.isMDI) {
                component = SwingUtilities.getWindowAncestor(component);
            }
            this.component = component;
            this.name = name;
            try {
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                component.setVisible(preferences.getBoolean(name, true));
            }
            catch (SecurityException e) {
                component.setVisible(true);
            }
        }

        public void actionPerformed(ActionEvent event) {
            this.component.setVisible(!this.component.isVisible());
            try {
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                preferences.putBoolean(this.name, this.isChecked());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        public boolean isChecked() {
            return this.component.isVisible();
        }
    }

    class TidyWindowsAction
    extends ApplicationAction {
        public TidyWindowsAction() {
            super("tidyWindows");
        }

        public void actionPerformed(ActionEvent e) {
            CompositionApplication.this.tidyWindows(false);
        }
    }

    class MarchingAntsThread
    extends Thread {
        private boolean finished;

        MarchingAntsThread() {
        }

        public void finish() {
            this.finished = true;
        }

        public void run() {
            this.finished = false;
            try {
                while (!this.finished) {
                    CompositionWindow cw;
                    CompositionView view;
                    DocumentWindow window = Application.getInstance().getCurrentDocumentWindow();
                    if (window instanceof CompositionWindow && (!CompositionApplication.this.isMDI || window.getInternalFrame() == CompositionApplication.this.getDesktopPane().getSelectedFrame()) && (view = (cw = (CompositionWindow)window).getCompositionView()) != null) {
                        view.paintMarchingAnts();
                    }
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class WindowWatcher
    extends WindowAdapter {
        WindowWatcher() {
        }

        public void windowActivated(WindowEvent e) {
            if (CompositionApplication.this.marchingAntsThread == null) {
                CompositionApplication.this.marchingAntsThread = new MarchingAntsThread();
                CompositionApplication.this.marchingAntsThread.start();
            }
            CompositionApplication.this.imageController.enableCommands();
            CompositionApplication.this.newFromClipboardAction.setEnabled(CompositionApplication.this.newFromClipboardAction.isEnabled());
        }

        public void windowDeactivated(WindowEvent e) {
            if (CompositionApplication.this.marchingAntsThread != null) {
                CompositionApplication.this.marchingAntsThread.finish();
            }
            CompositionApplication.this.marchingAntsThread = null;
        }
    }
}

