/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.app.Task;
import com.jhlabs.composite.MarchingAntsOp;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.ie.CompositionController;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.CompositionEvent;
import com.jhlabs.ie.CompositionListener;
import com.jhlabs.ie.Tool;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.ie.tool.ArrowTool;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.TileCache;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class CompositionView
extends JComponent
implements Scrollable,
MouseListener,
MouseMotionListener,
KeyListener,
CompositionListener,
PropertyChangeListener {
    private CompositionDocument document;
    private float xOrigin = 0.0f;
    private float yOrigin = 0.0f;
    private float scale = 1.0f;
    private boolean showGrid = false;
    private boolean showSelection = true;
    private boolean showSelectionAsMask = false;
    private int marchingAntPhase = 0;
    private CompositionController frame;
    private boolean marchingAntsEnabled = true;
    private AffineTransform transform = new AffineTransform();
    public TileCache tileCache;

    public CompositionView(CompositionController frame, CompositionDocument document) {
        this.frame = frame;
        this.document = document;
        Composition composition = document.getComposition();
        this.setDoubleBuffered(true);
        this.setAutoscrolls(true);
        this.setBackground(Color.gray);
        this.addMouseListener(this);
        this.addKeyListener(this);
        composition.addCompositionListener(this);
        document.getApplication().addPropertyChangeListener(this);
        this.setSize(this.xToX(document.getWidth()), this.yToY(document.getHeight()));
        this.revalidate();
        Tool tool = this.getCompositionApplication().getTool();
        if (tool != null) {
            tool.setCursor(this);
        }
    }

    public void dispose() {
        Tool t = this.getTool(null);
        if (t != null && t.getView() == this) {
            t.setView(null);
        }
        this.document.getComposition().removeCompositionListener(this);
        this.document.getApplication().removePropertyChangeListener(this);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        Dimension size = this.getSize();
        Composition composition = this.document.getComposition();
        int iw = (int)(this.scale * (float)composition.getWidth());
        int ih = (int)(this.scale * (float)composition.getHeight());
        this.xOrigin = Math.max(0, (size.width - iw) / 2);
        this.yOrigin = Math.max(0, (size.height - ih) / 2);
        size = this.getPreferredSize();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public CompositionDocument getDocument() {
        return this.document;
    }

    public Composition getComposition() {
        return this.document.getComposition();
    }

    public void zoomBy(double factor) {
        this.setScale((float)((double)this.scale * factor));
    }

    public void zoomToFit() {
        Dimension size = this.getSize();
        double xScale = (double)size.width / (double)this.document.getWidth();
        double yScale = (double)size.height / (double)this.document.getHeight();
        if ((xScale = Math.min(xScale, yScale)) < 1.0) {
            this.setScale(1.0f);
        } else if (xScale <= 2.0) {
            this.setScale(2.0f);
        } else if (xScale <= 4.0) {
            this.setScale(4.0f);
        } else {
            this.setScale(8.0f);
        }
    }

    public void setScale(float newScale) {
        if (this.scale != newScale && newScale <= 16.0f) {
            this.scale = newScale;
            this.setSize(this.xToX(this.document.getWidth()), this.yToY(this.document.getHeight()));
            this.revalidate();
            this.repaint();
        }
    }

    public float getScale() {
        return this.scale;
    }

    public void setShowSelection(boolean b) {
        this.showSelection = b;
        this.repaint();
    }

    public boolean getShowSelection() {
        return this.showSelection;
    }

    public void setShowSelectionAsMask(boolean b) {
        this.showSelectionAsMask = b;
        this.repaint();
    }

    public boolean getShowSelectionAsMask() {
        return this.showSelectionAsMask;
    }

    public void setShowGrid(boolean b) {
        this.showGrid = b;
        this.repaint();
    }

    public boolean getShowGrid() {
        return this.showGrid;
    }

    public int xToX(int x) {
        return (int)((float)x * this.scale + this.xOrigin);
    }

    public int yToY(int y) {
        return (int)((float)y * this.scale + this.yOrigin);
    }

    public int XTox(int x) {
        return (int)(((float)x - this.xOrigin) / this.scale);
    }

    public int YToy(int y) {
        return (int)(((float)y - this.yOrigin) / this.scale);
    }

    public AffineTransform getViewTransform() {
        this.transform.setToTranslation(this.xOrigin, this.yOrigin);
        this.transform.scale(this.scale, this.scale);
        return this.transform;
    }

    public CompositionApplication getCompositionApplication() {
        return (CompositionApplication)this.document.getApplication();
    }

    public Tool getTool(MouseEvent e) {
        Tool tool = this.getCompositionApplication().getTool();
        return tool;
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)(this.scale * (float)this.document.getWidth()), (int)(this.scale * (float)this.document.getHeight()));
    }

    public BufferedImage getActiveImage() {
        return this.document.getActiveImage();
    }

    public BufferedImage getSelection() {
        return this.document.getSelection();
    }

    public Frame getFrame() {
        return this.getCompositionApplication().getFrame();
    }

    public void paintBackground(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(Color.gray);
        g.fillRect(0, 0, size.width, size.height);
        Composition composition = this.getComposition();
        int w = (int)(this.scale * (float)composition.getWidth());
        int h = (int)(this.scale * (float)composition.getHeight());
        ImageUtils.paintCheckedBackground(this, g, (int)this.xOrigin, (int)this.yOrigin, w, h);
        g.setColor(Color.darkGray);
        g.drawRect((int)this.xOrigin - 1, (int)this.yOrigin - 1, w + 1, h + 1);
    }

    public void paintGrid(Graphics2D g, Rectangle r) {
        int w = this.xToX(this.document.getWidth());
        int h = this.yToY(this.document.getHeight());
        g.setColor(Color.gray);
        for (int y = r.y; y < r.y + r.height + 1; ++y) {
            int sy = this.yToY(y);
            g.drawLine(0, sy, w, sy);
        }
        for (int x = r.x; x < r.x + r.width + 1; ++x) {
            int sx = this.xToX(x);
            g.drawLine(sx, 0, sx, h);
        }
    }

    public void paintImage(Graphics2D g, Rectangle r, BufferedImage image) {
        Composition composition = this.getComposition();
        BufferedImage screenImage = composition.getCompositeImage();
        if (screenImage != null) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.drawImage(screenImage, this.xToX(r.x), this.yToY(r.y), this.xToX(r.x + r.width), this.yToY(r.y + r.height), r.x, r.y, r.x + r.width, r.y + r.height, this);
        }
    }

    public synchronized void paintMarchingAnts() {
        Composition composition;
        if (this.marchingAntsEnabled && this.showSelection && !this.showSelectionAsMask && !(composition = this.getComposition()).hasFloatingSelection()) {
            Graphics2D g = (Graphics2D)this.getGraphics();
            int cellSize = (int)this.scale;
            Dimension size = this.getSize();
            Rectangle clip = g.getClipBounds();
            Rectangle r = new Rectangle(0, 0, size.width, size.height);
            if (clip != null) {
                r = r.intersection(clip);
            }
            r = new Rectangle(this.XTox(r.x), this.YToy(r.y), this.XTox(r.x + r.width + cellSize - 1), this.YToy(r.y + r.height + cellSize - 1));
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.paintSelection(g, r, composition.getSelectionLayer());
            g.dispose();
        }
    }

    public void paintSelection(Graphics2D g, Rectangle r, Layer selectionLayer) {
        Composition composition = this.getComposition();
        Rectangle selectedBounds = composition.getSelectedBounds();
        if (selectedBounds != null) {
            r = r.intersection(selectedBounds);
            r.grow(1, 1);
            r = r.intersection(new Rectangle(0, 0, composition.getWidth(), composition.getHeight()));
            int x0 = this.xToX(r.x);
            int y0 = this.yToY(r.y);
            int x1 = this.xToX(r.x + r.width);
            int y1 = this.yToY(r.y + r.height);
            if (x1 > x0 && y1 > y0) {
                BufferedImage selection = selectionLayer.getImage();
                BufferedImage screenImage = new BufferedImage(x1 - x0, y1 - y0, 2);
                Graphics2D g2 = screenImage.createGraphics();
                if (this.showSelectionAsMask) {
                    g2.setColor(Color.blue);
                    g2.fillRect(0, 0, x1 - x0, y1 - y0);
                    g2.setComposite(AlphaComposite.DstIn);
                    g.setComposite(AlphaComposite.getInstance(3, 0.5f));
                }
                g2.drawImage(selection, 0, 0, x1 - x0, y1 - y0, r.x, r.y, r.x + r.width, r.y + r.height, this);
                g2.dispose();
                if (!this.showSelectionAsMask) {
                    screenImage = new MarchingAntsOp(this.marchingAntPhase++).filter(screenImage, screenImage);
                }
                g.drawImage((Image)screenImage, x0, y0, this);
            }
        }
    }

    public void paintView(Graphics2D g) {
        Tool tool;
        Composition composition = this.getComposition();
        BufferedImage image = composition.getCompositeImage();
        int cellSize = (int)this.scale;
        Dimension size = this.getSize();
        Rectangle clip = g.getClipBounds();
        Rectangle r = new Rectangle(0, 0, size.width, size.height);
        if (clip != null) {
            r = r.intersection(clip);
        }
        int x = this.XTox(r.x);
        int y = this.YToy(r.y);
        r = new Rectangle(x, y, this.XTox(r.x + r.width + cellSize - 1) - x, this.YToy(r.y + r.height + cellSize - 1) - y);
        r = r.intersection(new Rectangle(0, 0, this.document.getWidth(), this.document.getHeight()));
        this.paintBackground(g);
        this.paintImage(g, r, image);
        if (this.showGrid && this.scale >= 4.0f) {
            this.paintGrid(g, r);
        }
        if ((this.marchingAntsEnabled || this.showSelectionAsMask) && this.showSelection && !composition.hasFloatingSelection()) {
            this.paintSelection(g, r, composition.getSelectionLayer());
        }
        if ((tool = this.getTool(null)) != null && this.getDocument() == this.document.getApplication().getCurrentDocument()) {
            tool.paint(g);
        }
        if (this.tileCache != null) {
            this.tileCache.paint(g);
        }
    }

    protected void paintComponent(Graphics g) {
        try {
            Tool t = this.getTool(null);
            if (t != null) {
                t.setView(this);
            }
            this.paintView((Graphics2D)g);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void busyCursor(boolean b) {
        this.frame.busyCursor(b);
    }

    public void imageChanged(CompositionEvent e) {
        switch (e.getID()) {
            case 0: 
            case 1: {
                Rectangle r = e.bounds;
                int x = this.xToX(r.x);
                int y = this.yToY(r.y);
                int w = this.xToX(r.x + r.width) - x + 1;
                int h = this.yToY(r.y + r.height) - y + 1;
                this.repaint(x, y, w, h);
                if (e.getID() == 1) {
                    this.document.setChanged(true);
                }
                this.frame.enableCommands();
                break;
            }
            case 3: {
                this.setSize(this.xToX(this.document.getWidth()), this.yToY(this.document.getHeight()));
                this.revalidate();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if ("tool".equals(name)) {
            Tool tool = this.getCompositionApplication().getTool();
            if (tool != null) {
                tool.setCursor(this);
            }
            this.repaint();
        }
    }

    public void doTask(Task task) {
        this.document.doTask(task);
    }

    public void moveSelection(int dx, int dy, boolean copy) {
        this.document.moveSelection(dx, dy, copy);
    }

    public boolean isSelectedAt(int x, int y) {
        Composition composition = this.getComposition();
        Layer layer = composition.getSelectionLayer();
        x = this.XTox(x);
        y = this.YToy(y);
        if (!layer.getBounds().contains(x, y)) {
            return false;
        }
        BufferedImage image = layer.getImage();
        return image.getRGB(x - layer.getX(), y - layer.getY()) != 0;
    }

    public void setMarchingAntsEnabled(boolean marchingAntsEnabled) {
        this.marchingAntsEnabled = marchingAntsEnabled;
    }

    public void setToolFocus() {
        Tool t = this.getTool(null);
        if (t != null) {
            t.setView(this);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        Tool t = this.getTool(e);
        if (t != null) {
            Layer layer;
            if (!t.isSelectionTool() && !(t instanceof ArrowTool) && e.isAltDown() && CompositionApplication.toolbox.dropperTool != null) {
                t = CompositionApplication.toolbox.dropperTool;
            } else if (t.isSelectionTool() && this.document.hasFloatingSelection() && this.isSelectedAt(e.getX(), e.getY())) {
                t = CompositionApplication.toolbox.arrowTool;
            }
            if (!t.usesFloatingSelection()) {
                this.document.performPendingTask();
                this.document.dropFloatingSelection();
            }
            if ((layer = this.getComposition().getActiveLayer()) != null) {
                if (t.isPaintingTool() && !layer.isPaintable()) {
                    if (this.document.makePaintable()) {
                        this.document.doSimplifyLayer(layer);
                    }
                } else {
                    t.setView(this);
                    t.startDrag(this, e);
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.frame.enableCommands();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        Tool t = this.getTool(e);
        if (t != null && t.needsMouseMovedEvents()) {
            this.addMouseMotionListener(this);
        }
    }

    public void mouseExited(MouseEvent e) {
        this.removeMouseMotionListener(this);
    }

    public void mouseMoved(MouseEvent e) {
        Tool t = this.getTool(e);
        if (t != null) {
            t.mouseMoved(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        Tool t = this.getTool(e);
        if (t != null) {
            t.mouseMoved(e);
        }
    }

    public void keyTyped(KeyEvent e) {
        Tool t = this.getTool(null);
        if (t != null) {
            t.keyTyped(e);
        }
    }

    public void keyPressed(KeyEvent e) {
        Tool t = this.getTool(null);
        if (t != null) {
            t.keyPressed(e);
        }
    }

    public void keyReleased(KeyEvent e) {
        Tool t = this.getTool(null);
        if (t != null) {
            t.keyReleased(e);
        }
    }

    public int getPaintColor(MouseEvent e) {
        return e.isControlDown() ? this.getBgColor() : this.getFgColor();
    }

    public int getFgColor() {
        return ((CompositionApplication)this.document.getApplication()).getFgColor();
    }

    public int getBgColor() {
        return ((CompositionApplication)this.document.getApplication()).getBgColor();
    }

    public void setFgColor(int c) {
        ((CompositionApplication)this.document.getApplication()).setFgColor(c);
    }

    public void setBgColor(int c) {
        ((CompositionApplication)this.document.getApplication()).setBgColor(c);
    }

    public void showMessage(String message) {
        this.frame.showMessage(message);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 16;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 16;
    }

    public boolean getScrollableTracksViewportWidth() {
        JViewport vp = (JViewport)this.getParent();
        Dimension size = vp.getExtentSize();
        Composition composition = this.document.getComposition();
        int w = (int)(this.scale * (float)composition.getWidth());
        return size.width > w;
    }

    public boolean getScrollableTracksViewportHeight() {
        JViewport vp = (JViewport)this.getParent();
        Dimension size = vp.getExtentSize();
        Composition composition = this.document.getComposition();
        int h = (int)(this.scale * (float)composition.getHeight());
        return size.height > h;
    }
}

