/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.layer;

import com.jhlabs.composite.MiscComposite;
import com.jhlabs.util.Memento;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import javax.swing.Icon;

public abstract class Layer {
    protected String name;
    protected int x;
    protected int y;
    protected BufferedImage image;
    protected int operation = 0;
    protected int opacity = 255;
    protected boolean locked = false;
    protected boolean visible = true;
    protected AffineTransform transform;

    protected Layer() {
    }

    protected Layer(BufferedImage image) {
        this.image = image;
    }

    protected Layer(String name, BufferedImage image) {
        this.name = name;
        this.image = image;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public boolean isPaintable() {
        return false;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.image = new BufferedImage(width, height, 2);
        this.setLocation(x, y);
    }

    public Rectangle getBounds() {
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        return new Rectangle(this.x, this.y, w, h);
    }

    public void setSize(int width, int height) {
        this.image = new BufferedImage(width, height, 2);
    }

    public void resize(int width, int height, BufferedImageOp scaleFilter) {
        this.setSize(width, height);
    }

    public Dimension getSize() {
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    public void crop(Rectangle r) {
        BufferedImage im = this.image;
        this.setSize(r.width, r.height);
        Graphics2D g = this.image.createGraphics();
        g.drawImage(im, null, -r.x, -r.y);
        g.dispose();
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public final void setX(int x) {
        this.x = x;
    }

    public final void setY(int y) {
        this.y = y;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public Composite getComposite() {
        return MiscComposite.getInstance(this.operation, (float)this.opacity / 255.0f);
    }

    public int getNumChildren() {
        return 0;
    }

    public Layer getChild(int index) {
        return null;
    }

    public Layer simplify() {
        return this;
    }

    public Graphics2D getGraphics() {
        return null;
    }

    public Memento getLayerContentsMemento() {
        return null;
    }

    public String toString() {
        return "Layer[name=\"" + this.getName() + ", x=" + this.x + ", y=" + this.y + ", w=" + this.getWidth() + ", h=" + this.getHeight() + "]";
    }

    public Icon getIcon() {
        return null;
    }
}

