/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.composite.MiscComposite;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.DrawingTask;
import com.jhlabs.ie.ImageTool;
import com.jhlabs.image.PaintingContext;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;

public abstract class DrawShapeTool
extends ImageTool {
    public abstract Shape makeShape();

    public void doDrag(boolean erase) {
        AffineTransform t = this.view.getViewTransform();
        this.graphics.draw(t.createTransformedShape(this.makeShape()));
    }

    public void doEndDrag() {
        this.view.doTask(new DrawShapeTask(this.view.getComposition(), this.makeShape(), this.event.isShiftDown()));
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new DrawShapeToolCustomizer();
    }

    class DrawShapeToolCustomizer
    extends ImageTool.DrawingToolCustomizer
    implements ActionListener {
        private JComboBox drawChoice = new JComboBox();

        public DrawShapeToolCustomizer() {
            this.drawChoice.addItem(this.getIcon("paint_stroke.png"));
            this.drawChoice.addItem(this.getIcon("paint_fill.png"));
            this.drawChoice.addItem(this.getIcon("paint_both.png"));
            this.drawChoice.addItem(this.getIcon("paint_select.png"));
            this.drawChoice.addItem(this.getIcon("paint_add_select.png"));
            this.drawChoice.addItem(this.getIcon("paint_subtract_select.png"));
            this.drawChoice.addActionListener(this);
            this.add(this.drawChoice);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.drawChoice) {
                DrawShapeTool.this.getPaintingContext().setPaintingMode(this.drawChoice.getSelectedIndex());
            } else {
                super.actionPerformed(e);
            }
        }

        private Icon getIcon(String name) {
            return new ImageIcon(this.getClass().getResource(name));
        }
    }

    class DrawShapeTask
    extends DrawingTask {
        private Shape shape;
        private boolean fill;

        public DrawShapeTask(Composition composition, Shape shape, boolean fill) {
            super(composition);
            this.shape = shape;
            this.fill = fill;
        }

        public void doTask(Rectangle r, Composite composite) {
            PaintingContext context = PaintingContext.getInstance();
            int mode = context.getPaintingMode();
            switch (mode) {
                case 3: 
                case 4: 
                case 5: {
                    boolean clear = mode == 3;
                    BufferedImage selection = DrawShapeTool.this.view.getSelection();
                    CompositionDocument document = DrawShapeTool.this.view.getDocument();
                    Composition composition = document.getComposition();
                    Rectangle bounds = composition.getSelectedBounds();
                    if (clear) {
                        composition.selectNone();
                    }
                    Graphics2D g = selection.createGraphics();
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    if (mode == 5) {
                        g.setComposite(AlphaComposite.getInstance(1));
                    } else {
                        g.setColor(new Color(-16777216));
                        g.setComposite(AlphaComposite.getInstance(2));
                    }
                    this.doDrawing(g);
                    g.dispose();
                    if (clear && bounds != null) {
                        r = r.union(bounds);
                    }
                    composition.startUpdate();
                    composition.updateSelection(r);
                    composition.endUpdate(false);
                    break;
                }
                default: {
                    super.doTask(r, composite);
                }
            }
        }

        public void doDrawing(Graphics2D g) {
            PaintingContext context = PaintingContext.getInstance();
            g.setStroke(context.getStroke());
            if (this.fill) {
                g.setColor(new Color(context.getFgColor()));
                g.fill(this.shape);
            } else {
                int mode = context.getPaintingMode();
                switch (mode) {
                    case 0: {
                        g.setColor(new Color(context.getFgColor()));
                        g.draw(this.shape);
                        break;
                    }
                    case 1: {
                        g.setColor(new Color(context.getFgColor()));
                        g.fill(this.shape);
                        break;
                    }
                    case 2: {
                        g.setColor(new Color(context.getBgColor()));
                        g.fill(this.shape);
                        g.setColor(new Color(context.getFgColor()));
                        g.draw(this.shape);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        g.fill(this.shape);
                    }
                }
            }
        }

        public void doTask() {
            Stroke stroke = DrawShapeTool.this.getPaintingContext().getStroke();
            Rectangle b = stroke.createStrokedShape(this.shape).getBounds();
            this.doTask(new Rectangle((int)b.getMinX(), (int)b.getMinY(), (int)(((RectangularShape)b).getWidth() + 0.5), (int)(((RectangularShape)b).getHeight() + 0.5)), MiscComposite.getInstance(DrawShapeTool.this.getComposite(), 1.0f));
        }
    }
}

