/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.ImageUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class ColormapIcon
implements Icon {
    private Colormap colormap;
    private Image image;
    private int width;
    private int height;
    private boolean newImage = true;
    private MemoryImageSource source;

    public ColormapIcon(Colormap colormap) {
        this(colormap, 128, 12);
    }

    public ColormapIcon(Colormap colormap, int width, int height) {
        this.colormap = colormap;
        this.width = width;
        this.height = height;
    }

    public void rebuild() {
        this.newImage = true;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
        this.newImage = true;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void paintIcon(Component component, Graphics g, int x, int y) {
        if (this.colormap != null) {
            if (this.newImage || this.image == null) {
                this.image = this.makeImage(component, this.width);
            }
            int w = component.getSize().width;
            int h = component.getSize().height;
            if (component instanceof Container) {
                Insets insets = ((Container)component).getInsets();
                w -= insets.left + insets.right;
                h -= insets.top + insets.bottom;
            }
            ImageUtils.paintCheckedBackground(component, g, x, y, w, h);
            g.drawImage(this.image, x, y, w, h, SwingUtilities.getRoot(component));
        }
    }

    public Image getImage() {
        return this.image;
    }

    private Image makeImage(Component component, int w) {
        int[] pixels = new int[w];
        for (int x = 0; x < w; ++x) {
            pixels[x] = this.colormap.getColor((float)x / (float)w);
        }
        this.newImage = false;
        if (this.image == null) {
            this.source = new MemoryImageSource(w, 1, ColorModel.getRGBdefault(), pixels, 0, w);
            this.image = component.createImage(this.source);
            this.source.setAnimated(true);
        } else {
            this.source.newPixels(pixels, ColorModel.getRGBdefault(), 0, w);
        }
        return this.image;
    }
}

