/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ArrayColormap;
import com.jhlabs.image.Gradient;
import com.jhlabs.image.LinearColormap;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class GradientHandler
implements DocumentHandler {
    private Vector colormaps = new Vector();
    private Gradient gradient;
    private LinearColormap linearColormap;
    private ArrayColormap arrayColormap;
    private int arrayIndex = 0;
    private int[] xKnots = new int[256];
    private int[] yKnots = new int[256];
    private byte[] knotTypes = new byte[256];
    private int numKnots = 0;
    private static String[] blends = new String[]{"", "linear", "spline", "circle-up", "circle-down", "constant"};
    private static String[] types = new String[]{"rgb", "hue-cw", "hue-ccw"};

    public Vector getColormaps() {
        return this.colormaps;
    }

    public void setDocumentLocator(Locator l) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String tag, AttributeList attrs) throws SAXException {
        if (!tag.equals("colormaps")) {
            if (tag.equals("gradient-colormap")) {
                this.gradient = new Gradient();
                this.numKnots = 0;
                this.xKnots[this.numKnots] = -1;
                this.yKnots[this.numKnots] = 0xFF00000;
                this.knotTypes[this.numKnots] = 0;
                ++this.numKnots;
                this.colormaps.addElement(this.gradient);
            } else if (tag.equals("linear-colormap")) {
                int rgb1 = this.getIntValue(attrs, "rgb1", 0);
                int rgb2 = this.getIntValue(attrs, "rgb2", 0);
                this.colormaps.addElement(new LinearColormap(rgb1, rgb2));
            } else if (tag.equals("colormap")) {
                this.arrayIndex = 0;
                this.arrayColormap = new ArrayColormap();
                this.colormaps.addElement(this.arrayColormap);
            } else if (tag.equals("knot")) {
                int type = this.getListValue(attrs, "type", types, 0);
                int blend = this.getListValue(attrs, "blend", blends, 16);
                int x = this.getIntValue(attrs, "x", 0);
                int rgb = this.getIntValue(attrs, "rgb", 0);
                this.xKnots[this.numKnots] = x;
                this.yKnots[this.numKnots] = rgb;
                this.knotTypes[this.numKnots] = (byte)(blend << 4 | type);
                ++this.numKnots;
            } else if (tag.equals("color-range")) {
                int rgb1 = this.getIntValue(attrs, "rgb1", 0);
                int rgb2 = this.getIntValue(attrs, "rgb2", 0);
                int x1 = this.getIntValue(attrs, "x1", 0);
                int x2 = this.getIntValue(attrs, "x2", 255);
                this.arrayColormap.setColorRange(x1, x2, rgb1, rgb2);
                this.arrayIndex = x2 + 1;
            } else if (tag.equals("color")) {
                this.arrayColormap.setColor(this.getIntValue(attrs, "rgb", 0), this.arrayIndex++);
            }
        }
    }

    public void endElement(String tag) throws SAXException {
        if (tag.equals("gradient-colormap")) {
            this.xKnots[this.numKnots] = 256;
            this.yKnots[this.numKnots] = 0xFFFFFFF;
            this.knotTypes[this.numKnots] = 0;
            ++this.numKnots;
            this.gradient.setKnots(this.xKnots, this.yKnots, this.knotTypes, 0, this.numKnots);
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
    }

    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    private String getStringValue(AttributeList attrs, String name, String defaultValue) {
        if (attrs != null && (name = attrs.getValue(name)) != null) {
            return name;
        }
        return defaultValue;
    }

    private int getListValue(AttributeList attrs, String name, String[] list, int defaultValue) {
        if (attrs != null && (name = attrs.getValue(name)) != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!name.equals(list[i])) continue;
                return i;
            }
        }
        return defaultValue;
    }

    private int getIntValue(AttributeList attrs, String name, int defaultValue) {
        if (attrs != null && (name = attrs.getValue(name)) != null) {
            try {
                return GradientHandler.parseInt(name, defaultValue);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int parseInt(String s, int defaultValue) throws NumberFormatException {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (s.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (s.startsWith("0x", index) || s.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (s.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (s.startsWith("0", index) && s.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        try {
            int result = GradientHandler.parseInt2(s.substring(index), radix);
            return negative ? -result : result;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static int parseInt2(String s, int radix) throws NumberFormatException {
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max > 0) {
            int digit;
            int limit;
            if (s.charAt(0) == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException(s);
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException(s);
                }
                result *= radix;
                result -= digit;
            }
        } else {
            throw new NumberFormatException(s);
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(s);
        }
        return -result;
    }
}

