/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.crw;

import it.tidalwave.imageio.raw.AbstractTag;
import it.tidalwave.imageio.raw.TagRegistry;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.imageio.stream.ImageInputStream;

public class CIFFTag
extends AbstractTag {
    private static final long serialVersionUID = -7884292603248658254L;
    private int dataLocation;
    private int baseOffset;
    private int offset;
    private int size;
    private static final int TYPE_SHIFT_COUNT = 11;
    private static final int CODE_MASK = 16383;
    private static final int TYPE_MASK = 14336;
    private static final int DATA_LOCATION_MASK = 49152;
    private static final int TYPE_BYTE = 0;
    private static final int TYPE_ASCII = 2048;
    private static final int TYPE_SHORT = 4096;
    private static final int TYPE_LONG = 6144;
    private static final int TYPE_MIX = 8192;
    private static final int TYPE_SUBDIR1 = 10240;
    private static final int TYPE_SUBDIR2 = 12288;
    private static final int TYPE_UNKNOWN = 14336;
    private static final String[] typeToString = new String[8];

    public CIFFTag(TagRegistry registry, int code, int baseOffset) {
        super(registry, code);
        this.baseOffset = baseOffset;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public boolean isSubDirectory() {
        return this.type == 10240 || this.type == 12288;
    }

    public void read(ImageInputStream iis) throws IOException {
        block15: {
            block14: {
                int savePos = (int)iis.getStreamPosition();
                this.size = iis.readInt();
                this.offset = iis.readInt();
                this.dataLocation = this.code & 0xC000;
                this.type = this.code & 0x3800;
                this.code &= 0x3FFF;
                if (this.dataLocation != 16384) break block14;
                this.offset = 0;
                this.size = 0;
                switch (this.type) {
                    case 0: {
                        this.intValue = this.readByteValues(iis, savePos, 8);
                        this.valuesCount = this.intValue.length;
                        this.undefinedValue = new byte[this.intValue.length];
                        for (int i = 0; i < this.undefinedValue.length; ++i) {
                            this.undefinedValue[i] = (byte)this.intValue[i];
                        }
                        break block15;
                    }
                    case 4096: {
                        this.intValue = this.readShortValues(iis, savePos, 4);
                        this.valuesCount = this.intValue.length;
                        break;
                    }
                    case 6144: {
                        this.intValue = this.readIntValues(iis, savePos, 2);
                        this.valuesCount = this.intValue.length;
                    }
                }
                break block15;
            }
            switch (this.type) {
                case 0: {
                    this.intValue = this.readByteValues(iis, this.offset + this.baseOffset, this.size);
                    this.valuesCount = this.intValue.length;
                    this.undefinedValue = new byte[this.intValue.length];
                    for (int i = 0; i < this.undefinedValue.length; ++i) {
                        this.undefinedValue[i] = (byte)this.intValue[i];
                    }
                    break;
                }
                case 4096: {
                    this.intValue = this.readShortValues(iis, this.offset + this.baseOffset, this.size / 2);
                    this.valuesCount = this.intValue.length;
                    break;
                }
                case 6144: {
                    this.intValue = this.readIntValues(iis, this.offset + this.baseOffset, this.size / 4);
                    this.valuesCount = this.intValue.length;
                    this.floatValue = new float[this.valuesCount];
                    for (int i = 0; i < this.valuesCount; ++i) {
                        this.floatValue[i] = Float.intBitsToFloat(this.intValue[i]);
                    }
                    break;
                }
                case 2048: {
                    this.asciiValue = this.readASCIIValue(iis, this.offset + this.baseOffset, this.size, this.code == 2058 ? 2 : 1);
                    this.valuesCount = 1;
                }
            }
        }
    }

    private String readASCIIValue(ImageInputStream iis, int valueOffset, int valueCount, int stringCount) throws IOException {
        char ch;
        StringBuffer buffer = new StringBuffer();
        boolean needReset = false;
        needReset = true;
        iis.mark();
        iis.seek(valueOffset);
        while (valueCount-- > 0 && ((ch = (char)iis.readByte()) != '\u0000' || --stringCount != 0)) {
            buffer.append(ch);
        }
        if (needReset) {
            iis.reset();
        } else {
            iis.skipBytes(4 - this.valuesCount);
        }
        return buffer.toString();
    }

    @Nonnull
    public String toString() {
        String name = this.registry.getTagName(this.code);
        if (name == null) {
            name = "#" + this.code;
        }
        StringBuilder buffer = new StringBuilder(name);
        buffer.append(" type: ");
        buffer.append(typeToString[this.type >>> 11]);
        if (this.valuesCount > 1) {
            buffer.append("[" + this.valuesCount + "]");
        }
        buffer.append(" ");
        if (this.type == 8192 || this.isSubDirectory()) {
            buffer.append(" offset: ");
            buffer.append(this.offset);
            buffer.append(" size: ");
            buffer.append(this.size);
            buffer.append(" dataLocation: ");
            buffer.append(this.dataLocation);
        } else {
            this.appendValues(buffer);
        }
        return buffer.toString();
    }

    static {
        CIFFTag.typeToString[0] = "byte";
        CIFFTag.typeToString[1] = "ascii";
        CIFFTag.typeToString[2] = "short";
        CIFFTag.typeToString[3] = "long";
        CIFFTag.typeToString[4] = "mix";
        CIFFTag.typeToString[5] = "subdirectory";
        CIFFTag.typeToString[6] = "subdirectory";
        CIFFTag.typeToString[7] = "unknown";
    }
}

