/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.mrw;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.minolta.MinoltaRawData;
import it.tidalwave.imageio.mrw.MRWHeaderProcessor;
import it.tidalwave.imageio.mrw.MinoltaMakerNote;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.tiff.ThumbnailLoader;
import java.awt.Dimension;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class MRWMetadata
extends TIFFMetadataSupport {
    private static final long serialVersionUID = 1795868418676854749L;

    public MRWMetadata(@Nonnull Directory primaryIFD, @Nonnull RAWImageInputStream iis, @Nonnull HeaderProcessor headerProcessor) {
        super(primaryIFD, iis, headerProcessor);
        MinoltaMakerNote minoltaMakerNote = this.getMinoltaMakerNote();
        if (minoltaMakerNote != null && minoltaMakerNote.isJpegThumbnailLengthAvailable() && minoltaMakerNote.isJpegThumbnailOffsetAvailable()) {
            MRWHeaderProcessor mrwhp = (MRWHeaderProcessor)headerProcessor;
            int offset = minoltaMakerNote.getJpegThumbnailOffset() + mrwhp.getBaseOffset();
            int length = minoltaMakerNote.getJpegThumbnailLength();
            this.thumbnailLoaders.add(new ThumbnailLoader(iis, offset, length){

                protected InputStream createInputStream(byte[] buffer) {
                    byte[] result = new byte[buffer.length + 2];
                    result[0] = -1;
                    result[1] = -40;
                    System.arraycopy(buffer, 0, result, 2, buffer.length);
                    return super.createInputStream(result);
                }
            });
        }
    }

    @CheckForNull
    public MinoltaMakerNote getMinoltaMakerNote() {
        return (MinoltaMakerNote)this.getMakerNote();
    }

    @CheckForNull
    public MinoltaRawData getMinoltaRawData() {
        return ((MRWHeaderProcessor)this.headerProcessor).getMinoltaRawData();
    }

    @Nonnull
    protected Dimension getImageSize() {
        return this.getMinoltaRawData().getPRD().getCcdSize();
    }

    protected boolean isRasterIFD(@Nonnull IFD ifd) {
        return ifd.isImageWidthAvailable();
    }

    protected boolean isThumbnailIFD(@Nonnull IFD ifd) {
        return ifd.isJPEGInterchangeFormatAvailable();
    }
}

