/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor;

import it.tidalwave.imageio.raw.RAWImageReadParam;
import it.tidalwave.imageio.raw.RAWMetadataSupport;
import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.rawprocessor.Curve;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import it.tidalwave.imageio.util.Lookup;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineArtifact {
    private static final String CLASS = PipelineArtifact.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final char[] CHARS = new char[]{'R', 'G', 'B', 'C', 'M', 'Y', 'W'};
    protected BufferedImage image;
    protected RAWMetadataSupport rawMetadata;
    private int[] cfaPattern;
    protected double[] coefficients = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private double blackLevel = 0.0;
    protected Curve curve;
    private int rotation;
    private final Lookup lookup;

    public PipelineArtifact(@Nonnull BufferedImage image, @Nonnull RAWMetadataSupport rawMetadata, @Nonnull RAWImageReadParam readParam) {
        this.image = image;
        this.rawMetadata = rawMetadata;
        this.lookup = Lookup.fixed(image, rawMetadata, readParam, readParam.lookup(Source.class));
        this.cfaPattern = this.computeCFAPattern();
    }

    public <T> T lookup(@Nonnull Class<T> type) throws Lookup.NotFoundException {
        return this.lookup.lookup(type);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public RAWMetadataSupport getRAWMetadata() {
        return this.rawMetadata;
    }

    public void setCurve(Curve curve) {
        this.curve = curve;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setBlackLevel(double blackLevel) {
        this.blackLevel = blackLevel;
    }

    public double getBlackLevel() {
        return this.blackLevel;
    }

    private double getCoefficient(int channel) {
        return this.coefficients[channel];
    }

    public double getRedCoefficient() {
        return this.getCoefficient(0);
    }

    public double getGreenCoefficient() {
        return this.getCoefficient(1);
    }

    public double getBlueCoefficient() {
        return this.getCoefficient(2);
    }

    public void multiplyRedCoefficient(double value) {
        this.multiplyRGBCoefficient(0, value);
    }

    public void multiplyGreenCoefficient(double value) {
        this.multiplyRGBCoefficient(1, value);
    }

    public void multiplyBlueCoefficient(double value) {
        this.multiplyRGBCoefficient(2, value);
    }

    private void multiplyRGBCoefficient(int channel, double value) {
        int n = channel;
        this.coefficients[n] = this.coefficients[n] * value;
        logger.finer("Coefficient[%d] = %f - has been multiplied by %f", channel, this.coefficients[channel], value);
    }

    public void multiplyCFACoefficient(int cfaIndex, double value) {
        int channel;
        int n = channel = this.cfaPattern[cfaIndex];
        this.coefficients[n] = this.coefficients[n] * value;
        logger.finer("Coefficient[%d] = %f - has been multiplied by %f", channel, this.coefficients[channel], value);
    }

    public int[] getCFAPattern() {
        return this.cfaPattern;
    }

    public String getCFAPatternAsString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.cfaPattern.length; ++i) {
            buffer.append(CHARS[this.cfaPattern[i]]);
        }
        return buffer.toString();
    }

    private int[] computeCFAPattern() {
        int i;
        byte[] cfaPattern;
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)this.rawMetadata;
        IFD rasterIFD = metadata.getRasterIFD();
        IFD exifIFD = metadata.getExifIFD();
        int[] result = new int[]{0, 1, 1, 2};
        if (exifIFD != null && exifIFD.isEXIFCFAPatternAvailable()) {
            cfaPattern = exifIFD.getEXIFCFAPattern();
            for (i = 0; i < result.length; ++i) {
                result[i] = cfaPattern[4 + i];
            }
        }
        if (rasterIFD != null && rasterIFD.isCFAPatternAvailable()) {
            cfaPattern = rasterIFD.getCFAPattern();
            for (i = 0; i < result.length; ++i) {
                result[i] = cfaPattern[i];
            }
        }
        return result;
    }
}

