/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.image.CSequenceToMemory;
import quicktime.app.image.DSequenceFromMemory;
import quicktime.app.image.FileFilter;
import quicktime.app.image.GraphicsImporterDrawer;
import quicktime.app.image.ImageDataSequence;
import quicktime.app.image.ImageSpec;
import quicktime.io.QTFile;
import quicktime.qd.PixMap;
import quicktime.qd.QDColor;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.image.CodecComponent;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.ImageSequenceDataSource;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.Media;
import quicktime.std.movies.media.MediaSample;
import quicktime.util.EncodedImage;
import quicktime.util.QTHandleRef;
import quicktime.util.QTPointerRef;
import quicktime.util.QTUtils;
import quicktime.util.RawEncodedImage;

public final class ImageUtil {
    private static final boolean debug = false;
    public static final int kHitTestRgnSrc = 1768776048;

    private ImageUtil() {
    }

    public static ImageDataSequence makeTransparent(ImageSpec imageSpec, QDColor qDColor) throws QTException {
        return ImageUtil.makeTransparent(imageSpec, qDColor, new QDGraphics(16, imageSpec.getDescription().getBounds()), null, null);
    }

    public static ImageDataSequence makeTransparent(ImageSpec imageSpec, QDColor qDColor, QDGraphics qDGraphics) throws QTException {
        return ImageUtil.makeTransparent(imageSpec, qDColor, qDGraphics, null, null);
    }

    public static ImageDataSequence makeTransparent(ImageSpec imageSpec, QDColor qDColor, QDGraphics qDGraphics, Region region) throws QTException {
        return ImageUtil.makeTransparent(imageSpec, qDColor, qDGraphics, region, null);
    }

    public static ImageDataSequence makeTransparent(ImageDataSequence imageDataSequence, QDColor qDColor, QDGraphics qDGraphics, Region[] regionArray) throws QTException {
        return ImageUtil.makeTransparent(imageDataSequence, qDColor, qDGraphics, null, regionArray);
    }

    private static ImageDataSequence makeTransparent(ImageSpec imageSpec, QDColor qDColor, QDGraphics qDGraphics, Region region, Region[] regionArray) throws QTException {
        QDRect qDRect = qDGraphics.getPortRect();
        PixMap pixMap = qDGraphics.getPixMap();
        int n = pixMap.getPixelSize();
        boolean bl = region != null || regionArray != null;
        DSequenceFromMemory dSequenceFromMemory = new DSequenceFromMemory(imageSpec);
        dSequenceFromMemory.setGWorld(qDGraphics);
        ImageDataSequence imageDataSequence = new ImageDataSequence();
        CSequenceToMemory cSequenceToMemory = new CSequenceToMemory(2);
        QDGraphics qDGraphics2 = null;
        QDGraphics qDGraphics3 = null;
        PixMap pixMap2 = null;
        ImageDescription imageDescription = null;
        ImageSequenceDataSource imageSequenceDataSource = null;
        if (bl) {
            qDGraphics2 = new QDGraphics(qDRect);
            qDGraphics3 = new QDGraphics(8, qDRect);
            pixMap2 = qDGraphics3.getPixMap();
            imageDescription = new ImageDescription(pixMap2);
            imageDescription.lock();
        }
        if (imageSpec instanceof ImageDataSequence) {
            ImageDataSequence imageDataSequence2 = (ImageDataSequence)imageSpec;
            for (int i = 1; i <= imageDataSequence2.size(); ++i) {
                if (bl) {
                    cSequenceToMemory.begin(qDGraphics2, qDRect, n, 1919706400, CodecComponent.anyCodec, 1024, 1024, 2, imageSpec.getDescription().getCTable(), 0);
                    imageSequenceDataSource = new ImageSequenceDataSource(cSequenceToMemory.getSequence(), 1768776048, 1, imageDescription);
                    imageSequenceDataSource.setSourceData(RawEncodedImage.fromPixMap(pixMap2));
                    qDGraphics2.setBackColor(qDColor);
                    qDGraphics2.eraseRect(null);
                    qDGraphics3.setBackColor(QDColor.white);
                    qDGraphics3.eraseRect(null);
                    qDGraphics3.setForeColor(QDColor.black);
                    qDGraphics3.paintRgn(region != null ? region : regionArray[i - 1]);
                    cSequenceToMemory.compressFrame(qDGraphics2, qDRect, 0);
                    cSequenceToMemory.getSequence().setPrev(qDGraphics2, null);
                    qDGraphics.setBackColor(qDColor);
                    qDGraphics.eraseRect(null);
                } else {
                    cSequenceToMemory.begin(qDGraphics, qDRect, n, 1919706400, CodecComponent.anyCodec, 1024, 1024, 2, imageSpec.getDescription().getCTable(), 0);
                    qDGraphics.setBackColor(qDColor);
                    qDGraphics.eraseRect(null);
                    cSequenceToMemory.compressFrame(qDGraphics, qDRect, 4);
                }
                dSequenceFromMemory.redraw(null);
                cSequenceToMemory.compressFrame(qDGraphics, qDRect, bl ? 0 : 4);
                if (i == 1) {
                    imageDataSequence.setDescription(cSequenceToMemory.getDescription());
                    imageDataSequence.getDescription().setFrameCount(imageDataSequence2.size());
                }
                imageDataSequence.append((EncodedImage)cSequenceToMemory.getFrames().elementAt(1));
                dSequenceFromMemory.setFrameNext();
                if (i % 3 != 0) continue;
                QTUtils.reclaimMemory();
            }
        } else {
            if (bl) {
                cSequenceToMemory.begin(qDGraphics2, qDRect, n, 1919706400, CodecComponent.anyCodec, 1024, 1024, 2, imageSpec.getDescription().getCTable(), 0);
                imageSequenceDataSource = new ImageSequenceDataSource(cSequenceToMemory.getSequence(), 1768776048, 1, imageDescription);
                imageSequenceDataSource.setSourceData(RawEncodedImage.fromPixMap(pixMap2));
                qDGraphics2.setBackColor(qDColor);
                qDGraphics2.eraseRect(null);
                qDGraphics3.setBackColor(QDColor.white);
                qDGraphics3.eraseRect(null);
                qDGraphics3.setForeColor(QDColor.black);
                qDGraphics3.paintRgn(region != null ? region : regionArray[0]);
                cSequenceToMemory.compressFrame(qDGraphics2, qDRect, 0);
                cSequenceToMemory.getSequence().setPrev(qDGraphics2, null);
                qDGraphics.setBackColor(qDColor);
                qDGraphics.eraseRect(null);
            } else {
                cSequenceToMemory.begin(qDGraphics, qDRect, n, 1919706400, CodecComponent.anyCodec, 1024, 1024, 2, imageSpec.getDescription().getCTable(), 0);
                qDGraphics.setBackColor(qDColor);
                qDGraphics.eraseRect(null);
                cSequenceToMemory.compressFrame(qDGraphics, qDRect, 4);
            }
            dSequenceFromMemory.redraw(null);
            cSequenceToMemory.compressFrame(qDGraphics, qDRect, bl ? 0 : 4);
            imageDataSequence.setDescription(cSequenceToMemory.getDescription());
            imageDataSequence.getDescription().setFrameCount(1);
            imageDataSequence.append((EncodedImage)cSequenceToMemory.getFrames().elementAt(1));
        }
        pixMap = null;
        qDGraphics = null;
        return imageDataSequence;
    }

    private static File checkDir(String string) throws IOException {
        File file;
        char c = string.charAt(string.length() - 1);
        if (c != '/') {
            string = string + "/";
        }
        if (!(file = new File(string)).isDirectory()) {
            throw new IOException(string);
        }
        return file;
    }

    public static ImageDataSequence createSequence(Track track) throws QTException {
        Media media = Media.getTrackMedia(track);
        int n = media.getSampleCount();
        int n2 = 0;
        ImageDataSequence imageDataSequence = new ImageDataSequence((ImageDescription)media.getSampleDescription(1));
        for (int i = 1; i <= n; ++i) {
            MediaSample mediaSample = media.getSample(0, n2, 1);
            if (mediaSample.descriptionIndex != 1) break;
            QTPointerRef qTPointerRef = ((QTHandleRef)mediaSample.data.clone()).toQTPointer();
            imageDataSequence.addMember(RawEncodedImage.fromQTPointer(qTPointerRef));
            n2 += mediaSample.duration;
            if (i % 5 != 0) continue;
            QTUtils.reclaimMemory();
        }
        QTUtils.reclaimMemory();
        return imageDataSequence;
    }

    public static ImageDataSequence createSequence(File file) throws IOException, QTException {
        return ImageUtil.createSequence(file, new FileFilter());
    }

    public static ImageDataSequence createSequence(File file, FileFilter fileFilter) throws IOException, QTException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        String string = file.getParent();
        if (string.charAt(string.length() - 1) != File.separatorChar) {
            string = string + File.separatorChar;
        }
        String string2 = file.getName();
        fileFilter.extractPrefixAndSuffix(string2);
        File file2 = new File(string);
        if (!file2.isDirectory()) {
            throw new IOException(string);
        }
        String[] stringArray = file2.list(fileFilter);
        if (fileFilter != null) {
            stringArray = fileFilter.postProcess(stringArray);
        }
        ImageDataSequence imageDataSequence = new ImageDataSequence();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            QTFile qTFile = null;
            qTFile = new QTFile(string + stringArray[i]);
            GraphicsImporterDrawer graphicsImporterDrawer = new GraphicsImporterDrawer(qTFile);
            if (i == 0 || imageDataSequence.isEmpty()) {
                imageDataSequence.setDescription(graphicsImporterDrawer.getDescription());
            }
            imageDataSequence.append(graphicsImporterDrawer.getImage());
            ++n;
        }
        if (imageDataSequence == null) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        imageDataSequence.getDescription().setFrameCount(n);
        return imageDataSequence;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

