/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.music;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.QTUtils;

public class NoteRequestInfo
extends QTByteObject
implements PrimitivesLib,
Cloneable {
    private static Object linkage;
    public static final int kNativeSize = 8;
    private static final long serialVersionUID = -8181311485902882832L;
    static /* synthetic */ Class class$quicktime$std$music$NoteRequestInfo;

    public NoteRequestInfo() {
        this(8, null);
    }

    public NoteRequestInfo(int n) throws QTException {
        this(8, null);
        this.setPolyphony(n);
    }

    NoteRequestInfo(byte[] byArray) {
        super(byArray);
    }

    NoteRequestInfo(int n, Object object) {
        super(n);
        this.setPolyphony(1);
        this.setTypicalPolyphony(1.0f);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        this.bytes = new byte[n];
        objectInputStream.read(this.bytes);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = this.getBytes();
        int n = this.getSize();
        objectOutputStream.writeInt(n);
        objectOutputStream.write(byArray);
    }

    public final int getFlags() {
        return this.getByteAt(0);
    }

    public final void setFlags(int n) {
        this.setByteAt(0, (byte)n);
    }

    public final int getMIDIChannel() {
        int n = this.getByteAt(1);
        if ((n & 0x80) == 0) {
            return 0;
        }
        if ((n &= 0x7F) > 16) {
            return 0;
        }
        return n;
    }

    public final void setMIDIChannel(int n) {
        this.setByteAt(1, (byte)(n |= 0x80));
    }

    public final int getPolyphony() {
        return EndianOrder.flipBigEndianToNative16(this.getShortAt(2));
    }

    public final void setPolyphony(int n) {
        this.setShortAt(2, EndianOrder.flipNativeToBigEndian16((short)n));
    }

    public final float getTypicalPolyphony() {
        return QTUtils.Fix2X(EndianOrder.flipBigEndianToNative32(this.getIntAt(4)));
    }

    public final void setTypicalPolyphony(float f) {
        this.setIntAt(4, EndianOrder.flipNativeToBigEndian32(QTUtils.X2Fix(f)));
    }

    public String toString() {
        return this.getClass().getName() + "[flags=" + this.getFlags() + ",poly=" + this.getPolyphony() + ",typPoly=" + this.getTypicalPolyphony() + "]";
    }

    public Object clone() {
        return new NoteRequestInfo(this.getBytes());
    }

    private static native short getShortFromArray(byte[] var0, int var1);

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native void setShortInArray(byte[] var0, int var1, short var2);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$music$NoteRequestInfo == null ? (class$quicktime$std$music$NoteRequestInfo = NoteRequestInfo.class$("quicktime.std.music.NoteRequestInfo")) : class$quicktime$std$music$NoteRequestInfo);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

