/*
 * Decompiled with CFR 0.152.
 */
package quicktime.streaming;

import quicktime.QTException;
import quicktime.util.QTPointerRef;
import quicktime.util.QTUtils;

public final class EditEntry
extends QTPointerRef {
    public static final int kNativeSize = 20;

    public EditEntry() throws QTException {
        super(20, true);
    }

    public EditEntry(long l, long l2, float f) throws QTException {
        this();
        this.setPresentationDuration(l);
        this.setStreamStartTime(l2);
        this.setStreamRate(f);
    }

    public long getPresentationDuration() {
        return this.getLongAt(0);
    }

    public long getStreamStartTime() {
        return this.getLongAt(8);
    }

    public float getStreamRate() {
        return QTUtils.Fix2X(this.getIntAt(16));
    }

    public void setPresentationDuration(long l) {
        this.setLongAt(0, l);
    }

    public void setStreamStartTime(long l) {
        this.setLongAt(8, l);
    }

    public void setStreamRate(float f) {
        this.setIntAt(16, QTUtils.X2Fix(f));
    }

    public String toString() {
        return this.getClass().getName() + "[duration=" + this.getPresentationDuration() + ",startTime=" + this.getStreamStartTime() + ",rate" + this.getStreamRate() + "]";
    }
}

