/*
 * Decompiled with CFR 0.152.
 */
package quicktime.vr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.util.QTUtils;
import quicktime.vr.QTVRAtom;

public final class QTVRNodeLocation
extends QTVRAtom {
    private static final int kNativeSize = 24;
    private static EndianDescriptor ed;
    static final long serialVersionUID = -2055560448381571608L;

    public QTVRNodeLocation() {
        super(24);
    }

    public QTVRNodeLocation(byte[] byArray) throws QTException {
        super(byArray, 24);
    }

    protected int getNativeSize() {
        return 24;
    }

    protected static EndianDescriptor makeED() {
        EndianDescriptor endianDescriptor = new EndianDescriptor(0);
        EndianFlipSpec endianFlipSpec = new EndianFlipSpec(0, 2, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec);
        EndianFlipSpec endianFlipSpec2 = new EndianFlipSpec(4, 4, 5);
        endianDescriptor.addFlipSpec(endianFlipSpec2);
        return endianDescriptor;
    }

    public static EndianDescriptor getEndianDescriptor() {
        if (ed == null) {
            ed = QTVRNodeLocation.makeED();
        }
        return ed;
    }

    protected void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[24];
        QTVRNodeLocation qTVRNodeLocation = new QTVRNodeLocation();
        objectInputStream.read(qTVRNodeLocation.getBytes());
        System.arraycopy(qTVRNodeLocation.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    protected void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        QTVRNodeLocation qTVRNodeLocation = (QTVRNodeLocation)this.clone();
        objectOutputStream.write(qTVRNodeLocation.getBytes());
    }

    public Object clone() {
        try {
            return new QTVRNodeLocation(this.bytes);
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException);
        }
    }

    public int getNodeType() {
        return this.getIntAt(4);
    }

    public void setNodeType(int n) {
        this.setIntAt(4, n);
    }

    public void setNodeType(String string) {
        this.setIntAt(4, QTUtils.toOSType(string));
    }

    public int getLocationFlags() {
        return this.getIntAt(8);
    }

    public void setLocationFlags(int n) {
        this.setIntAt(8, n);
    }

    public int getLocationData() {
        return this.getIntAt(12);
    }

    public void setLocationData(int n) {
        this.setIntAt(12, n);
    }

    public void setReserved1(int n) {
        this.setIntAt(16, n);
    }

    public int getReserved1() {
        return this.getIntAt(16);
    }

    public void setReserved2(int n) {
        this.setIntAt(20, n);
    }

    public int getReserved2() {
        return this.getIntAt(20);
    }

    public String toString() {
        return this.getClass().getName() + "[nodeType=" + QTUtils.fromOSType(this.getNodeType()) + ",locationFlags=" + this.getLocationFlags() + ",locationData=" + this.getLocationData() + "]";
    }
}

