/*
 * Decompiled with CFR 0.152.
 */
package quicktime.vr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.qd.QDPoint;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.util.QTUtils;
import quicktime.vr.QTVRAtom;

public final class QTVRPanoSample
extends QTVRAtom {
    private static final int kNativeSize = 84;
    static final int kQTVRPanoFlagHorizontal = 1;
    static final int kQTVRPanoFlagLast = Integer.MIN_VALUE;
    static final long serialVersionUID = -4451518596558727761L;
    private static EndianDescriptor ed;

    public QTVRPanoSample() {
        super(84);
    }

    public QTVRPanoSample(byte[] byArray) throws QTException {
        super(byArray, 84);
    }

    protected int getNativeSize() {
        return 84;
    }

    protected void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[84];
        QTVRPanoSample qTVRPanoSample = new QTVRPanoSample();
        objectInputStream.read(qTVRPanoSample.getBytes());
        System.arraycopy(qTVRPanoSample.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    protected void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        QTVRPanoSample qTVRPanoSample = (QTVRPanoSample)this.clone();
        objectOutputStream.write(qTVRPanoSample.getBytes());
    }

    public Object clone() {
        try {
            return new QTVRPanoSample(this.bytes);
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException);
        }
    }

    protected static EndianDescriptor makeED() {
        EndianDescriptor endianDescriptor = new EndianDescriptor(0);
        EndianFlipSpec endianFlipSpec = new EndianFlipSpec(0, 2, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec);
        EndianFlipSpec endianFlipSpec2 = new EndianFlipSpec(4, 4, 13);
        endianDescriptor.addFlipSpec(endianFlipSpec2);
        EndianFlipSpec endianFlipSpec3 = new EndianFlipSpec(56, 2, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec3);
        EndianFlipSpec endianFlipSpec4 = new EndianFlipSpec(60, 4, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec4);
        EndianFlipSpec endianFlipSpec5 = new EndianFlipSpec(68, 2, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec5);
        EndianFlipSpec endianFlipSpec6 = new EndianFlipSpec(72, 4, 3);
        endianDescriptor.addFlipSpec(endianFlipSpec6);
        return endianDescriptor;
    }

    public static EndianDescriptor getEndianDescriptor() {
        if (ed == null) {
            ed = QTVRPanoSample.makeED();
        }
        return ed;
    }

    public int getImageRefTrackIndex() {
        return this.getIntAt(4);
    }

    public void setImageRefTrackIndex(int n) {
        this.setIntAt(4, n);
    }

    public int getHotSpotRefTrackIndex() {
        return this.getIntAt(8);
    }

    public void setHotSpotRefTrackIndex(int n) {
        this.setIntAt(8, n);
    }

    public float getMinPan() {
        return this.getFloatAt(12);
    }

    public void setMinPan(float f) {
        this.setFloatAt(12, f);
    }

    public float getMaxPan() {
        return this.getFloatAt(16);
    }

    public void setMaxPan(float f) {
        this.setFloatAt(16, f);
    }

    public float getMinTilt() {
        return this.getFloatAt(20);
    }

    public void setMinTilt(float f) {
        this.setFloatAt(20, f);
    }

    public float getMaxTilt() {
        return this.getFloatAt(24);
    }

    public void setMaxTilt(float f) {
        this.setFloatAt(24, f);
    }

    public float getMinFieldOfView() {
        return this.getFloatAt(28);
    }

    public void setMinFieldOfView(float f) {
        this.setFloatAt(28, f);
    }

    public float getMaxFieldOfView() {
        return this.getFloatAt(32);
    }

    public void setMaxFieldOfView(float f) {
        this.setFloatAt(32, f);
    }

    public float getDefaultPan() {
        return this.getFloatAt(36);
    }

    public void setDefaultPan(float f) {
        this.setFloatAt(36, f);
    }

    public float getDefaultTilt() {
        return this.getFloatAt(40);
    }

    public void setDefaultTilt(float f) {
        this.setFloatAt(40, f);
    }

    public float getDefaultFieldOfView() {
        return this.getFloatAt(44);
    }

    public void setDefaultFieldOfView(float f) {
        this.setFloatAt(44, f);
    }

    public QDPoint getImageSize() {
        return new QDPoint(this.getIntAt(48), this.getIntAt(52));
    }

    public void setImageSize(QDPoint qDPoint) {
        this.setIntAt(48, qDPoint.getX());
        this.setIntAt(52, qDPoint.getY());
    }

    public QDPoint getNumFrames() {
        return new QDPoint(this.getShortAt(56), this.getShortAt(58));
    }

    public void setNumFrames(QDPoint qDPoint) {
        this.setShortAt(56, (short)qDPoint.getX());
        this.setShortAt(58, (short)qDPoint.getY());
    }

    public QDPoint getHotSpotSize() {
        return new QDPoint(this.getIntAt(60), this.getIntAt(64));
    }

    public void setHotSpotSize(QDPoint qDPoint) {
        this.setIntAt(60, qDPoint.getX());
        this.setIntAt(64, qDPoint.getY());
    }

    public QDPoint getHotSpotNumFrames() {
        return new QDPoint(this.getShortAt(68), this.getShortAt(70));
    }

    public void setHotSpotNumFrames(QDPoint qDPoint) {
        this.setShortAt(68, (short)qDPoint.getX());
        this.setShortAt(70, (short)qDPoint.getY());
    }

    public int getFlags() {
        return this.getIntAt(72);
    }

    public void setFlags(int n) {
        this.setIntAt(72, n);
    }

    public int getPanoType() {
        return this.getIntAt(76);
    }

    public void setPanoType(int n) {
        this.setIntAt(76, n);
    }

    public void setPanoType(String string) {
        this.setIntAt(76, QTUtils.toOSType(string));
    }

    public int getReserved2() {
        return this.getIntAt(80);
    }

    public void setReserved2(int n) {
        this.setIntAt(80, n);
    }

    public String toString() {
        return this.getClass().getName() + "[imageRefTrackIndex=" + this.getImageRefTrackIndex() + ",hotSpotRefTrackIndex=" + this.getHotSpotRefTrackIndex() + ",minPan=" + this.getMinPan() + ",maxPan=" + this.getMaxPan() + ",minTilt=" + this.getMinTilt() + ",maxTilt=" + this.getMaxTilt() + ",minFieldOfView=" + this.getMinFieldOfView() + ",maxFieldOfView=" + this.getMaxFieldOfView() + ",defaultPan=" + this.getDefaultPan() + ",defaultTilt=" + this.getDefaultTilt() + ",defaultFieldOfView=" + this.getDefaultFieldOfView() + ",imageSize=" + this.getImageSize() + ",imageNumFrames=" + this.getNumFrames() + ",hotSpotSize=" + this.getHotSpotSize() + ",hotSpotNumFrames=" + this.getHotSpotNumFrames() + ",flags=" + this.getFlags() + ",panoType=" + this.getPanoType() + ",reserved2=" + this.getReserved2() + "]";
    }
}

