/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;

public class ScaleCopy
extends ImageFilterPlus {
    private double xScale;
    private double yScale;
    private int newWidth;
    private int newHeight;

    public ScaleCopy(ImageProducer imageProducer, double d) {
        this(imageProducer, d, d);
    }

    public ScaleCopy(ImageProducer imageProducer, double d, double d2) {
        super(imageProducer);
        this.xScale = d;
        this.yScale = d2;
    }

    public static void main(String[] stringArray) {
        ScaleCopy scaleCopy = null;
        if (stringArray.length == 1) {
            scaleCopy = new ScaleCopy(null, Double.valueOf(stringArray[0]));
        } else if (stringArray.length == 2) {
            scaleCopy = new ScaleCopy(null, Double.valueOf(stringArray[0]), Double.valueOf(stringArray[1]));
        } else {
            ScaleCopy.usage();
        }
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, scaleCopy));
    }

    public void setDimensions(int n, int n2) {
        this.newWidth = (int)((double)n * this.xScale);
        this.newHeight = (int)((double)n2 * this.yScale);
        this.consumer.setDimensions(this.newWidth, this.newHeight);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7;
        int n8 = Math.min((int)((double)n * this.xScale), this.newWidth - 1);
        int n9 = Math.min((int)((double)n2 * this.yScale), this.newHeight - 1);
        int n10 = Math.max((int)((double)n3 * this.xScale), 1);
        if (n8 + n10 > this.newWidth) {
            n10 = this.newWidth - n8;
        }
        if (n9 + (n7 = Math.max((int)((double)n4 * this.yScale), 1)) > this.newHeight) {
            n7 = this.newHeight - n9;
        }
        byte[] byArray2 = new byte[n10 * n7];
        int n11 = 0;
        while (n11 < n7) {
            int n12 = (int)((double)n11 / this.yScale);
            if (n12 < n4) {
                int n13 = 0;
                while (n13 < n10) {
                    int n14 = (int)((double)n13 / this.xScale);
                    if (n14 < n3) {
                        byArray2[n11 * n10 + n13] = byArray[n12 * n6 + n5 + n14];
                    }
                    ++n13;
                }
            }
            ++n11;
        }
        this.consumer.setPixels(n8, n9, n10, n7, colorModel, byArray2, 0, n10);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7;
        int n8 = Math.min((int)((double)n * this.xScale), this.newWidth - 1);
        int n9 = Math.min((int)((double)n2 * this.yScale), this.newHeight - 1);
        int n10 = Math.max((int)((double)n3 * this.xScale), 1);
        if (n8 + n10 > this.newWidth) {
            n10 = this.newWidth - n8;
        }
        if (n9 + (n7 = Math.max((int)((double)n4 * this.yScale), 1)) > this.newHeight) {
            n7 = this.newHeight - n9;
        }
        int[] nArray2 = new int[n10 * n7];
        int n11 = 0;
        while (n11 < n7) {
            int n12 = (int)((double)n11 / this.yScale);
            if (n12 < n4) {
                int n13 = 0;
                while (n13 < n10) {
                    int n14 = (int)((double)n13 / this.xScale);
                    if (n14 < n3) {
                        nArray2[n11 * n10 + n13] = nArray[n12 * n6 + n5 + n14];
                    }
                    ++n13;
                }
            }
            ++n11;
        }
        this.consumer.setPixels(n8, n9, n10, n7, colorModel, nArray2, 0, n10);
    }

    private static void usage() {
        System.err.println("usage: ScaleCopy scale");
        System.err.println("or:    ScaleCopy xScale yScale");
        System.exit(1);
    }
}

