/*
 * Decompiled with CFR 0.152.
 */
package com.bric.awt;

import com.bric.geom.PathSegment;
import com.bric.geom.PathWriter;
import com.bric.geom.SimplifiedPathIterator;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class CalligraphyStroke
implements Stroke {
    public final float width;
    public final float theta;

    public CalligraphyStroke(float f) {
        this(f, 2.3561945f);
    }

    public CalligraphyStroke(float f, float f2) {
        this.width = f;
        this.theta = f2;
    }

    public float getWidth() {
        return this.width;
    }

    public float getTheta() {
        return this.theta;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        GeneralPath generalPath = new GeneralPath(1);
        PathIterator pathIterator = shape.getPathIterator(null);
        pathIterator = new SimplifiedPathIterator(pathIterator);
        PathSegment.Float float_ = null;
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl = pathIterator.isDone();
        boolean bl2 = false;
        while (!bl) {
            int n;
            if (!pathIterator.isDone()) {
                n = pathIterator.currentSegment(fArray);
                if (n == 4 && ((double)Math.abs(f - f3) > 0.01 || (double)Math.abs(f2 - f4) > 0.01)) {
                    float_ = float_.lineTo(f3, f4);
                }
                bl2 = n == 4 || n == 0;
            } else {
                n = 0;
                bl2 = true;
                bl = true;
            }
            if (bl2 && float_ != null) {
                this.createStrokedShape(generalPath, (Segment)float_);
                float_ = null;
            }
            if (n == 0) {
                f3 = fArray[0];
                f4 = fArray[1];
                f = fArray[0];
                f2 = fArray[1];
                float_ = new Segment(f3, f4);
            } else if (n == 1) {
                float_ = float_.lineTo(fArray[0], fArray[1]);
                f = fArray[0];
                f2 = fArray[1];
            } else if (n == 2) {
                float_ = float_.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                f = fArray[2];
                f2 = fArray[3];
            } else if (n == 3) {
                float_ = float_.cubicTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                f = fArray[4];
                f2 = fArray[5];
            }
            if (bl) continue;
            pathIterator.next();
        }
        return generalPath;
    }

    private void createStrokedShape(GeneralPath generalPath, Segment segment) {
        CalligraphyPathWriter calligraphyPathWriter = new CalligraphyPathWriter(generalPath);
        boolean bl = true;
        Segment segment2 = (Segment)segment.getHead();
        while (segment2 != null) {
            bl = segment2.write(calligraphyPathWriter, this.width / 2.0f, bl, true);
            segment2 = (Segment)segment2.next;
        }
        bl = !bl;
        segment2 = (Segment)segment.getTail();
        while (segment2 != null) {
            bl = segment2.write(calligraphyPathWriter, this.width / 2.0f, bl, false);
            segment2 = (Segment)segment2.prev;
        }
    }

    private static class CalligraphyPathWriter
    extends PathWriter {
        GeneralPath path;
        boolean moved = false;
        float lastX = 0.0f;
        float lastY = 0.0f;

        public CalligraphyPathWriter(GeneralPath generalPath) {
            this.path = generalPath;
        }

        @Override
        public void closePath() {
            this.path.closePath();
            this.moved = false;
        }

        @Override
        public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
            if (!this.moved) {
                throw new RuntimeException();
            }
            this.path.curveTo(f, f2, f3, f4, f5, f6);
            this.lastX = f5;
            this.lastY = f6;
        }

        @Override
        public void lineTo(float f, float f2) {
            if (!this.moved) {
                this.moveTo(f, f2);
            } else {
                if ((double)Math.abs(f - this.lastX) < 0.01 && (double)Math.abs(f2 - this.lastY) < 0.01) {
                    return;
                }
                this.path.lineTo(f, f2);
                this.lastX = f;
                this.lastY = f2;
            }
        }

        @Override
        public void quadTo(float f, float f2, float f3, float f4) {
            if (this.moved) {
                this.path.quadTo(f, f2, f3, f4);
                this.lastX = f3;
                this.lastY = f4;
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void moveTo(float f, float f2) {
            this.moved = true;
            this.path.moveTo(f, f2);
        }
    }

    private class Segment
    extends PathSegment.Float {
        float[] tangentTimes;

        public Segment(float f, float f2) {
            super(f, f2);
        }

        private Segment() {
        }

        @Override
        protected PathSegment.Float newSegment() {
            return new Segment();
        }

        @Override
        public PathSegment.Float cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
            Segment segment = (Segment)super.cubicTo(f, f2, f3, f4, f5, f6);
            segment.rotate(-CalligraphyStroke.this.theta);
            segment.prev.rotate(-CalligraphyStroke.this.theta);
            float[] fArray = segment.getYCoeffs();
            float f7 = 4.0f * fArray[1] * fArray[1] - 12.0f * fArray[0] * fArray[2];
            if (f7 >= 0.0f) {
                float f8 = -1.0f;
                float f9 = -1.0f;
                if ((f7 = (float)Math.sqrt(f7)) == 0.0f) {
                    f8 = -2.0f * fArray[1] / (6.0f * fArray[0]);
                } else {
                    f8 = (-2.0f * fArray[1] + f7) / (6.0f * fArray[0]);
                    f9 = (-2.0f * fArray[1] - f7) / (6.0f * fArray[0]);
                }
                if (!segment.isThetaWellDefined(f8)) {
                    f8 = -1.0f;
                }
                if (!segment.isThetaWellDefined(f9)) {
                    f9 = -1.0f;
                }
                if (f9 < f8) {
                    float f10 = f8;
                    f8 = f9;
                    f9 = f10;
                }
                if (f8 >= 0.0f && f9 <= 1.0f) {
                    segment.tangentTimes = new float[]{f8, f9};
                } else if (f8 >= 0.0f && f8 <= 1.0f) {
                    segment.tangentTimes = new float[]{f8};
                } else if (f9 >= 0.0f && f9 <= 1.0f) {
                    segment.tangentTimes = new float[]{f9};
                }
            }
            segment.rotate(CalligraphyStroke.this.theta);
            segment.prev.rotate(CalligraphyStroke.this.theta);
            return segment;
        }

        @Override
        public PathSegment.Float quadTo(float f, float f2, float f3, float f4) {
            Segment segment = (Segment)super.quadTo(f, f2, f3, f4);
            segment.rotate(-CalligraphyStroke.this.theta);
            segment.prev.rotate(-CalligraphyStroke.this.theta);
            float[] fArray = segment.getYCoeffs();
            float f5 = -fArray[1] / (2.0f * fArray[0]);
            if (f5 >= 0.0f && f5 <= 1.0f) {
                segment.tangentTimes = new float[]{f5};
            }
            segment.rotate(CalligraphyStroke.this.theta);
            segment.prev.rotate(CalligraphyStroke.this.theta);
            return segment;
        }

        @Override
        public String toString() {
            return "Segment[ path=" + this.getPath(null) + ", t=" + Segment.toString(this.tangentTimes) + "]";
        }

        public boolean write(CalligraphyPathWriter calligraphyPathWriter, float f, boolean bl, boolean bl2) {
            double d;
            double d2;
            float f2;
            float f3;
            if (this.type == 0) {
                return bl;
            }
            if (this.prev != null && this.prev.type != 0 && bl2) {
                f3 = this.prev.getTheta(1.0f, -1);
                f2 = this.getTheta(0.0f, 1);
                d2 = Math.sin(f3 - CalligraphyStroke.this.theta);
                if (d2 * (d = Math.sin(f2 - CalligraphyStroke.this.theta)) < 0.0) {
                    bl = !bl;
                }
            } else if (this.next != null && !bl2) {
                f3 = this.next.getTheta(0.0f, 1);
                f2 = this.getTheta(1.0f, -1);
                d2 = Math.sin(f3 - CalligraphyStroke.this.theta);
                if (d2 * (d = Math.sin(f2 - CalligraphyStroke.this.theta)) < 0.0) {
                    bl = !bl;
                }
            }
            f3 = (float)((double)f * Math.cos(CalligraphyStroke.this.theta));
            f2 = (float)((double)f * Math.sin(CalligraphyStroke.this.theta));
            if (!bl) {
                f3 = -f3;
                f2 = -f2;
            }
            float f4 = this.prev.data[this.prev.data.length - 2];
            float f5 = this.prev.data[this.prev.data.length - 1];
            if (this.type == 1) {
                float f6 = f4;
                float f7 = f5;
                float f8 = this.data[0];
                float f9 = this.data[1];
                if (bl2) {
                    calligraphyPathWriter.lineTo(f6 + f3, f7 + f2);
                    calligraphyPathWriter.lineTo(f8 + f3, f9 + f2);
                } else {
                    calligraphyPathWriter.lineTo(f8 + f3, f9 + f2);
                    calligraphyPathWriter.lineTo(f6 + f3, f7 + f2);
                }
            } else if (this.type == 2) {
                if (this.tangentTimes == null) {
                    if (bl2) {
                        calligraphyPathWriter.lineTo(f4 + f3, f5 + f2);
                        calligraphyPathWriter.quadTo(this.data[0] + f3, this.data[1] + f2, this.data[2] + f3, this.data[3] + f2);
                    } else {
                        calligraphyPathWriter.lineTo(this.data[2] + f3, this.data[3] + f2);
                        calligraphyPathWriter.quadTo(this.data[0] + f3, this.data[1] + f2, f4 + f3, f5 + f2);
                    }
                } else {
                    float f10;
                    float f11;
                    float[] fArray = this.getXCoeffs();
                    float[] fArray2 = this.getYCoeffs();
                    if (bl2) {
                        f11 = 0.0f;
                        f10 = 1.0f;
                    } else {
                        f11 = 1.0f;
                        f10 = 0.0f;
                    }
                    calligraphyPathWriter.lineTo((fArray[0] * f11 + fArray[1]) * f11 + fArray[2] + f3, (fArray2[0] * f11 + fArray2[1]) * f11 + fArray2[2] + f2);
                    float f12 = this.tangentTimes[0];
                    PathWriter.quadTo(calligraphyPathWriter, (double)f11, (double)f12, (double)fArray[0], (double)fArray[1], (double)(fArray[2] + f3), (double)fArray2[0], (double)fArray2[1], (double)(fArray2[2] + f2));
                    bl = !bl;
                    f3 = -f3;
                    f2 = -f2;
                    calligraphyPathWriter.lineTo(((fArray[0] * f12 + fArray[1]) * f12 + fArray[2]) * f12 + f3, ((fArray2[0] * f12 + fArray2[1]) * f12 + fArray2[2]) * f12 + f2);
                    PathWriter.quadTo(calligraphyPathWriter, (double)f12, (double)f10, (double)fArray[0], (double)fArray[1], (double)(fArray[2] + f3), (double)fArray2[0], (double)fArray2[1], (double)(fArray2[2] + f2));
                }
            } else if (this.type == 3) {
                if (this.tangentTimes == null) {
                    if (bl2) {
                        calligraphyPathWriter.lineTo(f4 + f3, f5 + f2);
                        calligraphyPathWriter.curveTo(this.data[0] + f3, this.data[1] + f2, this.data[2] + f3, this.data[3] + f2, this.data[4] + f3, this.data[5] + f2);
                    } else {
                        calligraphyPathWriter.lineTo(this.data[4] + f3, this.data[5] + f2);
                        calligraphyPathWriter.curveTo(this.data[2] + f3, this.data[3] + f2, this.data[0] + f3, this.data[1] + f2, f4 + f3, f5 + f2);
                    }
                } else {
                    float[] fArray = this.getXCoeffs();
                    float[] fArray3 = this.getYCoeffs();
                    float f13 = bl2 ? 0.0f : 1.0f;
                    float f14 = bl2 ? 1.0f : 0.0f;
                    calligraphyPathWriter.lineTo(((fArray[0] * f13 + fArray[1]) * f13 + fArray[2]) * f13 + fArray[3] + f3, ((fArray3[0] * f13 + fArray3[1]) * f13 + fArray3[2]) * f13 + fArray3[3] + f2);
                    float f15 = f13;
                    int n = bl2 ? 0 : this.tangentTimes.length - 1;
                    boolean bl3 = false;
                    while (!bl3) {
                        float f16 = this.tangentTimes[n];
                        PathWriter.cubicTo(calligraphyPathWriter, (double)f15, (double)f16, (double)fArray[0], (double)fArray[1], (double)fArray[2], (double)(fArray[3] + f3), (double)fArray3[0], (double)fArray3[1], (double)fArray3[2], (double)(fArray3[3] + f2));
                        bl = !bl;
                        f3 = -f3;
                        f2 = -f2;
                        calligraphyPathWriter.lineTo(((fArray[0] * f16 + fArray[1]) * f16 + fArray[2]) * f16 + fArray[3] + f3, ((fArray3[0] * f16 + fArray3[1]) * f16 + fArray3[2]) * f16 + fArray3[3] + f2);
                        f15 = f16;
                        n = bl2 ? ++n : --n;
                        bl3 = n < 0 || n >= this.tangentTimes.length;
                    }
                    PathWriter.cubicTo(calligraphyPathWriter, (double)f15, (double)f14, (double)fArray[0], (double)fArray[1], (double)fArray[2], (double)(fArray[3] + f3), (double)fArray3[0], (double)fArray3[1], (double)fArray3[2], (double)(fArray3[3] + f2));
                }
            }
            return bl;
        }
    }
}

