/*
 * Decompiled with CFR 0.152.
 */
package com.bric.geom;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public abstract class PathWriter {
    public abstract void moveTo(float var1, float var2);

    public abstract void lineTo(float var1, float var2);

    public abstract void quadTo(float var1, float var2, float var3, float var4);

    public abstract void curveTo(float var1, float var2, float var3, float var4, float var5, float var6);

    public abstract void closePath();

    public abstract void flush();

    public void write(Shape shape) {
        this.write(shape.getPathIterator(null));
    }

    public void write(PathIterator pathIterator) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (n == 0) {
                this.moveTo(fArray[0], fArray[1]);
            } else if (n == 1) {
                this.lineTo(fArray[0], fArray[1]);
            } else if (n == 2) {
                this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
            } else if (n == 3) {
                this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
            } else if (n == 4) {
                this.closePath();
            } else {
                throw new RuntimeException("Unexpected segment: " + n);
            }
            pathIterator.next();
        }
    }

    public static void cubicTo(GeneralPath generalPath, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        PathWriter.cubicTo2(generalPath, d, d2, d3, d4, d5, d6, d7, d8, d9, d10);
    }

    public static void cubicTo(PathWriter pathWriter, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        PathWriter.cubicTo2(pathWriter, d, d2, d3, d4, d5, d6, d7, d8, d9, d10);
    }

    private static void cubicTo2(Object object, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = 2.0 * d / 3.0 + d2 / 3.0;
        double d12 = d / 3.0 + 2.0 * d2 / 3.0;
        double d13 = d7 * d * d * d + d8 * d * d + d9 * d + d10;
        double d14 = d7 * d11 * d11 * d11 + d8 * d11 * d11 + d9 * d11 + d10;
        double d15 = d7 * d12 * d12 * d12 + d8 * d12 * d12 + d9 * d12 + d10;
        double d16 = d7 * d2 * d2 * d2 + d8 * d2 * d2 + d9 * d2 + d10;
        double d17 = d13;
        double d18 = (-11.0 * d13 + 18.0 * d14 - 9.0 * d15 + 2.0 * d16) / 2.0;
        double d19 = (-19.0 * d13 + 27.0 * d15 - 8.0 * d16 - 10.0 * d18) / 4.0;
        double d20 = d16 - d19 - d18 - d13;
        d13 = d3 * d * d * d + d4 * d * d + d5 * d + d6;
        d14 = d3 * d11 * d11 * d11 + d4 * d11 * d11 + d5 * d11 + d6;
        d15 = d3 * d12 * d12 * d12 + d4 * d12 * d12 + d5 * d12 + d6;
        d16 = d3 * d2 * d2 * d2 + d4 * d2 * d2 + d5 * d2 + d6;
        double d21 = d13;
        double d22 = (-11.0 * d13 + 18.0 * d14 - 9.0 * d15 + 2.0 * d16) / 2.0;
        double d23 = (-19.0 * d13 + 27.0 * d15 - 8.0 * d16 - 10.0 * d22) / 4.0;
        double d24 = d16 - d23 - d22 - d13;
        double d25 = (3.0 * d17 + d18) / 3.0;
        double d26 = (d19 - 3.0 * d17 + 6.0 * d25) / 3.0;
        double d27 = d20 + d17 - 3.0 * d25 + 3.0 * d26;
        double d28 = (3.0 * d21 + d22) / 3.0;
        double d29 = (d23 - 3.0 * d21 + 6.0 * d28) / 3.0;
        double d30 = d24 + d21 - 3.0 * d28 + 3.0 * d29;
        if (object instanceof GeneralPath) {
            ((GeneralPath)object).curveTo((float)d28, (float)d25, (float)d29, (float)d26, (float)d30, (float)d27);
        } else if (object instanceof PathWriter) {
            ((PathWriter)object).curveTo((float)d28, (float)d25, (float)d29, (float)d26, (float)d30, (float)d27);
        }
    }

    public static void quadTo(GeneralPath generalPath, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        PathWriter.quadTo2(generalPath, d, d2, d3, d4, d5, d6, d7, d8);
    }

    public static void quadTo(PathWriter pathWriter, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        PathWriter.quadTo2(pathWriter, d, d2, d3, d4, d5, d6, d7, d8);
    }

    private static void quadTo2(Object object, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d + d2) / 2.0;
        double d10 = d6 * d * d + d7 * d + d8;
        double d11 = d6 * d9 * d9 + d7 * d9 + d8;
        double d12 = d6 * d2 * d2 + d7 * d2 + d8;
        double d13 = 2.0 * d12 - 4.0 * d11 + 2.0 * d10;
        double d14 = d10;
        double d15 = d12 - d14 - d13;
        d10 = d3 * d * d + d4 * d + d5;
        d11 = d3 * d9 * d9 + d4 * d9 + d5;
        d12 = d3 * d2 * d2 + d4 * d2 + d5;
        double d16 = 2.0 * d12 - 4.0 * d11 + 2.0 * d10;
        double d17 = d10;
        double d18 = d12 - d17 - d16;
        double d19 = (2.0 * d14 + d15) / 2.0;
        double d20 = d13 - d14 + 2.0 * d19;
        double d21 = (2.0 * d17 + d18) / 2.0;
        double d22 = d16 - d17 + 2.0 * d21;
        if (object instanceof GeneralPath) {
            ((GeneralPath)object).quadTo((float)d21, (float)d19, (float)d22, (float)d20);
        } else if (object instanceof PathWriter) {
            ((PathWriter)object).quadTo((float)d21, (float)d19, (float)d22, (float)d20);
        }
    }
}

