/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class MultiThumbSlider
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final String SELECTED_THUMB_PROPERTY = "selected thumb";
    public static final String INVERTED_PROPERTY = "inverted";
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String VALUES_PROPERTY = "values";
    public static final String ADJUST_PROPERTY = "adjusting";
    public static final String PAINT_TICKS_PROPERTY = "paint ticks";
    protected float[] thumbPositions = new float[0];
    Object[] values = new Object[0];
    boolean autoAdd = true;
    boolean adjusting = false;
    int orientation;
    boolean inverted = false;
    boolean paintTicks = false;
    List changeListeners;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public MultiThumbSlider(int n, float[] fArray, Object[] objectArray) {
        this.setOrientation(n);
        this.setValues(fArray, objectArray);
        this.setFocusable(true);
        this.updateUI();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new Vector();
        }
        if (this.changeListeners.contains(changeListener)) {
            return;
        }
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(changeListener);
    }

    protected void fireChangeListeners() {
        if (this.changeListeners == null) {
            return;
        }
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            try {
                ((ChangeListener)this.changeListeners.get(i)).stateChanged(new ChangeEvent(this));
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void transferFocus() {
        this.transferFocus(true);
    }

    private void transferFocus(boolean bl) {
        int n;
        int n2 = n = bl ? 1 : -1;
        if (this.orientation == 1) {
            n *= -1;
        }
        if (this.inverted) {
            n *= -1;
        }
        int n3 = this.getSelectedThumb();
        if (n == 1) {
            if (n3 != this.thumbPositions.length - 1) {
                this.setSelectedThumb(n3 + 1);
                return;
            }
        } else if (n3 != 0) {
            this.setSelectedThumb(n3 - 1);
            return;
        }
        if (bl) {
            super.transferFocus();
        } else {
            super.transferFocusBackward();
        }
    }

    @Override
    public void transferFocusBackward() {
        this.transferFocus(false);
    }

    public abstract Object getValue(float var1);

    public void removeThumb(int n) {
        if (n <= 0 || n > this.thumbPositions.length) {
            throw new IllegalArgumentException("There is not thumb at index " + n + " to remove.");
        }
        float[] fArray = new float[this.thumbPositions.length - 1];
        Object[] objectArray = new Object[this.values.length - 1];
        System.arraycopy(this.thumbPositions, 0, fArray, 0, n);
        System.arraycopy(this.values, 0, objectArray, 0, n);
        System.arraycopy(this.thumbPositions, n + 1, fArray, n, fArray.length - n);
        System.arraycopy(this.values, n + 1, objectArray, n, fArray.length - n);
        this.setValues(fArray, objectArray);
    }

    public boolean doDoubleClick(int n, int n2) {
        return false;
    }

    public boolean doPopup(int n, int n2) {
        return false;
    }

    public boolean isPaintTicks() {
        return this.paintTicks;
    }

    public void setPaintTicks(boolean bl) {
        if (bl == this.paintTicks) {
            return;
        }
        this.paintTicks = bl;
        this.firePropertyChange(PAINT_TICKS_PROPERTY, new Boolean(!bl), new Boolean(bl));
    }

    public int addThumb(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("the new position (" + f + ") must be between zero and one");
        }
        Object object = this.getValue(f);
        float[] fArray = new float[this.thumbPositions.length + 1];
        Object[] objectArray = new Object[this.values.length + 1];
        int n = -1;
        if (f < this.thumbPositions[0]) {
            System.arraycopy(this.thumbPositions, 0, fArray, 1, this.thumbPositions.length);
            System.arraycopy(this.values, 0, objectArray, 1, this.values.length);
            n = 0;
            fArray[0] = f;
            objectArray[0] = object;
        } else if (f > this.thumbPositions[this.thumbPositions.length - 1]) {
            System.arraycopy(this.thumbPositions, 0, fArray, 0, this.thumbPositions.length);
            System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
            n = fArray.length - 1;
            fArray[fArray.length - 1] = f;
            objectArray[objectArray.length - 1] = object;
        } else {
            boolean bl = false;
            for (int i = 0; i < fArray.length; ++i) {
                if (!bl && this.thumbPositions[i] < f) {
                    fArray[i] = this.thumbPositions[i];
                    objectArray[i] = this.values[i];
                    continue;
                }
                if (!bl) {
                    objectArray[i] = object;
                    fArray[i] = f;
                    bl = true;
                    n = i;
                    continue;
                }
                fArray[i] = this.thumbPositions[i - 1];
                objectArray[i] = this.values[i - 1];
            }
        }
        this.setValues(fArray, objectArray);
        return n;
    }

    public void setValueIsAdjusting(boolean bl) {
        if (bl == this.adjusting) {
            return;
        }
        this.adjusting = bl;
        this.firePropertyChange(ADJUST_PROPERTY, new Boolean(!bl), new Boolean(bl));
    }

    public boolean isValueAdjusting() {
        return this.adjusting;
    }

    public float[] getThumbPositions() {
        float[] fArray = new float[this.thumbPositions.length];
        System.arraycopy(this.thumbPositions, 0, fArray, 0, fArray.length);
        return fArray;
    }

    public Object[] getValues() {
        Object[] objectArray = new Object[this.values.length];
        System.arraycopy(this.values, 0, objectArray, 0, objectArray.length);
        return objectArray;
    }

    private static String toString(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < fArray.length; ++i) {
            stringBuffer.append(Float.toString(fArray[i]));
            if (i == fArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void setValues(float[] fArray, Object[] objectArray) {
        int n;
        int n2;
        if (objectArray.length != fArray.length) {
            throw new IllegalArgumentException("there number of positions (" + fArray.length + ") must equal the number of values (" + objectArray.length + ")");
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (objectArray[n2] == null) {
                throw new NullPointerException();
            }
            if (n2 > 0 && fArray[n2] < fArray[n2 - 1]) {
                throw new IllegalArgumentException("the thumb positions must be ascending order (" + MultiThumbSlider.toString(fArray) + ")");
            }
            if (!(fArray[n2] < 0.0f) && !(fArray[n2] > 1.0f)) continue;
            throw new IllegalArgumentException("illegal thumb value " + fArray[n2] + " (must be between zero and one)");
        }
        if (fArray.length == this.thumbPositions.length) {
            n2 = 1;
            for (n = 0; n < fArray.length && n2 != 0; ++n) {
                if (fArray[n] == this.thumbPositions[n]) continue;
                n2 = 0;
            }
            for (n = 0; n < objectArray.length && n2 != 0; ++n) {
                if (objectArray[n].equals(this.values[n])) continue;
                n2 = 0;
            }
            if (n2 != 0) {
                return;
            }
        }
        this.thumbPositions = new float[fArray.length];
        System.arraycopy(fArray, 0, this.thumbPositions, 0, fArray.length);
        this.values = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, this.values, 0, objectArray.length);
        n = n2 = this.getSelectedThumb();
        if (n >= fArray.length) {
            n = fArray.length - 1;
        }
        this.firePropertyChange(VALUES_PROPERTY, null, objectArray);
        if (n2 != n) {
            this.setSelectedThumb(n);
        }
        this.fireChangeListeners();
    }

    public int getThumbCount() {
        return this.thumbPositions.length;
    }

    public void setSelectedThumb(int n) {
        this.putClientProperty(SELECTED_THUMB_PROPERTY, new Integer(n));
    }

    public int getSelectedThumb() {
        return this.getSelectedThumb(true);
    }

    public int getSelectedThumb(boolean bl) {
        if (!this.hasFocus() && bl) {
            return -1;
        }
        Integer n = (Integer)this.getClientProperty(SELECTED_THUMB_PROPERTY);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void setAutoAdding(boolean bl) {
        this.autoAdd = bl;
    }

    public boolean isAutoAdding() {
        return this.autoAdd;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("the orientation must be HORIZONTAL or VERTICAL");
        }
        if (this.orientation == n) {
            return;
        }
        int n2 = this.orientation;
        this.orientation = n;
        this.firePropertyChange(ORIENTATION_PROPERTY, new Integer(n2), new Integer(n));
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean bl) {
        if (this.inverted == bl) {
            return;
        }
        this.inverted = bl;
        this.firePropertyChange(INVERTED_PROPERTY, new Boolean(!bl), new Boolean(bl));
    }
}

