/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.LinearColormap;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;
import java.util.Date;
import java.util.Random;

public class PlasmaFilter
extends WholeImageFilter {
    public float turbulence = 1.0f;
    private float scaling = 0.0f;
    private Colormap colormap = new LinearColormap();
    private Random random = new Random();
    private long seed = 567L;
    private boolean useColormap = false;
    private boolean lessColors = false;

    public void setLessColors(boolean bl) {
        this.lessColors = bl;
    }

    public void setTurbulence(float f) {
        this.turbulence = f;
    }

    public float getTurbulence() {
        return this.turbulence;
    }

    public void setScaling(float f) {
        this.scaling = f;
    }

    public float getScaling() {
        return this.scaling;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setUseColormap(boolean bl) {
        this.useColormap = bl;
    }

    public boolean getUseColormap() {
        return this.useColormap;
    }

    public void setSeed(int n) {
        this.seed = n;
    }

    public int getSeed() {
        return (int)this.seed;
    }

    public void randomize() {
        this.seed = new Date().getTime();
    }

    private int randomRGB() {
        int n = this.random.nextInt(256);
        int n2 = this.random.nextInt(256);
        int n3 = this.random.nextInt(256);
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }

    private int changeColor(int n, float f) {
        if (f < 0.1f) {
            return n;
        }
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        if (this.lessColors) {
            int n5 = (int)((double)f * ((double)this.random.nextFloat() - 0.5));
            int n6 = n2 + n5;
            int n7 = n3 + n5;
            int n8 = n4 + n5;
            int n9 = n6 > 255 ? 255 : (n2 = n6 < 0 ? 0 : n6);
            int n10 = n7 > 255 ? 255 : (n3 = n7 < 0 ? 0 : n7);
            n4 = n8 > 255 ? 255 : (n8 < 0 ? 0 : n8);
        } else {
            int n11 = n2 + (int)((double)f * ((double)this.random.nextFloat() - 0.5));
            int n12 = n3 + (int)((double)f * ((double)this.random.nextFloat() - 0.5));
            int n13 = n4 + (int)((double)f * ((double)this.random.nextFloat() - 0.5));
            n2 = PixelUtils.clamp(n11);
            n3 = PixelUtils.clamp(n12);
            n4 = PixelUtils.clamp(n13);
        }
        return 0xFF000000 | n2 << 16 | n3 << 8 | n4;
    }

    private int average(int n, int n2) {
        int n3 = n >> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = n2 >> 16 & 0xFF;
        int n8 = n2 >> 8 & 0xFF;
        int n9 = n2 & 0xFF;
        n4 = (n4 + n7) / 2;
        n5 = (n5 + n8) / 2;
        n6 = (n6 + n9) / 2;
        return n3 << 24 | n4 << 16 | n5 << 8 | n6;
    }

    private boolean doPlasma(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7) {
        if (n6 == 0) {
            int n8 = nArray[n2 * n5 + n];
            int n9 = nArray[n4 * n5 + n];
            int n10 = nArray[n2 * n5 + n3];
            int n11 = nArray[n4 * n5 + n3];
            float f = 256.0f / (2.0f * (float)n7) * this.turbulence;
            int n12 = (n + n3) / 2;
            int n13 = (n2 + n4) / 2;
            if (n12 == n && n12 == n3 && n13 == n2 && n13 == n4) {
                return true;
            }
            if (n12 != n || n12 != n3) {
                int n14 = this.average(n8, n9);
                nArray[n13 * n5 + n] = n14 = this.changeColor(n14, f);
                if (n != n3) {
                    int n15 = this.average(n10, n11);
                    nArray[n13 * n5 + n3] = n15 = this.changeColor(n15, f);
                }
            }
            if (n13 != n2 || n13 != n4) {
                if (n != n12 || n13 != n4) {
                    int n16 = this.average(n9, n11);
                    nArray[n4 * n5 + n12] = n16 = this.changeColor(n16, f);
                }
                if (n2 != n4) {
                    int n17 = this.average(n8, n10);
                    nArray[n2 * n5 + n12] = n17 = this.changeColor(n17, f);
                }
            }
            if (n2 != n4 || n != n3) {
                int n18 = this.average(n8, n11);
                int n19 = this.average(n9, n10);
                n18 = this.average(n18, n19);
                nArray[n13 * n5 + n12] = n18 = this.changeColor(n18, f);
            }
            return n3 - n >= 3 || n4 - n2 >= 3;
        }
        int n20 = (n + n3) / 2;
        int n21 = (n2 + n4) / 2;
        this.doPlasma(n, n2, n20, n21, nArray, n5, n6 - 1, n7 + 1);
        this.doPlasma(n, n21, n20, n4, nArray, n5, n6 - 1, n7 + 1);
        this.doPlasma(n20, n2, n3, n21, nArray, n5, n6 - 1, n7 + 1);
        return this.doPlasma(n20, n21, n3, n4, nArray, n5, n6 - 1, n7 + 1);
    }

    @Override
    protected int[] filterPixels(int n, int n2, int[] nArray, Rectangle rectangle) {
        int[] nArray2 = new int[n * n2];
        this.random.setSeed(this.seed);
        int n3 = n - 1;
        int n4 = n2 - 1;
        nArray2[0 * n + 0] = this.randomRGB();
        nArray2[0 * n + n3] = this.randomRGB();
        nArray2[n4 * n + 0] = this.randomRGB();
        nArray2[n4 * n + n3] = this.randomRGB();
        nArray2[n4 / 2 * n + n3 / 2] = this.randomRGB();
        nArray2[n4 / 2 * n + 0] = this.randomRGB();
        nArray2[n4 / 2 * n + n3] = this.randomRGB();
        nArray2[0 * n + n3 / 2] = this.randomRGB();
        nArray2[n4 * n + n3 / 2] = this.randomRGB();
        int n5 = 1;
        while (this.doPlasma(0, 0, n - 1, n2 - 1, nArray2, n, n5, 0)) {
            ++n5;
        }
        if (this.useColormap && this.colormap != null) {
            int n6 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray2[n6] = this.colormap.getColor((float)(nArray2[n6] & 0xFF) / 255.0f);
                    ++n6;
                }
            }
        }
        return nArray2;
    }

    public String toString() {
        return "Texture/Plasma...";
    }
}

