/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.ImageMath;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public abstract class TransformFilter
extends AbstractBufferedImageOp {
    public static final int ZERO = 0;
    public static final int CLAMP = 1;
    public static final int WRAP = 2;
    public static final int RGB_CLAMP = 3;
    public static final int NEAREST_NEIGHBOUR = 0;
    public static final int BILINEAR = 1;
    protected int edgeAction = 3;
    protected int interpolation = 1;
    protected Rectangle transformedSpace;
    protected Rectangle originalSpace;

    public void setEdgeAction(int n) {
        this.edgeAction = n;
    }

    public int getEdgeAction() {
        return this.edgeAction;
    }

    public void setInterpolation(int n) {
        this.interpolation = n;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    protected abstract void transformInverse(int var1, int var2, float[] var3);

    protected void transformSpace(Rectangle rectangle) {
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Object object;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        this.originalSpace = new Rectangle(0, 0, n, n2);
        this.transformedSpace = new Rectangle(0, 0, n, n2);
        this.transformSpace(this.transformedSpace);
        if (bufferedImage2 == null) {
            object = bufferedImage.getColorModel();
            bufferedImage2 = new BufferedImage((ColorModel)object, ((ColorModel)object).createCompatibleWritableRaster(this.transformedSpace.width, this.transformedSpace.height), ((ColorModel)object).isAlphaPremultiplied(), null);
        }
        object = this.getRGB(bufferedImage, 0, 0, n, n2, null);
        if (this.interpolation == 0) {
            return this.filterPixelsNN(bufferedImage2, n, n2, (int[])object, this.transformedSpace);
        }
        int n3 = n;
        int n4 = n2;
        int n5 = n - 1;
        int n6 = n2 - 1;
        int n7 = this.transformedSpace.width;
        int n8 = this.transformedSpace.height;
        int[] nArray = new int[n7];
        int n9 = this.transformedSpace.x;
        int n10 = this.transformedSpace.y;
        float[] fArray = new float[2];
        for (int i = 0; i < n8; ++i) {
            for (int j = 0; j < n7; ++j) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                this.transformInverse(n9 + j, n10 + i, fArray);
                int n11 = (int)Math.floor(fArray[0]);
                int n12 = (int)Math.floor(fArray[1]);
                float f = fArray[0] - (float)n11;
                float f2 = fArray[1] - (float)n12;
                if (n11 >= 0 && n11 < n5 && n12 >= 0 && n12 < n6) {
                    int n13 = n3 * n12 + n11;
                    object5 = object[n13];
                    object4 = object[n13 + 1];
                    object3 = object[n13 + n3];
                    object2 = object[n13 + n3 + 1];
                } else {
                    object5 = this.getPixel((int[])object, n11, n12, n3, n4);
                    object4 = this.getPixel((int[])object, n11 + 1, n12, n3, n4);
                    object3 = this.getPixel((int[])object, n11, n12 + 1, n3, n4);
                    object2 = this.getPixel((int[])object, n11 + 1, n12 + 1, n3, n4);
                }
                nArray[j] = ImageMath.bilinearInterpolate(f, f2, object5, object4, object3, (int)object2);
            }
            this.setRGB(bufferedImage2, 0, i, this.transformedSpace.width, 1, nArray);
        }
        return bufferedImage2;
    }

    private final int getPixel(int[] nArray, int n, int n2, int n3, int n4) {
        if (n < 0 || n >= n3 || n2 < 0 || n2 >= n4) {
            switch (this.edgeAction) {
                default: {
                    return 0;
                }
                case 2: {
                    return nArray[ImageMath.mod(n2, n4) * n3 + ImageMath.mod(n, n3)];
                }
                case 1: {
                    return nArray[ImageMath.clamp(n2, 0, n4 - 1) * n3 + ImageMath.clamp(n, 0, n3 - 1)];
                }
                case 3: 
            }
            return nArray[ImageMath.clamp(n2, 0, n4 - 1) * n3 + ImageMath.clamp(n, 0, n3 - 1)] & 0xFFFFFF;
        }
        return nArray[n2 * n3 + n];
    }

    protected BufferedImage filterPixelsNN(BufferedImage bufferedImage, int n, int n2, int[] nArray, Rectangle rectangle) {
        int n3 = n;
        int n4 = n2;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int[] nArray2 = new int[n5];
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        float[] fArray = new float[2];
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                int n9;
                this.transformInverse(n7 + j, n8 + i, fArray);
                int n10 = (int)fArray[0];
                int n11 = (int)fArray[1];
                if (fArray[0] < 0.0f || n10 >= n3 || fArray[1] < 0.0f || n11 >= n4) {
                    switch (this.edgeAction) {
                        default: {
                            n9 = 0;
                            break;
                        }
                        case 2: {
                            n9 = nArray[ImageMath.mod(n11, n4) * n3 + ImageMath.mod(n10, n3)];
                            break;
                        }
                        case 1: {
                            n9 = nArray[ImageMath.clamp(n11, 0, n4 - 1) * n3 + ImageMath.clamp(n10, 0, n3 - 1)];
                            break;
                        }
                        case 3: {
                            n9 = nArray[ImageMath.clamp(n11, 0, n4 - 1) * n3 + ImageMath.clamp(n10, 0, n3 - 1)] & 0xFFFFFF;
                        }
                    }
                    nArray2[j] = n9;
                    continue;
                }
                n9 = n3 * n11 + n10;
                nArray2[j] = nArray[n9];
            }
            this.setRGB(bufferedImage, 0, i, rectangle.width, 1, nArray2);
        }
        return bufferedImage;
    }
}

