/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.MenuElement;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.swingx.ForwardingRepaintManager;
import org.jdesktop.swingx.RepaintManagerX;
import org.jdesktop.swingx.TranslucentRepaintManager;

public final class SwingXUtilities {
    private static String STYLESHEET = "body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: %s; font-size: %dpt;  }a, p, li { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: %s; font-size: %dpt;  }";

    private SwingXUtilities() {
    }

    public static void updateMnemonicBinding(JComponent jComponent, String string) {
        SwingXUtilities.updateMnemonicBinding(jComponent, string, null);
    }

    public static void updateMnemonicBinding(JComponent jComponent, String string, String string2) {
        Object object;
        Class<?> clazz = jComponent.getClass();
        int n = -1;
        try {
            object = clazz.getMethod("getMnemonic", new Class[0]);
            n = (Integer)((Method)object).invoke((Object)jComponent, new Object[0]);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("unable to access mnemonic", exception);
        }
        object = SwingUtilities.getUIInputMap(jComponent, 2);
        if (n != 0) {
            if (object == null) {
                object = new ComponentInputMapUIResource(jComponent);
                SwingUtilities.replaceUIInputMap(jComponent, 2, (InputMap)object);
            }
            ((InputMap)object).clear();
            ((InputMap)object).put(KeyStroke.getKeyStroke(n, 8, false), string);
            ((InputMap)object).put(KeyStroke.getKeyStroke(n, 8, true), string2);
            ((InputMap)object).put(KeyStroke.getKeyStroke(n, 0, true), string2);
        } else if (object != null) {
            ((InputMap)object).clear();
        }
    }

    private static Component[] getChildren(Component component) {
        Component[] componentArray = null;
        if (component instanceof MenuElement) {
            MenuElement[] menuElementArray = ((MenuElement)((Object)component)).getSubElements();
            componentArray = new Component[menuElementArray.length];
            for (int i = 0; i < menuElementArray.length; ++i) {
                componentArray[i] = menuElementArray[i].getComponent();
            }
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        return componentArray;
    }

    public static void setComponentTreeEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        Component[] componentArray = SwingXUtilities.getChildren(component);
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                SwingXUtilities.setComponentTreeEnabled(componentArray[i], bl);
            }
        }
    }

    public static void setComponentTreeLocale(Component component, Locale locale) {
        component.setLocale(locale);
        Component[] componentArray = SwingXUtilities.getChildren(component);
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                SwingXUtilities.setComponentTreeLocale(componentArray[i], locale);
            }
        }
    }

    public static void setComponentTreeBackground(Component component, Color color) {
        component.setBackground(color);
        Component[] componentArray = SwingXUtilities.getChildren(component);
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                SwingXUtilities.setComponentTreeBackground(componentArray[i], color);
            }
        }
    }

    public static void setComponentTreeForeground(Component component, Color color) {
        component.setForeground(color);
        Component[] componentArray = SwingXUtilities.getChildren(component);
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                SwingXUtilities.setComponentTreeForeground(componentArray[i], color);
            }
        }
    }

    public static void setComponentTreeFont(Component component, Font font) {
        component.setFont(font);
        Component[] componentArray = SwingXUtilities.getChildren(component);
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                SwingXUtilities.setComponentTreeFont(componentArray[i], font);
            }
        }
    }

    public static void setHtmlFont(HTMLDocument hTMLDocument, Font font) {
        String string = String.format(STYLESHEET, font.getName(), font.getSize(), font.getName(), font.getSize());
        try {
            hTMLDocument.getStyleSheet().loadRules(new StringReader(string), null);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static void updateAllComponentTreeUIs() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    public static void updateAllComponentTreeUIs(Window window) {
        SwingUtilities.updateComponentTreeUI(window);
        for (Window window2 : window.getOwnedWindows()) {
            SwingXUtilities.updateAllComponentTreeUIs(window2);
        }
    }

    public static <T> T getAncestor(Class<T> clazz, Component component) {
        if (clazz == null || component == null) {
            return null;
        }
        Container container = component.getParent();
        while (container != null && !clazz.isInstance(container)) {
            container = container instanceof JPopupMenu ? ((JPopupMenu)container).getInvoker() : container.getParent();
        }
        return (T)container;
    }

    public static boolean isDescendingFrom(Component component, Component component2) {
        while (component != null) {
            if (component instanceof JPopupMenu && (component = ((JPopupMenu)component).getInvoker()) == null) {
                return false;
            }
            if (component == component2) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    static RepaintManager getTranslucentRepaintManager(RepaintManager repaintManager) {
        RepaintManager repaintManager2 = repaintManager;
        while (repaintManager2 != null && !repaintManager2.getClass().isAnnotationPresent(TranslucentRepaintManager.class)) {
            if (repaintManager2 instanceof ForwardingRepaintManager) {
                repaintManager2 = ((ForwardingRepaintManager)repaintManager2).getDelegateManager();
                continue;
            }
            repaintManager2 = null;
        }
        return repaintManager2 == null ? new RepaintManagerX(repaintManager) : repaintManager;
    }

    public static boolean isUIInstallable(Object object) {
        return object == null || object instanceof UIResource;
    }

    public static void setLeadAnchorWithoutSelection(ListSelectionModel listSelectionModel, int n, int n2) {
        if (n2 == -1) {
            n2 = n;
        }
        if (n == -1) {
            listSelectionModel.setAnchorSelectionIndex(-1);
            listSelectionModel.setLeadSelectionIndex(-1);
        } else {
            if (listSelectionModel.isSelectedIndex(n)) {
                listSelectionModel.addSelectionInterval(n, n);
            } else {
                listSelectionModel.removeSelectionInterval(n, n);
            }
            listSelectionModel.setAnchorSelectionIndex(n2);
        }
    }

    public static boolean shouldIgnore(MouseEvent mouseEvent, JComponent jComponent) {
        return jComponent == null || !jComponent.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isConsumed();
    }

    public static int loc2IndexFileList(JList jList, Point point) {
        Object object;
        int n = jList.locationToIndex(point);
        if (n != -1 && (object = jList.getClientProperty("List.isFileList")) instanceof Boolean && ((Boolean)object).booleanValue() && !SwingXUtilities.pointIsInActualBounds(jList, n, point)) {
            n = -1;
        }
        return n;
    }

    private static boolean pointIsInActualBounds(JList jList, int n, Point point) {
        ListCellRenderer listCellRenderer = jList.getCellRenderer();
        ListModel listModel = jList.getModel();
        Object e = listModel.getElementAt(n);
        Component component = listCellRenderer.getListCellRendererComponent(jList, e, n, false, false);
        Dimension dimension = component.getPreferredSize();
        Rectangle rectangle = jList.getCellBounds(n, n);
        if (!component.getComponentOrientation().isLeftToRight()) {
            rectangle.x += rectangle.width - dimension.width;
        }
        rectangle.width = dimension.width;
        return rectangle.contains(point);
    }

    public static void adjustFocus(JComponent jComponent) {
        if (!jComponent.hasFocus() && jComponent.isRequestFocusEnabled()) {
            jComponent.requestFocus();
        }
    }

    public static int convertModifiersToDropAction(int n, int n2) {
        int n3 = 0;
        switch (n & 0xC0) {
            case 192: {
                n3 = 0x40000000;
                break;
            }
            case 128: {
                n3 = 1;
                break;
            }
            case 64: {
                n3 = 2;
                break;
            }
            default: {
                if ((n2 & 2) != 0) {
                    n3 = 2;
                    break;
                }
                if ((n2 & 1) != 0) {
                    n3 = 1;
                    break;
                }
                if ((n2 & 0x40000000) == 0) break;
                n3 = 0x40000000;
            }
        }
        return n3 & n2;
    }
}

