/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.lang.ref.SoftReference;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.painter.Painter;

public abstract class AbstractPainter<T>
extends AbstractBean
implements Painter<T> {
    private transient SoftReference<BufferedImage> cachedImage;
    private boolean cacheCleared = true;
    private boolean cacheable = false;
    private boolean dirty = false;
    private BufferedImageOp[] filters = new BufferedImageOp[0];
    private boolean antialiasing = true;
    private Interpolation interpolation = Interpolation.NearestNeighbor;
    private boolean visible = true;

    public AbstractPainter() {
    }

    public AbstractPainter(boolean bl) {
        this.setCacheable(bl);
    }

    public final BufferedImageOp[] getFilters() {
        BufferedImageOp[] bufferedImageOpArray = new BufferedImageOp[this.filters.length];
        System.arraycopy(this.filters, 0, bufferedImageOpArray, 0, bufferedImageOpArray.length);
        return bufferedImageOpArray;
    }

    public void setFilters(BufferedImageOp ... bufferedImageOpArray) {
        if (bufferedImageOpArray == null) {
            bufferedImageOpArray = new BufferedImageOp[]{};
        }
        BufferedImageOp[] bufferedImageOpArray2 = this.getFilters();
        this.filters = new BufferedImageOp[bufferedImageOpArray == null ? 0 : bufferedImageOpArray.length];
        System.arraycopy(bufferedImageOpArray, 0, this.filters, 0, this.filters.length);
        this.setDirty(true);
        this.firePropertyChange("filters", bufferedImageOpArray2, this.getFilters());
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(boolean bl) {
        boolean bl2 = this.isAntialiasing();
        this.antialiasing = bl;
        if (bl2 != bl) {
            this.setDirty(true);
        }
        this.firePropertyChange("antialiasing", bl2, this.isAntialiasing());
    }

    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(Interpolation interpolation) {
        Interpolation interpolation2 = this.getInterpolation();
        Interpolation interpolation3 = this.interpolation = interpolation == null ? Interpolation.NearestNeighbor : interpolation;
        if (interpolation2 != interpolation) {
            this.setDirty(true);
        }
        this.firePropertyChange("interpolation", (Object)interpolation2, (Object)this.getInterpolation());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        this.visible = bl;
        if (bl2 != bl) {
            this.setDirty(true);
        }
        this.firePropertyChange("visible", bl2, this.isVisible());
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean bl) {
        boolean bl2 = this.isCacheable();
        this.cacheable = bl;
        this.firePropertyChange("cacheable", bl2, this.isCacheable());
        if (!this.isCacheable()) {
            this.clearCache();
        }
    }

    public void clearCache() {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = bufferedImage = this.cachedImage == null ? null : this.cachedImage.get();
        if (bufferedImage != null) {
            bufferedImage.flush();
        }
        this.cacheCleared = true;
        if (!this.isCacheable()) {
            this.cachedImage = null;
        }
    }

    boolean isCacheCleared() {
        return this.cacheCleared;
    }

    protected void validate(T t) {
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean bl) {
        boolean bl2 = this.isDirty();
        this.dirty = bl;
        this.firePropertyChange("dirty", bl2, this.isDirty());
        if (this.isDirty()) {
            this.clearCache();
        }
    }

    protected boolean shouldUseCache() {
        return this.isCacheable() || this.filters.length > 0;
    }

    protected void configureGraphics(Graphics2D graphics2D) {
        if (this.isAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.getInterpolation().configureGraphics(graphics2D);
    }

    protected abstract void doPaint(Graphics2D var1, T var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paint(Graphics2D graphics2D, T t, int n, int n2) {
        if (graphics2D == null) {
            throw new NullPointerException("The Graphics2D must be supplied");
        }
        if (!this.isVisible() || n < 1 || n2 < 1) {
            return;
        }
        this.configureGraphics(graphics2D);
        if (this.shouldUseCache() || this.filters.length > 0) {
            boolean bl;
            this.validate(t);
            BufferedImage bufferedImage = this.cachedImage == null ? null : this.cachedImage.get();
            boolean bl2 = bl = null == bufferedImage || bufferedImage.getWidth() != n || bufferedImage.getHeight() != n2;
            if (this.cacheCleared || bl || this.isDirty()) {
                if (bl) {
                    bufferedImage = GraphicsUtilities.createCompatibleTranslucentImage(n, n2);
                }
                Graphics2D graphics2D2 = bufferedImage.createGraphics();
                try {
                    graphics2D2.setClip(0, 0, n, n2);
                    if (!bl) {
                        BufferedImageOp[] bufferedImageOpArray = graphics2D2.getComposite();
                        graphics2D2.setComposite(AlphaComposite.Clear);
                        graphics2D2.fillRect(0, 0, n, n2);
                        graphics2D2.setComposite((Composite)bufferedImageOpArray);
                    }
                    this.configureGraphics(graphics2D2);
                    this.doPaint(graphics2D2, t, n, n2);
                }
                finally {
                    graphics2D2.dispose();
                }
                for (BufferedImageOp bufferedImageOp : this.getFilters()) {
                    bufferedImage = bufferedImageOp.filter(bufferedImage, null);
                }
                if (this.shouldUseCache()) {
                    this.cachedImage = new SoftReference<BufferedImage>(bufferedImage);
                    this.cacheCleared = false;
                }
            }
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        } else {
            this.doPaint(graphics2D, t, n, n2);
        }
        this.setDirty(false);
    }

    public static enum Interpolation {
        Bicubic(RenderingHints.VALUE_INTERPOLATION_BICUBIC),
        Bilinear(RenderingHints.VALUE_INTERPOLATION_BILINEAR),
        NearestNeighbor(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);

        private Object value;

        private Interpolation(Object object) {
            this.value = object;
        }

        private void configureGraphics(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.value);
        }
    }
}

